/*
 * Decompiled with CFR 0.152.
 */
package chat;

import chat.ChatRepository;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.Collator;
import java.util.StringTokenizer;
import java.util.Vector;

public class XList
extends Panel
implements MouseListener,
MouseMotionListener,
KeyListener,
AdjustmentListener {
    private static final int VERTICAL_CELL_SPACING = 2;
    private static final int HORIZONTAL_CELL_SPACING = 4;
    private static final int MINIMUM_COLUMNWIDTH = 30;
    private static final int MINIMUM_VISIBLELINES = 4;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int FLOW = 2;
    private static final int SCROLLBAR_WIDTH = 16;
    private Vector[] vecContent;
    private Vector vecKey;
    private Vector vecColor;
    private Scrollbar scbBar;
    private int iNrOfColumns;
    private int iSelectedRow;
    private int iNrOfLines;
    private int iFirstVisibleLine;
    private int iNrOfVisibleLines;
    private int iColumnDraggedX;
    private int iColumnSeparator;
    private int iSortCriteria;
    private Font fntFont = ChatRepository.FIXED_FONT;
    private int[] iColumnWidth;
    private int[] iColumnOrientation;
    private int[] iNrOfLinesPerRow;
    private int[] iNrOfLinesUntilRow;
    private String[] strColumnHeader;
    private boolean bSelectable;
    private boolean bSorted;
    private Image imgBuffer;
    private Vector vecRowSplitter;

    public XList(int n) {
        this.iNrOfColumns = Math.max(n, 1);
        this.iNrOfVisibleLines = 4;
        this.iFirstVisibleLine = 0;
        this.bSelectable = true;
        this.bSorted = false;
        this.iSortCriteria = 0;
        this.iSelectedRow = 0;
        this.vecContent = new Vector[this.iNrOfColumns];
        this.vecKey = new Vector();
        this.vecColor = new Vector();
        this.strColumnHeader = new String[this.iNrOfColumns];
        this.iColumnOrientation = new int[this.iNrOfColumns];
        this.iColumnWidth = new int[this.iNrOfColumns];
        int n2 = 0;
        while (n2 < this.iNrOfColumns) {
            this.vecContent[n2] = new Vector();
            this.strColumnHeader[n2] = "";
            this.iColumnOrientation[n2] = 2;
            ++n2;
        }
        this.scbBar = new Scrollbar(1, 0, 0, 0, 0);
        this.setLayout(new BorderLayout());
        this.add("East", this.scbBar);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.scbBar.addAdjustmentListener(this);
        this.setSize(this.getPreferredSize());
    }

    public void setColumnHeaders(String[] stringArray) {
        if (stringArray.length == this.iNrOfColumns) {
            this.strColumnHeader = stringArray;
        }
        this.repaint();
    }

    public void setColumnWidths(int[] nArray) {
        if (nArray.length == this.iNrOfColumns) {
            this.iColumnWidth = nArray;
        }
        this.setSize(this.getPreferredSize());
        this.invalidateWrapping();
    }

    public void setColumnOrientations(int[] nArray) {
        if (nArray.length == this.iNrOfColumns) {
            this.iColumnOrientation = nArray;
        }
        this.invalidateWrapping();
        this.repaint();
    }

    public synchronized void clear() {
        int n = 0;
        while (n < this.iNrOfColumns) {
            this.vecContent[n] = new Vector();
            ++n;
        }
        this.vecKey = new Vector();
        this.vecColor = new Vector();
        this.iNrOfLines = 0;
        this.iFirstVisibleLine = 0;
        this.iSelectedRow = 0;
        this.invalidateWrapping();
        this.repaint();
    }

    public void setCellText(int n, int n2, String string) {
        if (n < this.getNrOfRows() && n2 < this.iNrOfColumns) {
            this.vecContent[n2].removeElementAt(n);
            this.vecContent[n2].insertElementAt(string, n);
            this.invalidateWrapping();
            this.repaint();
        }
    }

    public String getCellText(int n, int n2) {
        if (n < this.getNrOfRows() && n2 < this.iNrOfColumns) {
            return (String)this.vecContent[n2].elementAt(n);
        }
        return "";
    }

    public void setRowColor(int n, Color color) {
        if (n < this.getNrOfRows()) {
            this.vecColor.setElementAt(color, n);
            this.repaint();
        }
    }

    public synchronized void addRow(String[] stringArray) {
        this.addRow(stringArray, -1, Color.black);
    }

    public synchronized void addRow(String[] stringArray, int n, Color color) {
        if (stringArray.length == this.iNrOfColumns) {
            if (this.bSorted) {
                this.addSortedRow(stringArray, n, color);
            } else {
                int n2 = 0;
                while (n2 < this.iNrOfColumns) {
                    this.vecContent[n2].addElement(stringArray[n2]);
                    ++n2;
                }
                this.vecKey.addElement(new Integer(n));
                this.vecColor.addElement(color);
            }
            this.invalidateWrapping();
            this.repaint();
        }
    }

    private synchronized void addSortedRow(String[] stringArray, int n, Color color) {
        int n2 = this.getSortedRowIndex(stringArray[this.iSortCriteria]);
        int n3 = 0;
        while (n3 < this.iNrOfColumns) {
            this.vecContent[n3].insertElementAt(stringArray[n3], n2);
            ++n3;
        }
        this.vecKey.insertElementAt(new Integer(n), n2);
        this.vecColor.insertElementAt(color, n2);
        this.invalidateWrapping();
        this.repaint();
    }

    private synchronized int getSortedRowIndex(String string) {
        int n = this.getNrOfRows();
        Vector vector = this.vecContent[this.iSortCriteria];
        Collator collator = Collator.getInstance();
        if (n == 0) {
            return 0;
        }
        if (collator.compare(string, (String)vector.elementAt(0)) <= 0) {
            return 0;
        }
        if (collator.compare(string, (String)vector.elementAt(n - 1)) >= 0) {
            return n;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = n - 1;
        while (true) {
            if (collator.compare(string, (String)vector.elementAt((n2 = (n3 + n4) / 2 + 1) - 1)) < 0) {
                n4 = n2 - 1;
                continue;
            }
            if (collator.compare(string, (String)vector.elementAt(n2)) <= 0) break;
            n3 = n2;
        }
        return n2;
    }

    public int getKey(int n) {
        return (Integer)this.vecKey.elementAt(n);
    }

    public int getNrOfRows() {
        return this.vecContent[0].size();
    }

    public int getSelectedRow() {
        return this.iSelectedRow;
    }

    public void setSelectable(boolean bl) {
        this.bSelectable = bl;
        this.repaint();
    }

    public void setSorted(boolean bl) {
        this.bSorted = bl;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        this.iNrOfVisibleLines = dimension.height / this.getLineHeight();
        this.repaint();
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.iNrOfVisibleLines = n2 / this.getLineHeight();
        this.repaint();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.iNrOfVisibleLines = n4 / this.getLineHeight();
        this.repaint();
    }

    public Dimension getPreferredSize() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.iNrOfColumns) {
            n += this.iColumnWidth[n2];
            ++n2;
        }
        return new Dimension(n + 16, this.getLineHeight() * (this.iNrOfVisibleLines + 1));
    }

    private int getLineHeight() {
        return this.getFontMetrics(this.fntFont).getAscent() + this.getFontMetrics(this.fntFont).getDescent() + 4;
    }

    private Point getRightTextPosition(int n, int n2, String string) {
        Point point = this.getLeftTextPosition(n, n2);
        return new Point(point.x + (this.iColumnWidth[n] - 8 - this.getFontMetrics(this.fntFont).stringWidth(string)), point.y);
    }

    private Point getLeftTextPosition(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            n3 += this.iColumnWidth[n4];
            ++n4;
        }
        return new Point(n3 + 4, this.getLineHeight() * (n2 - this.iFirstVisibleLine + 2) - this.getFontMetrics(this.fntFont).getDescent() - 2);
    }

    private Rectangle getLineRectangle(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.iNrOfColumns) {
            n2 += this.iColumnWidth[n3];
            ++n3;
        }
        return new Rectangle(1, this.getLineHeight() * (n - this.iFirstVisibleLine + 1), n2, this.getLineHeight());
    }

    private synchronized String[][] getRowSplitter(int n) {
        String[][] stringArray = new String[this.iNrOfColumns][];
        Vector[] vectorArray = new Vector[this.iNrOfColumns];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.iNrOfColumns) {
            if (this.iColumnOrientation[n3] == 2) {
                vectorArray[n3] = this.getCellTextSplitter(n3, n);
            } else {
                vectorArray[n3] = new Vector();
                vectorArray[n3].addElement(this.getFormatedText(n < this.vecContent[n3].size() ? (String)this.vecContent[n3].elementAt(n) : "", n3, this.iColumnOrientation[n3]));
            }
            n2 = Math.max(n2, vectorArray[n3].size());
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.iNrOfColumns) {
            stringArray[n4] = new String[n2];
            int n5 = 0;
            while (n5 < n2) {
                stringArray[n4][n5] = n5 < vectorArray[n4].size() ? (String)vectorArray[n4].elementAt(n5) : "";
                ++n5;
            }
            ++n4;
        }
        return stringArray;
    }

    private synchronized String getWrappedText(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        int n2 = string.indexOf("\n");
        if (n2 != -1) {
            stringBuffer.append(this.getWrappedText(string.substring(0, n2), n));
            stringBuffer.append("\n");
            stringBuffer.append(this.getWrappedText(string.substring(n2 + 1), n));
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            FontMetrics fontMetrics = this.getFontMetrics(this.fntFont);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (fontMetrics.stringWidth(string2) < n) {
                    stringBuffer.append(string2);
                    stringBuffer.append(" ");
                    continue;
                }
                StringBuffer stringBuffer2 = new StringBuffer(string2.length());
                int n3 = 0;
                int n4 = 0;
                while (n4 < string2.length() && n3 + fontMetrics.charWidth(string2.charAt(n4)) < n) {
                    n3 += fontMetrics.charWidth(string2.charAt(n4));
                    stringBuffer2.append(string2.charAt(n4));
                    ++n4;
                }
                stringBuffer.append((Object)stringBuffer2);
                stringBuffer.append(" ");
                stringBuffer.append(this.getWrappedText(string2.substring(stringBuffer2.length()), n));
                stringBuffer.append(" ");
            }
        }
        return stringBuffer.toString();
    }

    private synchronized String getFormatedText(String string, int n, int n2) {
        FontMetrics fontMetrics = this.getFontMetrics(this.fntFont);
        int n3 = this.iColumnWidth[n] - 8;
        StringBuffer stringBuffer = new StringBuffer(string.length() + 2);
        int n4 = fontMetrics.stringWidth("...");
        if (n2 == 0 || n2 == 1) {
            if (fontMetrics.stringWidth(string) <= n3) {
                return string;
            }
            int n5 = 0;
            if (n2 == 1) {
                int n6 = string.length() - 1;
                while (n6 >= 0 && n5 + n4 + fontMetrics.charWidth(string.charAt(n6)) < n3) {
                    n5 += fontMetrics.charWidth(string.charAt(n6));
                    stringBuffer.insert(0, string.charAt(n6));
                    --n6;
                }
                stringBuffer.insert(0, "...");
            } else {
                int n7 = 0;
                while (n7 < string.length() && n5 + n4 + fontMetrics.charWidth(string.charAt(n7)) < n3) {
                    n5 += fontMetrics.charWidth(string.charAt(n7));
                    stringBuffer.append(string.charAt(n7));
                    ++n7;
                }
                stringBuffer.append("...");
            }
        }
        return stringBuffer.toString();
    }

    private synchronized Vector getCellTextSplitter(int n, int n2) {
        Vector<String> vector = new Vector<String>();
        FontMetrics fontMetrics = this.getFontMetrics(this.fntFont);
        int n3 = this.iColumnWidth[n] - 8;
        StringTokenizer stringTokenizer = new StringTokenizer(this.getWrappedText((String)this.vecContent[n].elementAt(n2), n3), " ");
        String string = "";
        while (stringTokenizer.hasMoreTokens()) {
            int n4;
            String string2 = stringTokenizer.nextToken();
            String string3 = this.getLineStarter(string);
            int n5 = string2.indexOf("\n");
            if (n5 == -1) {
                n4 = fontMetrics.stringWidth(string3) + fontMetrics.stringWidth(string2);
                if (n4 < n3) {
                    string = new StringBuffer(string3.length() + string2.length()).append(string3).append(string2).toString();
                    continue;
                }
                if (n4 < n3) continue;
                vector.addElement(string);
                string = string2;
                continue;
            }
            String string4 = string2.substring(0, n5);
            n4 = fontMetrics.stringWidth(string3) + fontMetrics.stringWidth(string4);
            if (n4 < n3) {
                vector.addElement(new StringBuffer(string3.length() + string4.length()).append(string3).append(string4).toString());
                string = string2.substring(n5 + 1);
                continue;
            }
            vector.addElement(string);
            if (n5 != 0) {
                vector.addElement(string4);
            }
            string = string2.substring(n5 + 1);
        }
        vector.addElement(string);
        return vector;
    }

    private String getLineStarter(String string) {
        if (string.equals("")) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 1);
        stringBuffer.append(string);
        stringBuffer.append(" ");
        return stringBuffer.toString();
    }

    private void updateScrollbar() {
        this.scbBar.setValues(this.iFirstVisibleLine, this.iNrOfVisibleLines, 0, this.iNrOfLines + this.iNrOfVisibleLines - 1);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public synchronized void invalidateWrapping() {
        this.vecRowSplitter = null;
    }

    public synchronized void paint(Graphics graphics) {
        Point point;
        boolean bl;
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        if (this.imgBuffer == null || this.imgBuffer.getWidth(this) != n || this.imgBuffer.getHeight(this) != n2) {
            this.imgBuffer = this.createImage(n, n2);
        }
        Graphics graphics2 = this.imgBuffer.getGraphics();
        graphics2.setColor(Color.white);
        graphics2.fillRect(0, 0, n - 1, n2 - 1);
        int n3 = this.getNrOfRows();
        int n4 = this.getLineHeight();
        graphics2.setFont(this.fntFont);
        this.iNrOfLinesPerRow = new int[n3];
        this.iNrOfLinesUntilRow = new int[n3];
        int n5 = 0;
        boolean bl2 = bl = this.vecRowSplitter == null;
        if (bl) {
            this.vecRowSplitter = new Vector();
        }
        int n6 = 0;
        while (n6 < n3) {
            String[][] stringArray;
            if (bl) {
                stringArray = this.getRowSplitter(n6);
                this.vecRowSplitter.addElement(stringArray);
            } else {
                stringArray = (String[][])this.vecRowSplitter.elementAt(n6);
            }
            this.iNrOfLinesPerRow[n6] = stringArray[0].length;
            this.iNrOfLinesUntilRow[n6] = n5;
            int n7 = 0;
            while (n7 < this.iNrOfLinesPerRow[n6]) {
                if (n5 >= this.iFirstVisibleLine && n5 <= this.iFirstVisibleLine + this.iNrOfVisibleLines) {
                    if (n6 == this.iSelectedRow && this.bSelectable) {
                        Rectangle rectangle = this.getLineRectangle(n5);
                        graphics2.setColor(Color.gray);
                        graphics2.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        graphics2.setColor(Color.white);
                    } else if (this.vecColor.size() > n6) {
                        graphics2.setColor((Color)this.vecColor.elementAt(n6));
                    }
                    int n8 = 0;
                    while (n8 < this.iNrOfColumns) {
                        point = this.iColumnOrientation[n8] == 1 ? this.getRightTextPosition(n8, n5, stringArray[n8][n7]) : this.getLeftTextPosition(n8, n5);
                        graphics2.drawString(stringArray[n8][n7], point.x, point.y);
                        ++n8;
                    }
                }
                ++n5;
                ++n7;
            }
            ++n6;
        }
        if (n3 > 0) {
            this.iNrOfLines = this.iNrOfLinesUntilRow[n3 - 1] + this.iNrOfLinesPerRow[n3 - 1];
        }
        graphics2.setColor(Color.lightGray);
        graphics2.fillRect(1, 0, n - 1, n4 - 1);
        int n9 = 1;
        int n10 = 0;
        while (n10 < this.iNrOfColumns) {
            graphics2.setColor(Color.white);
            graphics2.drawLine(n9, 1, n9 + this.iColumnWidth[n10] - 2, 1);
            graphics2.drawLine(n9, 1, n9, n4 - 1);
            graphics2.setColor(Color.darkGray);
            graphics2.drawLine(n9, n4 - 1, n9 + this.iColumnWidth[n10] - 2, n4 - 1);
            graphics2.drawLine(n9 + this.iColumnWidth[n10] - 1, 1, n9 + this.iColumnWidth[n10] - 1, n4 - 1);
            graphics2.setColor(Color.black);
            graphics2.drawLine(n9 + this.iColumnWidth[n10] - 1, 1, n9 + this.iColumnWidth[n10] - 1, n2);
            n9 += this.iColumnWidth[n10];
            String string = this.getFormatedText(this.strColumnHeader[n10], n10, this.iColumnOrientation[n10] == 1 ? 1 : 0);
            point = this.iColumnOrientation[n10] == 1 ? this.getRightTextPosition(n10, this.iFirstVisibleLine - 1, string) : this.getLeftTextPosition(n10, this.iFirstVisibleLine - 1);
            graphics2.drawString(string, point.x, point.y);
            ++n10;
        }
        graphics2.setColor(Color.black);
        graphics2.drawRect(0, 0, n - 1, n2 - 1);
        graphics.drawImage(this.imgBuffer, 0, 0, this);
        this.updateScrollbar();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n;
        if (this.getCursor().getType() == 11 && this.iColumnWidth[this.iColumnSeparator] + (n = mouseEvent.getX() - this.iColumnDraggedX) >= 30 && this.iColumnWidth[this.iColumnSeparator + 1] - n >= 30) {
            int n2 = this.iColumnSeparator;
            this.iColumnWidth[n2] = this.iColumnWidth[n2] + n;
            int n3 = this.iColumnSeparator + 1;
            this.iColumnWidth[n3] = this.iColumnWidth[n3] - n;
            this.iColumnDraggedX = mouseEvent.getX();
            this.invalidateWrapping();
            this.repaint();
            if (this.iFirstVisibleLine > this.iNrOfLines - 1) {
                this.scrollTo(this.iNrOfLines - 1);
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.getCursor().getType() == 11 && this.getColumnSeparator(mouseEvent.getX()) == -1) {
            this.setCursor(new Cursor(0));
            return;
        }
        if (this.getCursor().getType() == 0 && (this.iColumnSeparator = this.getColumnSeparator(this.iColumnDraggedX = mouseEvent.getX())) != -1) {
            this.setCursor(new Cursor(11));
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.bSelectable) {
            if (keyEvent.getKeyCode() == 40 && this.iSelectedRow < this.getNrOfRows() - 1) {
                ++this.iSelectedRow;
                if (!this.rowIsVisible(this.iSelectedRow)) {
                    this.scrollTo(this.iNrOfLinesUntilRow[this.iSelectedRow] + this.iNrOfLinesPerRow[this.iSelectedRow] - this.iNrOfVisibleLines);
                    return;
                }
                this.repaint();
                return;
            }
            if (keyEvent.getKeyCode() == 38 && this.iSelectedRow > 0) {
                --this.iSelectedRow;
                if (!this.rowIsVisible(this.iSelectedRow)) {
                    this.scrollTo(this.iNrOfLinesUntilRow[this.iSelectedRow]);
                    return;
                }
                this.repaint();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n;
        if (this.bSelectable && (n = this.getRowAtPixel(mouseEvent.getY())) != -1 && n != this.iSelectedRow) {
            this.iSelectedRow = this.getRowAtPixel(mouseEvent.getY());
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.scrollTo(adjustmentEvent.getValue());
    }

    private void scrollTo(int n) {
        if (n >= 0 && n < this.iNrOfLines && n != this.iFirstVisibleLine) {
            this.iFirstVisibleLine = n;
            this.repaint();
        }
    }

    private boolean rowIsVisible(int n) {
        return n >= this.getRowOfLine(this.iFirstVisibleLine) && (this.iNrOfLines < this.iNrOfVisibleLines || n <= this.getRowOfLine(this.iFirstVisibleLine + this.iNrOfVisibleLines - 1));
    }

    private int getRowOfLine(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.getNrOfRows()) {
            if ((n2 += this.iNrOfLinesPerRow[n3]) > n) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private int getRowAtPixel(int n) {
        if (n > this.getLineHeight()) {
            return this.getRowOfLine(this.iFirstVisibleLine + n / this.getLineHeight() - 1);
        }
        return -1;
    }

    public int getColumnSeparator(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.iNrOfColumns - 1) {
            if ((n2 += this.iColumnWidth[n3]) - 4 <= n && n <= n2 + 4) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }
}

