/*
 * Decompiled with CFR 0.152.
 */
package chat;

import chat.Balloon;
import chat.ChatApplet;
import chat.ChatRepository;
import chat.Cube3D;
import chat.HistoryEntry;
import chat.Image3D;
import chat.Light;
import chat.Object3D;
import chat.Orientation;
import chat.Plane3D;
import chat.Polygon3D;
import chat.Texture3D;
import chat.User;
import chat.Vertex3D;
import chat.ViewPoint;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

public class ViewCanvas
extends Canvas
implements Runnable {
    private static final int ROOM_HEIGHT = 30;
    private static final double SPACE_BUFFER = 7.5;
    private static final double GRID_SIZE = 7.5;
    private static final int TILES_X = (int)(((double)ChatRepository.ROOM_DIMENSION.width + 15.0) / 7.5);
    private static final int TILES_Y = (int)(((double)ChatRepository.ROOM_DIMENSION.height + 15.0) / 7.5);
    private Image bufferImage;
    private Image worldImage;
    private ChatApplet chatApplet;
    private Object3D world;
    private Light light;
    private Plane3D[] frustum;
    private Texture3D floorTexture;
    private Texture3D[] wallTexture = new Texture3D[4];
    private Texture3D[] frameTexture = new Texture3D[2];
    private Texture3D[][] tileTexture = new Texture3D[TILES_X][TILES_Y];
    private Polygon3D floor;
    private int lastUserId = -1;
    private int lastRoomId = -1;
    private int lastXPos = -1;
    private int lastYPos = -1;
    private int lastHeading = -1;
    private int lastWidth = -1;
    private int lastHeight = -1;
    private Object3D clippedworld;

    public ViewCanvas(ChatApplet chatApplet) {
        boolean bl = true;
        this.chatApplet = chatApplet;
        this.world = new Object3D();
        this.light = new Light();
        this.frustum = new Plane3D[5];
        this.frustum[0] = new Plane3D();
        this.frustum[0].normVec = new Vertex3D(0.0, 0.0, 1.0);
        this.frustum[0].dist = 2.0;
        this.light = new Light(-2.0, 2.0, -2.0);
        this.floor = new Polygon3D();
        this.floor.addPoint(new Vertex3D(-7.5, 0.0, -7.5));
        this.floor.addPoint(new Vertex3D((double)ChatRepository.ROOM_DIMENSION.width + 7.5, 0.0, -7.5));
        this.floor.addPoint(new Vertex3D((double)ChatRepository.ROOM_DIMENSION.width + 7.5, 0.0, (double)ChatRepository.ROOM_DIMENSION.height + 7.5));
        this.floor.addPoint(new Vertex3D(-7.5, 0.0, (double)ChatRepository.ROOM_DIMENSION.height + 7.5));
        this.floor.normVec = new Vertex3D(0.0, 1.0, 0.0);
        this.floor.col = Color.white;
        this.world.add(this.floor);
        double d = -7.5;
        double d2 = -7.5;
        int n = 0;
        while (n < TILES_X) {
            d2 = -7.5;
            int n2 = 0;
            while (n2 < TILES_Y) {
                if (bl) {
                    this.tileTexture[n][n2] = new Texture3D();
                    this.tileTexture[n][n2].addPoint(new Vertex3D(d, Double.MIN_VALUE, d2));
                    this.tileTexture[n][n2].addPoint(new Vertex3D(d + 7.5, Double.MIN_VALUE, d2));
                    this.tileTexture[n][n2].addPoint(new Vertex3D(d + 7.5, Double.MIN_VALUE, d2 + 7.5));
                    this.tileTexture[n][n2].addPoint(new Vertex3D(d, Double.MIN_VALUE, d2 + 7.5));
                    this.tileTexture[n][n2].normVec = new Vertex3D(0.0, 1.0, 0.0);
                    this.world.add(this.tileTexture[n][n2]);
                }
                bl = !bl;
                d2 += 7.5;
                ++n2;
            }
            d += 7.5;
            if (TILES_X % 2 == 0) {
                bl = !bl;
            }
            ++n;
        }
        this.world.add(new Cube3D(new Vertex3D(-7.5, 0.0, -7.5), new Vertex3D(0.0, 30.0, 0.0), Color.red));
        this.world.add(new Cube3D(new Vertex3D((double)ChatRepository.ROOM_DIMENSION.width + 7.5, 0.0, (double)ChatRepository.ROOM_DIMENSION.height + 7.5), new Vertex3D(ChatRepository.ROOM_DIMENSION.width, 30.0, ChatRepository.ROOM_DIMENSION.height), Color.blue));
        this.world.add(new Cube3D(new Vertex3D((double)ChatRepository.ROOM_DIMENSION.width + 7.5, 0.0, -7.5), new Vertex3D(ChatRepository.ROOM_DIMENSION.width, 30.0, 0.0), Color.yellow));
        this.world.add(new Cube3D(new Vertex3D(-7.5, 0.0, (double)ChatRepository.ROOM_DIMENSION.height + 7.5), new Vertex3D(0.0, 30.0, ChatRepository.ROOM_DIMENSION.height), Color.green));
        this.wallTexture[0] = new Texture3D();
        this.wallTexture[0].addPoint(new Vertex3D(-7.5, 30.0, -7.5));
        this.wallTexture[0].addPoint(new Vertex3D((double)ChatRepository.ROOM_DIMENSION.width + 7.5, 30.0, -7.5));
        this.wallTexture[0].addPoint(new Vertex3D((double)ChatRepository.ROOM_DIMENSION.width + 7.5, 0.0, -7.5));
        this.wallTexture[0].addPoint(new Vertex3D(-7.5, 0.0, -7.5));
        this.wallTexture[0].normVec = new Vertex3D(0.0, 0.0, 1.0);
        this.world.add(this.wallTexture[0]);
        this.wallTexture[1] = new Texture3D();
        this.wallTexture[1].addPoint(new Vertex3D(-7.5, 30.0, (double)ChatRepository.ROOM_DIMENSION.height + 7.5));
        this.wallTexture[1].addPoint(new Vertex3D(-7.5, 30.0, -7.5));
        this.wallTexture[1].addPoint(new Vertex3D(-7.5, 0.0, -7.5));
        this.wallTexture[1].addPoint(new Vertex3D(-7.5, 0.0, (double)ChatRepository.ROOM_DIMENSION.height + 7.5));
        this.wallTexture[1].normVec = new Vertex3D(1.0, 0.0, 0.0);
        this.world.add(this.wallTexture[1]);
        this.wallTexture[2] = new Texture3D();
        this.wallTexture[2].addPoint(new Vertex3D(-7.5, 30.0, (double)ChatRepository.ROOM_DIMENSION.height + 7.5));
        this.wallTexture[2].addPoint(new Vertex3D(ChatRepository.ROOM_DIMENSION.width, 30.0, (double)ChatRepository.ROOM_DIMENSION.height + 7.5));
        this.wallTexture[2].addPoint(new Vertex3D(ChatRepository.ROOM_DIMENSION.width, 0.0, (double)ChatRepository.ROOM_DIMENSION.height + 7.5));
        this.wallTexture[2].addPoint(new Vertex3D(-7.5, 0.0, (double)ChatRepository.ROOM_DIMENSION.height + 7.5));
        this.wallTexture[2].normVec = new Vertex3D(0.0, 0.0, -1.0);
        this.world.add(this.wallTexture[2]);
        this.wallTexture[3] = new Texture3D();
        this.wallTexture[3].addPoint(new Vertex3D((double)ChatRepository.ROOM_DIMENSION.width + 7.5, 30.0, -7.5));
        this.wallTexture[3].addPoint(new Vertex3D((double)ChatRepository.ROOM_DIMENSION.width + 7.5, 30.0, (double)ChatRepository.ROOM_DIMENSION.height + 7.5));
        this.wallTexture[3].addPoint(new Vertex3D((double)ChatRepository.ROOM_DIMENSION.width + 7.5, 0.0, (double)ChatRepository.ROOM_DIMENSION.height + 7.5));
        this.wallTexture[3].addPoint(new Vertex3D((double)ChatRepository.ROOM_DIMENSION.width + 7.5, 0.0, -7.5));
        this.wallTexture[3].normVec = new Vertex3D(-1.0, 0.0, 0.0);
        this.world.add(this.wallTexture[3]);
    }

    public Dimension getPreferredSize() {
        if (this.getParent() == null) {
            return super.getPreferredSize();
        }
        return new Dimension(this.getParent().getSize().width - this.getParent().getInsets().left - this.getParent().getInsets().right, this.getParent().getSize().height - this.getParent().getInsets().top - this.getParent().getInsets().bottom);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public synchronized void paint(Graphics graphics) {
        User user;
        int n;
        Object object;
        if (this.lastRoomId != this.chatApplet.getCurrentRoomId()) {
            Texture3D.TextureBuffer textureBuffer;
            Texture3D.TextureBuffer textureBuffer2;
            Texture3D.TextureBuffer textureBuffer3;
            Texture3D.TextureBuffer textureBuffer4;
            Texture3D.TextureBuffer textureBuffer5;
            boolean bl = this.chatApplet.getCurrentRoom().getName().equals(this.chatApplet.getParameter("Room"));
            if (this.chatApplet.getCurrentRoomId() == 0) {
                textureBuffer5 = new Texture3D.TextureBuffer(this.chatApplet.getImage("wall1.jpg", true));
                textureBuffer4 = new Texture3D.TextureBuffer(this.chatApplet.getImage("wall1.jpg", true));
                textureBuffer3 = new Texture3D.TextureBuffer(this.chatApplet.getImage("frame1.jpg", true));
                textureBuffer2 = new Texture3D.TextureBuffer(this.chatApplet.getImage("frame2.jpg", true));
                textureBuffer = new Texture3D.TextureBuffer(this.chatApplet.getImage("tile1.jpg", true));
                object = new Texture3D.TextureBuffer(this.chatApplet.getImage("tile1.jpg", true));
            } else {
                textureBuffer5 = new Texture3D.TextureBuffer(this.chatApplet.getImage(bl && this.chatApplet.getParameter("Wall[1]") != null ? this.chatApplet.getParameter("Wall[1]") : "wall1.jpg", true));
                textureBuffer4 = new Texture3D.TextureBuffer(this.chatApplet.getImage(bl && this.chatApplet.getParameter("Wall[1]") != null ? this.chatApplet.getParameter("Wall[1]") : "wall1.jpg", true));
                textureBuffer3 = new Texture3D.TextureBuffer(this.chatApplet.getImage(bl && this.chatApplet.getParameter("Frame[1]") != null ? this.chatApplet.getParameter("Frame[1]") : "frame3.jpg", true));
                textureBuffer2 = new Texture3D.TextureBuffer(this.chatApplet.getImage(bl && this.chatApplet.getParameter("Frame[2]") != null ? this.chatApplet.getParameter("Frame[2]") : "frame3.jpg", true));
                textureBuffer = new Texture3D.TextureBuffer(this.chatApplet.getImage(bl && this.chatApplet.getParameter("Tile[1]") != null ? this.chatApplet.getParameter("Tile[1]") : "tile4.jpg", true));
                object = new Texture3D.TextureBuffer(this.chatApplet.getImage(bl && this.chatApplet.getParameter("Tile[1]") != null ? this.chatApplet.getParameter("Tile[1]") : "tile4.jpg", true));
            }
            int n2 = textureBuffer.buffer[0];
            this.floor.col = new Color(n2 >> 16 & 0xFF, n2 >> 8 & 0xFF, n2 & 0xFF);
            n = textureBuffer3.width * 30 / 2 / textureBuffer3.height;
            if (this.frameTexture[0] != null) {
                this.world.remove(this.frameTexture[0]);
            }
            this.frameTexture[0] = new Texture3D(textureBuffer3);
            this.frameTexture[0].addPoint(new Vertex3D(ChatRepository.ROOM_DIMENSION.width / 2 - n / 2, 21.0, -6.5));
            this.frameTexture[0].addPoint(new Vertex3D(ChatRepository.ROOM_DIMENSION.width / 2 + n / 2, 21.0, -6.5));
            this.frameTexture[0].addPoint(new Vertex3D(ChatRepository.ROOM_DIMENSION.width / 2 + n / 2, 6.0, -6.5));
            this.frameTexture[0].addPoint(new Vertex3D(ChatRepository.ROOM_DIMENSION.width / 2 - n / 2, 6.0, -6.5));
            this.frameTexture[0].normVec = new Vertex3D(0.0, 0.0, 1.0);
            this.world.add(this.frameTexture[0]);
            n = textureBuffer2.width * 30 / 2 / textureBuffer2.height;
            if (this.frameTexture[1] != null) {
                this.world.remove(this.frameTexture[1]);
            }
            this.frameTexture[1] = new Texture3D(textureBuffer2);
            this.frameTexture[1].addPoint(new Vertex3D(ChatRepository.ROOM_DIMENSION.width / 2 + n / 2, 21.0, (double)ChatRepository.ROOM_DIMENSION.height + 7.5 - 1.0));
            this.frameTexture[1].addPoint(new Vertex3D(ChatRepository.ROOM_DIMENSION.width / 2 - n / 2, 21.0, (double)ChatRepository.ROOM_DIMENSION.height + 7.5 - 1.0));
            this.frameTexture[1].addPoint(new Vertex3D(ChatRepository.ROOM_DIMENSION.width / 2 - n / 2, 6.0, (double)ChatRepository.ROOM_DIMENSION.height + 7.5 - 1.0));
            this.frameTexture[1].addPoint(new Vertex3D(ChatRepository.ROOM_DIMENSION.width / 2 + n / 2, 6.0, (double)ChatRepository.ROOM_DIMENSION.height + 7.5 - 1.0));
            this.frameTexture[1].normVec = new Vertex3D(0.0, 0.0, -1.0);
            this.world.add(this.frameTexture[1]);
            this.wallTexture[0].setTextureBuffer(textureBuffer5);
            this.wallTexture[1].setTextureBuffer(textureBuffer4);
            this.wallTexture[2].setTextureBuffer(textureBuffer5);
            this.wallTexture[3].setTextureBuffer(textureBuffer4);
            this.frameTexture[0].setTextureBuffer(textureBuffer3);
            this.frameTexture[1].setTextureBuffer(textureBuffer2);
            boolean bl2 = false;
            int n3 = 0;
            while (n3 < TILES_X) {
                int n4 = 0;
                while (n4 < TILES_Y) {
                    boolean bl3 = bl2 = !bl2;
                    if (this.tileTexture[n3][n4] != null) {
                        this.tileTexture[n3][n4].setTextureBuffer((Texture3D.TextureBuffer)(bl2 ? textureBuffer : object));
                    }
                    ++n4;
                }
                if (TILES_X == 1) {
                    bl2 = !bl2;
                }
                ++n3;
            }
        }
        User user2 = this.chatApplet.getCurrentUser();
        Point point = user2.getPosition();
        int n5 = this.getSize().width;
        int n6 = this.getSize().height;
        if (this.bufferImage == null || this.bufferImage.getWidth(this) != n5 || this.bufferImage.getHeight(this) != n6) {
            this.bufferImage = this.createImage(n5, n6);
        }
        if (this.worldImage == null || this.worldImage.getWidth(this) != n5 || this.worldImage.getHeight(this) != n6) {
            this.worldImage = this.createImage(n5, n6);
        }
        Graphics graphics2 = this.bufferImage.getGraphics();
        Graphics graphics3 = this.worldImage.getGraphics();
        Vector vector = this.chatApplet.historyMode() ? this.chatApplet.getHistoryEntryVector(this.chatApplet.getHistoryDate()) : this.chatApplet.getCurrentSituationVector();
        n = 0;
        while (n < vector.size()) {
            user = this.chatApplet.getUser(((HistoryEntry)vector.elementAt((int)n)).userId);
            if (user == null || !this.chatApplet.inVisualRange(user2.getId(), ((HistoryEntry)vector.elementAt((int)n)).position)) {
                vector.removeElementAt(n);
                --n;
            }
            ++n;
        }
        Vector vector2 = new Vector(vector.size());
        int n7 = 0;
        while (n7 < vector.size()) {
            int n8;
            int n9 = 0;
            int n10 = n8 = vector2.size() / 2;
            boolean bl = false;
            while (!bl) {
                n9 = this.chatApplet.getDistance(user2.getId(), ((HistoryEntry)vector.elementAt((int)n7)).position);
                if (n10 - (n8 = Math.max(1, n8 / 2)) >= 0 && n9 > this.chatApplet.getDistance(user2.getId(), ((HistoryEntry)vector2.elementAt((int)(n10 - 1))).position)) {
                    n10 -= n8;
                    continue;
                }
                if (n10 + n8 <= vector2.size() && n9 < this.chatApplet.getDistance(user2.getId(), ((HistoryEntry)vector2.elementAt((int)n10)).position)) {
                    n10 += n8;
                    continue;
                }
                bl = true;
            }
            vector2.insertElementAt(vector.elementAt(n7), n10);
            ++n7;
        }
        vector = vector2;
        ViewPoint viewPoint = new ViewPoint(new Vertex3D(point.x, 7.0, point.y), new Orientation(0.0, user2.getHeading() + 90, 0.0));
        if (this.lastWidth != n5 || this.lastHeight != n6 || this.lastUserId != user2.getId() || this.lastXPos != point.x || this.lastYPos != point.y || this.lastHeading != user2.getHeading() || this.lastRoomId != this.chatApplet.getCurrentRoomId()) {
            Object3D object3D = this.getTransformedWorld(viewPoint);
            this.clippedworld = object3D.clip(this.frustum[0]);
            this.clippedworld.bringToScreen(this.getSize().width, this.getSize().height, this.light, true);
            this.clippedworld.orderByDepth();
            graphics3.setColor(Color.white);
            graphics3.fillRect(0, 0, n5, n6);
            this.clippedworld.paint(graphics3);
        }
        graphics2.drawImage(this.worldImage, 0, 0, this);
        int n11 = 0;
        while (n11 < vector.size()) {
            HistoryEntry historyEntry = (HistoryEntry)vector.elementAt(n11);
            user = this.chatApplet.getUser(historyEntry.userId);
            if (user != null && historyEntry.userId != this.chatApplet.getCurrentUserId()) {
                Image image = this.chatApplet.getUserAvatar(user.getId(), ((HistoryEntry)vector.elementAt((int)n11)).mood);
                new Object3D();
                Polygon3D polygon3D = new Polygon3D();
                int n12 = image.getWidth(this) * 8 / image.getWidth(this);
                polygon3D.addPoint(new Vertex3D(historyEntry.position.x - n12 / 2, 0.0, historyEntry.position.y));
                polygon3D.addPoint(new Vertex3D(historyEntry.position.x - n12 / 2, 8.0, historyEntry.position.y));
                polygon3D.addPoint(new Vertex3D(historyEntry.position.x + n12 / 2, 8.0, historyEntry.position.y));
                polygon3D.addPoint(new Vertex3D(historyEntry.position.x + n12 / 2, 0.0, historyEntry.position.y));
                object = new Object3D(this.getTransformedPoly(polygon3D, viewPoint)).clip(this.frustum[0]);
                object = ((Object3D)object).clip(this.frustum[0]);
                ((Object3D)object).bringToScreen(this.getSize().width, this.getSize().height, this.light, true);
                if (((Object3D)object).getNrOfPolygons() == 1) {
                    Polygon3D polygon3D2 = ((Object3D)object).getPolygon(0);
                    if (!this.chatApplet.inVisualRange(historyEntry.position, historyEntry.heading, user2.getPosition()) && this.chatApplet.getUserBackAvatar(user.getId()) != null) {
                        image = this.chatApplet.getUserBackAvatar(user.getId());
                    }
                    new Image3D(polygon3D2, image, user.getName(), historyEntry.text, user.getColor()).paint(graphics2);
                }
            }
            if (this.chatApplet.historyMode() && historyEntry.userId == this.chatApplet.getCurrentUserId()) {
                new Balloon(new Rectangle(n5 * 2 / 3, 10, n5 / 3 - 10, n6 - 20), historyEntry.text, user2.getColor(), 1).paint(graphics2);
            }
            ++n11;
        }
        graphics2.setColor(Color.black);
        graphics2.setFont(ChatRepository.BOLD_FONT);
        graphics2.drawString(this.chatApplet.getCurrentRoom().getName(), 10, this.getFontMetrics(this.getFont()).getMaxAscent() + 10);
        graphics2.setFont(ChatRepository.STANDARD_FONT);
        graphics.drawImage(this.bufferImage, 0, 0, this);
        this.lastUserId = user2.getId();
        this.lastXPos = point.x;
        this.lastYPos = point.y;
        this.lastHeading = user2.getHeading();
        this.lastRoomId = this.chatApplet.getCurrentRoomId();
        this.lastWidth = n5;
        this.lastHeight = n6;
    }

    private Polygon3D getTransformedPoly(Polygon3D polygon3D, ViewPoint viewPoint) {
        Polygon3D polygon3D2 = new Polygon3D(polygon3D);
        polygon3D2.translate(new Vertex3D(-viewPoint.from.x, -viewPoint.from.y, -viewPoint.from.z));
        polygon3D2.rotate(viewPoint.orient);
        return polygon3D2;
    }

    private Object3D getTransformedWorld(ViewPoint viewPoint) {
        Object3D object3D = new Object3D(this.world);
        object3D.translate(new Vertex3D(-viewPoint.from.x, -viewPoint.from.y, -viewPoint.from.z));
        object3D.rotate(viewPoint.orient);
        return object3D;
    }

    public void run() {
    }
}

