/*
 * Decompiled with CFR 0.152.
 */
package chat;

import chat.Orientation;

public class Vertex3D {
    public double x;
    public double y;
    public double z;

    public Vertex3D() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
    }

    public Vertex3D(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Vertex3D(Vertex3D vertex3D) {
        this.x = vertex3D.x;
        this.y = vertex3D.y;
        this.z = vertex3D.z;
    }

    public void rotate(Orientation orientation) {
        double d = this.x * orientation.yaw.cosinus - this.z * orientation.yaw.sinus;
        double d2 = this.y;
        double d3 = this.x * orientation.yaw.sinus + this.z * orientation.yaw.cosinus;
        double d4 = d;
        double d5 = orientation.pitch.cosinus * d2 + -orientation.pitch.sinus * d3;
        double d6 = orientation.pitch.sinus * d2 + orientation.pitch.cosinus * d3;
        this.x = d4 * orientation.roll.cosinus + d5 * orientation.roll.sinus;
        this.y = -d4 * orientation.roll.sinus + d5 * orientation.roll.cosinus;
        this.z = d6;
    }

    public void translate(Vertex3D vertex3D) {
        this.x += vertex3D.x;
        this.y += vertex3D.y;
        this.z += vertex3D.z;
    }

    public double dotProduct(Vertex3D vertex3D) {
        return this.x * vertex3D.x + this.y * vertex3D.y + this.z * vertex3D.z;
    }
}

