/*
 * Decompiled with CFR 0.152.
 */
package chat;

import chat.ChatApplet;
import chat.ChatRepository;
import chat.ChatUtil;
import chat.FocusPanel;
import chat.FramedPanel;
import chat.InsetsPanel;
import chat.PortraitCanvas;
import chat.User;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.text.DateFormat;
import java.util.Vector;

public class UserPanel
extends Panel {
    static final double PORTRAIT_SCALE = 0.6;
    protected ChatApplet chatApplet;
    protected InsetsPanel userDataPanel;
    protected Panel avatarPanelLevel2;
    protected Panel colorPasswordPanel;
    protected FramedPanel namePanel;
    protected FramedPanel infoPanel;
    protected FramedPanel colorPanel;
    protected FramedPanel passwordPanel;
    protected FramedPanel avatarPanelLevel1;
    protected TextField nameField;
    protected TextField roomField;
    protected TextField loginDateField;
    protected TextField emailField;
    protected TextField homepageField;
    protected TextField oldPasswordField;
    protected TextField newPasswordField1;
    protected TextField newPasswordField2;
    protected TextArea infoArea;
    protected Vector singleAvatarPanel;
    protected Vector avatarURLField;
    protected Vector avatarKeywordsField;
    protected Vector avatarCanvas;
    protected Vector iconCanvas;
    protected Vector webAvatarCheck;
    protected Vector serverAvatarCheck;
    protected Vector avatarGroup;
    protected Vector serverAvatarChoice;
    protected Vector moodNameField;
    protected Vector moodTimeoutField;
    protected PortraitCanvas currentPortraitCanvas;
    protected Scrollbar redBar;
    protected Scrollbar greenBar;
    protected Scrollbar blueBar;
    protected ScrollPane avatarScrollPane;

    public UserPanel(ChatApplet chatApplet) {
        this.chatApplet = chatApplet;
        this.namePanel = new FramedPanel("User", ChatRepository.INSETS);
        this.namePanel.setLayout(new GridBagLayout());
        this.currentPortraitCanvas = new PortraitCanvas();
        this.currentPortraitCanvas.setSize((int)((double)ChatRepository.PORTRAIT_DIMENSION.width * 0.6), (int)((double)ChatRepository.PORTRAIT_DIMENSION.height * 0.6));
        ChatUtil.addWithRemainingConstraints(this.namePanel, this.currentPortraitCanvas, ChatRepository.SMALL_INSETS);
        ChatUtil.addWithBeginningConstraints(this.namePanel, new Label("Name: ", 2), ChatRepository.SMALL_INSETS);
        this.nameField = new TextField();
        ChatUtil.addWithRemainingConstraints(this.namePanel, this.nameField, ChatRepository.SMALL_INSETS);
        ChatUtil.addWithBeginningConstraints(this.namePanel, new Label("Room: ", 2), ChatRepository.SMALL_INSETS);
        this.roomField = new TextField();
        ChatUtil.addWithRemainingConstraints(this.namePanel, this.roomField, ChatRepository.SMALL_INSETS);
        ChatUtil.addWithBeginningConstraints(this.namePanel, new Label("Online since: ", 2), ChatRepository.SMALL_INSETS);
        this.loginDateField = new TextField();
        ChatUtil.addWithRemainingConstraints(this.namePanel, this.loginDateField, ChatRepository.SMALL_INSETS);
        this.nameField.setEditable(false);
        this.roomField.setEditable(false);
        this.loginDateField.setEditable(false);
        this.currentPortraitCanvas.setDrawFrame(true);
        this.infoPanel = new FramedPanel("Info", ChatRepository.INSETS);
        this.infoPanel.setLayout(new GridBagLayout());
        ChatUtil.addWithRemainingConstraints(this.infoPanel, new Label("E-Mail:", 0), ChatRepository.SMALL_INSETS);
        this.emailField = new TextField();
        ChatUtil.addWithRemainingConstraints(this.infoPanel, this.emailField, ChatRepository.SMALL_INSETS);
        ChatUtil.addWithRemainingConstraints(this.infoPanel, new Label("Homepage:", 0), ChatRepository.SMALL_INSETS);
        this.homepageField = new TextField();
        ChatUtil.addWithRemainingConstraints(this.infoPanel, this.homepageField, ChatRepository.SMALL_INSETS);
        ChatUtil.addWithRemainingConstraints(this.infoPanel, new Label("Info:", 0), ChatRepository.SMALL_INSETS);
        this.infoArea = new TextArea("", 3, 25, 3);
        ChatUtil.addWithRemainingConstraints(this.infoPanel, this.infoArea, ChatRepository.SMALL_INSETS);
        this.colorPanel = new FramedPanel("Color", ChatRepository.INSETS);
        this.colorPanel.setLayout(new GridBagLayout());
        ChatUtil.addWithBeginningConstraints(this.colorPanel, new Label("Red: ", 2), ChatRepository.SMALL_INSETS);
        this.redBar = new Scrollbar(0, 0, 1, 0, 160);
        ChatUtil.addWithRemainingConstraints(this.colorPanel, this.redBar, ChatRepository.SMALL_INSETS);
        ChatUtil.addWithBeginningConstraints(this.colorPanel, new Label("Green: ", 2), ChatRepository.SMALL_INSETS);
        this.greenBar = new Scrollbar(0, 0, 1, 0, 160);
        ChatUtil.addWithRemainingConstraints(this.colorPanel, this.greenBar, ChatRepository.SMALL_INSETS);
        ChatUtil.addWithBeginningConstraints(this.colorPanel, new Label("Blue: ", 2), ChatRepository.SMALL_INSETS);
        this.blueBar = new Scrollbar(0, 0, 1, 0, 160);
        ChatUtil.addWithRemainingConstraints(this.colorPanel, this.blueBar, ChatRepository.SMALL_INSETS);
        this.passwordPanel = new FramedPanel("Password", ChatRepository.INSETS);
        this.passwordPanel.setLayout(new GridBagLayout());
        ChatUtil.addWithBeginningConstraints(this.passwordPanel, new Label("Old:", 2), ChatRepository.SMALL_INSETS);
        this.oldPasswordField = new TextField();
        ChatUtil.addWithRemainingConstraints(this.passwordPanel, this.oldPasswordField, ChatRepository.SMALL_INSETS);
        this.oldPasswordField.setEchoChar('*');
        ChatUtil.addWithBeginningConstraints(this.passwordPanel, new Label("New:", 2), ChatRepository.SMALL_INSETS);
        this.newPasswordField1 = new TextField();
        ChatUtil.addWithRemainingConstraints(this.passwordPanel, this.newPasswordField1, ChatRepository.SMALL_INSETS);
        this.newPasswordField1.setEchoChar('*');
        ChatUtil.addWithBeginningConstraints(this.passwordPanel, new Label("New (Verify):", 2), ChatRepository.SMALL_INSETS);
        this.newPasswordField2 = new TextField();
        ChatUtil.addWithRemainingConstraints(this.passwordPanel, this.newPasswordField2, ChatRepository.SMALL_INSETS);
        this.newPasswordField2.setEchoChar('*');
        this.colorPasswordPanel = new Panel();
        this.colorPasswordPanel.setLayout(new GridLayout(2, 1));
        if (this.chatApplet.getBooleanParam("ExtendedAvatarConfigVisibility", true)) {
            this.colorPasswordPanel.add(this.colorPanel);
        }
        this.colorPasswordPanel.add(this.passwordPanel);
        this.userDataPanel = new InsetsPanel();
        this.userDataPanel.setLayout(new GridLayout(1, 3));
        this.userDataPanel.add(this.namePanel);
        this.userDataPanel.add(this.infoPanel);
        this.userDataPanel.add(this.colorPasswordPanel);
        this.avatarCanvas = new Vector();
        this.iconCanvas = new Vector();
        this.singleAvatarPanel = new Vector();
        this.avatarURLField = new Vector();
        this.avatarKeywordsField = new Vector();
        this.moodNameField = new Vector();
        this.moodTimeoutField = new Vector();
        this.webAvatarCheck = new Vector();
        this.serverAvatarCheck = new Vector();
        this.avatarGroup = new Vector();
        this.serverAvatarChoice = new Vector();
        this.avatarPanelLevel2 = new Panel();
        this.avatarScrollPane = new ScrollPane();
        this.avatarScrollPane.add(this.avatarPanelLevel2);
        int n = 0;
        while (n <= 6) {
            this.addAvatarPanel();
            ++n;
        }
        this.avatarPanelLevel1 = new FramedPanel("Avatars", ChatRepository.INSETS);
        this.avatarPanelLevel1.setLayout(new BorderLayout());
        this.avatarPanelLevel1.add((Component)this.avatarScrollPane, "Center");
        this.setLayout(new BorderLayout());
        ((Component)this).setFont(ChatRepository.STANDARD_FONT);
        this.add((Component)this.userDataPanel, "North");
        this.add((Component)this.avatarPanelLevel1, "Center");
    }

    public void showUser(User user) {
        this.currentPortraitCanvas.setImage(this.chatApplet.getUserAvatar(user.getId()));
        this.currentPortraitCanvas.setFrameColor(user.getColor());
        ((TextComponent)this.nameField).setText(user.getName());
        ((TextComponent)this.roomField).setText(this.chatApplet.getRoom(user.getRoom()).getName());
        ((TextComponent)this.loginDateField).setText(DateFormat.getTimeInstance().format(user.getLoginDate()));
        ((TextComponent)this.emailField).setText(user.getEmail());
        ((TextComponent)this.homepageField).setText(user.getHomepage());
        this.infoArea.setText(user.getInfo());
        this.redBar.setValue(user.getColor().getRed());
        this.greenBar.setValue(user.getColor().getGreen());
        this.blueBar.setValue(user.getColor().getBlue());
        int n = 6;
        while (n > user.getNrOfMoods()) {
            this.removeLastAvatarPanel();
            ++n;
        }
        int n2 = 0;
        while (n2 <= user.getNrOfMoods()) {
            if (n2 >= this.getNrOfAvatarPanels()) {
                this.addAvatarPanel();
            }
            if (n2 == 0) {
                ((PortraitCanvas)this.avatarCanvas.firstElement()).setImage(this.chatApplet.getUserBackAvatar(user.getId()));
                ((TextComponent)((TextField)this.avatarURLField.firstElement())).setText(user.getBackAvatarURL());
            } else {
                ((PortraitCanvas)this.avatarCanvas.elementAt(n2)).setImage(this.chatApplet.getUserAvatar(user.getId(), n2 - 1));
                ((TextComponent)((TextField)this.avatarURLField.elementAt(n2))).setText(user.getAvatarURL(n2 - 1));
                ((TextComponent)((TextField)this.avatarKeywordsField.elementAt(n2))).setText(user.getMoodKeywords(n2 - 1));
                ((TextComponent)((TextField)this.moodNameField.elementAt(n2))).setText(user.getMoodName(n2 - 1));
                ((TextComponent)((TextField)this.moodTimeoutField.elementAt(n2))).setText(new Integer(user.getMoodTimeout(n2 - 1)).toString());
            }
            this.toggleAvatarPanel(n2);
            ++n2;
        }
        this.currentPortraitCanvas.setFrameColor(user.getColor());
    }

    public void removeLastAvatarPanel() {
        this.removeAvatarPanel(this.getNrOfAvatarPanels() - 1);
    }

    public void removeAvatarPanel(int n) {
        if (n > 6 && n < this.getNrOfAvatarPanels()) {
            this.avatarPanelLevel2.remove((InsetsPanel)this.singleAvatarPanel.elementAt(n));
            this.avatarCanvas.removeElementAt(n);
            this.singleAvatarPanel.removeElementAt(n);
            this.iconCanvas.removeElementAt(n);
            this.avatarGroup.removeElementAt(n);
            this.webAvatarCheck.removeElementAt(n);
            this.avatarURLField.removeElementAt(n);
            this.serverAvatarChoice.removeElementAt(n);
            this.avatarKeywordsField.removeElementAt(n);
            this.moodNameField.removeElementAt(n);
            this.moodTimeoutField.removeElementAt(n);
            this.avatarPanelLevel2.setLayout(new GridLayout(1, this.singleAvatarPanel.size()));
            if (System.getProperty("java.vendor").indexOf("Netscape") != -1) {
                this.avatarPanelLevel2.validate();
                this.avatarScrollPane.validate();
            }
            if (this.avatarCanvas.size() > 6) {
                this.avatarPanelLevel2.setSize(this.avatarPanelLevel2.getSize().width * (this.singleAvatarPanel.size() - 1) / this.singleAvatarPanel.size(), this.avatarPanelLevel2.getSize().height);
            }
        }
    }

    public int getNrOfAvatarPanels() {
        return this.avatarCanvas.size();
    }

    public void removeAllAvatarPanels() {
        while (this.getNrOfAvatarPanels() > 0) {
            this.removeLastAvatarPanel();
        }
    }

    public void addAvatarPanel() {
        this.avatarCanvas.addElement(new PortraitCanvas());
        ((Canvas)this.avatarCanvas.lastElement()).setSize((int)((double)ChatRepository.PORTRAIT_DIMENSION.width * 0.6 / 2.0), (int)((double)ChatRepository.PORTRAIT_DIMENSION.height * 0.6 / 2.0));
        this.singleAvatarPanel.addElement(new FocusPanel(ChatRepository.INSETS));
        ((InsetsPanel)this.singleAvatarPanel.lastElement()).setLayout(new GridBagLayout());
        this.iconCanvas.addElement(new PortraitCanvas());
        ((PortraitCanvas)this.iconCanvas.lastElement()).setSize(ChatRepository.ICON_DIMENSION);
        ((PortraitCanvas)this.iconCanvas.lastElement()).setImage(this.iconCanvas.size() == 1 ? this.chatApplet.getEmptyIcon() : (this.iconCanvas.size() <= 7 ? this.chatApplet.getMoodIcon(this.iconCanvas.size() - 2) : this.chatApplet.getUnknownIcon()));
        this.avatarGroup.addElement(new CheckboxGroup());
        this.webAvatarCheck.addElement(new Checkbox("URL:", (CheckboxGroup)this.avatarGroup.lastElement(), true));
        this.avatarURLField.addElement(new TextField(15));
        this.serverAvatarCheck.addElement(new Checkbox("Predefined:", (CheckboxGroup)this.avatarGroup.lastElement(), true));
        this.serverAvatarChoice.addElement(new Choice());
        this.avatarKeywordsField.addElement(new TextField(15));
        this.moodNameField.addElement(new TextField(10));
        this.moodTimeoutField.addElement(new TextField(3));
        ChatUtil.addWithRemainingConstraints((InsetsPanel)this.singleAvatarPanel.lastElement(), (PortraitCanvas)this.iconCanvas.lastElement(), ChatRepository.SMALL_INSETS);
        ChatUtil.addWithRemainingConstraints((InsetsPanel)this.singleAvatarPanel.lastElement(), (Canvas)this.avatarCanvas.lastElement(), ChatRepository.SMALL_INSETS);
        Label label = new Label("Name:", 2);
        ChatUtil.addWithBeginningConstraints((InsetsPanel)this.singleAvatarPanel.lastElement(), label, ChatRepository.SMALL_INSETS);
        ChatUtil.addWithRemainingConstraints((InsetsPanel)this.singleAvatarPanel.lastElement(), (TextField)this.moodNameField.lastElement(), ChatRepository.SMALL_INSETS);
        ChatUtil.addWithBeginningConstraints((InsetsPanel)this.singleAvatarPanel.lastElement(), (Checkbox)this.webAvatarCheck.lastElement(), ChatRepository.SMALL_INSETS);
        ChatUtil.addWithRemainingConstraints((InsetsPanel)this.singleAvatarPanel.lastElement(), (TextField)this.avatarURLField.lastElement(), ChatRepository.SMALL_INSETS);
        ChatUtil.addWithBeginningConstraints((InsetsPanel)this.singleAvatarPanel.lastElement(), (Checkbox)this.serverAvatarCheck.lastElement(), ChatRepository.SMALL_INSETS);
        ChatUtil.addWithRemainingConstraints((InsetsPanel)this.singleAvatarPanel.lastElement(), (Choice)this.serverAvatarChoice.lastElement(), ChatRepository.SMALL_INSETS);
        Label label2 = new Label("Keywords:", 2);
        Label label3 = new Label("Timeout (Seconds):", 2);
        if (this.chatApplet.getBooleanParam("ExtendedAvatarConfigVisibility", true)) {
            ChatUtil.addWithBeginningConstraints((InsetsPanel)this.singleAvatarPanel.lastElement(), label2, ChatRepository.SMALL_INSETS);
            ChatUtil.addWithRemainingConstraints((InsetsPanel)this.singleAvatarPanel.lastElement(), (TextField)this.avatarKeywordsField.lastElement(), ChatRepository.SMALL_INSETS);
            ChatUtil.addWithBeginningConstraints((InsetsPanel)this.singleAvatarPanel.lastElement(), label3, ChatRepository.SMALL_INSETS);
            ChatUtil.addWithRemainingConstraints((InsetsPanel)this.singleAvatarPanel.lastElement(), (TextField)this.moodTimeoutField.lastElement(), ChatRepository.SMALL_INSETS);
        }
        int n = 0;
        while (n < ChatApplet.SERVER_POTRAIT_NAME.length && this.getNrOfAvatarPanels() <= 7) {
            ((Choice)this.serverAvatarChoice.lastElement()).add(ChatApplet.SERVER_POTRAIT_NAME[n]);
            ++n;
        }
        this.avatarPanelLevel2.setLayout(new GridLayout(1, this.singleAvatarPanel.size()));
        this.avatarPanelLevel2.add((InsetsPanel)this.singleAvatarPanel.lastElement());
        this.avatarPanelLevel2.validate();
        this.avatarScrollPane.validate();
        if (this.avatarCanvas.size() == 1) {
            label.setEnabled(false);
            label2.setEnabled(false);
            label3.setEnabled(false);
            ((TextField)this.moodNameField.lastElement()).setEditable(false);
            ((TextComponent)((TextField)this.moodNameField.lastElement())).setText("Backside");
            ((TextField)this.avatarKeywordsField.lastElement()).setEditable(false);
            ((TextField)this.moodTimeoutField.lastElement()).setEditable(false);
        } else if (this.avatarCanvas.size() > 6) {
            this.avatarPanelLevel2.setSize(this.avatarPanelLevel2.getSize().width * this.singleAvatarPanel.size() / (this.singleAvatarPanel.size() - 1), this.avatarPanelLevel2.getSize().height);
        }
        this.toggleLastAvatarPanel();
    }

    public void toggleLastAvatarPanel() {
        this.toggleAvatarPanel(this.getNrOfAvatarPanels() - 1);
    }

    public void toggleAvatarPanel(int n) {
        ((Checkbox)this.webAvatarCheck.elementAt(n)).setEnabled(this.chatApplet.isConnected());
        ((Checkbox)this.serverAvatarCheck.elementAt(n)).setEnabled(((Choice)this.serverAvatarChoice.elementAt(n)).getItemCount() > 0);
        ((Checkbox)this.webAvatarCheck.elementAt(n)).setState(((Checkbox)this.webAvatarCheck.elementAt(n)).isEnabled());
        ((Choice)this.serverAvatarChoice.elementAt(n)).setEnabled(!((Checkbox)this.webAvatarCheck.elementAt(n)).getState());
        ((TextField)this.avatarURLField.elementAt(n)).setEditable(((Checkbox)this.webAvatarCheck.elementAt(n)).getState());
    }
}

