/*
 * Decompiled with CFR 0.152.
 */
package chat;

import chat.ChatRepository;
import chat.SerializableImage;
import java.awt.Color;
import java.awt.Image;
import java.awt.Point;
import java.io.Serializable;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;

public class User
implements Serializable,
Cloneable {
    static final long serialVersionUID = -6200835697056167453L;
    public static final int HUMAN_RACE = 0;
    public static final int ROBOT_RACE = 1;
    private int id;
    private int mood;
    private String name;
    private String password;
    private int room;
    private int heading;
    private int race;
    private Vector avatarURL;
    private Vector moodKeywords;
    private Vector moodTimeout;
    private Vector moodName;
    private String message;
    private String email;
    private String homepage;
    private String info;
    private Color color;
    private Date loginDate;
    private Point position;
    private Vector avatar;
    private SerializableImage backAvatar;
    private String backAvatarURL;
    private boolean commercialBanner;

    public User(int n) {
        this(n, "", "", Color.black, new Point(), 0, 0, 0);
    }

    public User(String string, String string2) {
        this(0, string, string2, Color.black, new Point(), 0, 0, 0);
    }

    public User(int n, String string, String string2, Color color, Point point, int n2, int n3) {
        this(n, string, string2, color, point, n2, n3, 0);
    }

    public User(int n, String string, String string2, Color color, Point point, int n2, int n3, int n4) {
        this.id = n;
        this.name = string;
        this.password = string2;
        this.color = color;
        this.position = point;
        this.heading = n2;
        this.race = n4;
        this.avatar = new Vector();
        this.avatarURL = new Vector();
        this.moodKeywords = new Vector();
        this.moodTimeout = new Vector();
        this.moodName = new Vector();
        this.mood = n3;
        this.room = 0;
        this.loginDate = new Date();
        this.setNrOfMoods(6);
        this.commercialBanner = false;
        this.message = "";
        int n5 = 0;
        while (n5 < this.getNrOfMoods()) {
            this.setMoodName(n5, ChatRepository.MOOD_NAME[n5]);
            ++n5;
        }
    }

    public synchronized int getId() {
        return this.id;
    }

    public synchronized void setId(int n) {
        this.id = n;
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized void setName(String string) {
        this.name = string;
    }

    public synchronized String getEmail() {
        return this.email;
    }

    public synchronized void setEmail(String string) {
        this.email = string;
    }

    public synchronized String getHomepage() {
        return this.homepage;
    }

    public synchronized void setHomepage(String string) {
        this.homepage = string;
    }

    public synchronized String getInfo() {
        return this.info;
    }

    public synchronized void setInfo(String string) {
        this.info = string;
    }

    public synchronized String getPassword() {
        return this.password;
    }

    public synchronized void setPassword(String string) {
        this.password = string;
    }

    public synchronized int getMood() {
        return this.mood;
    }

    public synchronized void setMood(int n) {
        this.mood = n;
    }

    public synchronized int getRoom() {
        return this.room;
    }

    public synchronized void setRoom(int n) {
        this.room = n;
        this.message = "";
    }

    public synchronized Date getLoginDate() {
        return this.loginDate;
    }

    public synchronized void setLoginDate(Date date) {
        this.loginDate = date;
    }

    public synchronized int getHeading() {
        return this.heading;
    }

    public synchronized void setHeading(int n) {
        this.heading = n;
    }

    public synchronized int getRace() {
        return this.race;
    }

    public synchronized boolean isHuman() {
        return this.race == 0;
    }

    public synchronized void setRace(int n) {
        this.race = n;
    }

    public synchronized Color getColor() {
        return this.color;
    }

    public synchronized void setColor(Color color) {
        this.color = color;
    }

    public synchronized Point getPosition() {
        return this.position;
    }

    public synchronized void setPosition(Point point) {
        this.position = point;
    }

    public synchronized String getAvatarURL(int n) {
        if (this.avatarURL.size() > n) {
            return (String)this.avatarURL.elementAt(n);
        }
        return "";
    }

    public synchronized void setAvatarURL(int n, String string) {
        if (this.avatarURL.size() > n) {
            this.avatarURL.setElementAt(string, n);
        }
    }

    public synchronized String getBackAvatarURL() {
        return this.backAvatarURL;
    }

    public synchronized void setBackAvatarURL(String string) {
        this.backAvatarURL = string;
    }

    public synchronized String getMoodKeywords(int n) {
        if (this.moodName.size() > n) {
            return (String)this.moodKeywords.elementAt(n);
        }
        return "";
    }

    public synchronized void setMoodKeywords(int n, String string) {
        if (this.moodName.size() > n) {
            this.moodKeywords.setElementAt(string, n);
        }
    }

    public synchronized int getMoodTimeout() {
        return this.getMoodTimeout(this.getMood());
    }

    public synchronized int getMoodTimeout(int n) {
        if (this.moodTimeout.size() > n && this.moodTimeout.elementAt(n) != null) {
            return (Integer)this.moodTimeout.elementAt(n);
        }
        return 0;
    }

    public synchronized String getMoodName(int n) {
        if (this.moodName.size() > n && this.moodName.elementAt(n) != null) {
            return (String)this.moodName.elementAt(n);
        }
        return "";
    }

    public synchronized void setMoodName(int n, String string) {
        this.moodName.setElementAt(string, n);
    }

    public void setMoodTimeout(int n, int n2) {
        this.moodTimeout.setElementAt(new Integer(n2), n);
    }

    public synchronized Image getBackAvatar() {
        if (this.backAvatar != null) {
            return this.backAvatar.getImage();
        }
        return null;
    }

    public synchronized Image getAvatar(int n) {
        if (n < this.avatar.size() && this.avatar.elementAt(n) != null) {
            return ((SerializableImage)this.avatar.elementAt(n)).getImage();
        }
        if (this.avatar.size() > 0 && this.avatar.elementAt(0) != null) {
            return ((SerializableImage)this.avatar.elementAt(0)).getImage();
        }
        return null;
    }

    public synchronized Image getAvatar() {
        return this.getAvatar(this.getMood());
    }

    public synchronized void setAvatar(int n, Image image) {
        this.avatar.setElementAt(image == null ? null : new SerializableImage(image), n);
    }

    public synchronized void setBackAvatar(Image image) {
        this.backAvatar = image == null ? null : new SerializableImage(image);
    }

    public synchronized void setMessage(String string) {
        this.message = string;
    }

    public synchronized String getMessage() {
        return this.message;
    }

    public synchronized int getMood(String string) {
        string = string.toLowerCase();
        int n = 0;
        while (n < this.getNrOfMoods()) {
            String string2 = (String)this.moodKeywords.elementAt(n);
            if (string2 != null) {
                string2 = string2.toLowerCase();
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ,.;!:-?\"()/");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (((String)this.moodKeywords.elementAt(n)).indexOf(string3) == -1) continue;
                    return n;
                }
            }
            ++n;
        }
        return this.getMood();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public synchronized int getNrOfMoods() {
        return this.avatar.size();
    }

    public synchronized void setNrOfMoods(int n) {
        this.avatar.setSize(n);
        this.avatarURL.setSize(n);
        this.moodKeywords.setSize(n);
        this.moodName.setSize(n);
        this.moodTimeout.setSize(n);
    }

    public synchronized void setCommercialBanner(boolean bl) {
        this.commercialBanner = bl;
    }

    public synchronized boolean isCommercialBanner() {
        return this.commercialBanner;
    }
}

