/*
 * Decompiled with CFR 0.152.
 */
package chat;

import chat.Plane3D;
import chat.Polygon3D;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;

public class Texture3D
extends Polygon3D {
    private TextureBuffer buffer;

    public Texture3D(Texture3D texture3D) {
        super(texture3D);
        this.buffer = new TextureBuffer(texture3D.buffer);
    }

    public Texture3D(Image image) {
        this.buffer = new TextureBuffer(image);
    }

    public Texture3D(TextureBuffer textureBuffer) {
        this.buffer = new TextureBuffer(textureBuffer);
    }

    public Texture3D() {
    }

    public Polygon3D doClone() {
        return new Texture3D(this);
    }

    public boolean clipBack(Plane3D plane3D) {
        return super.clipBack(plane3D);
    }

    public void setTextureBuffer(TextureBuffer textureBuffer) {
        this.buffer = textureBuffer;
    }

    public void paint(Graphics graphics) {
        if (this.getNrOfPoints() != 4) {
            return;
        }
        float f = this.buffer.width;
        float f2 = this.buffer.height;
        int[] nArray = this.buffer.buffer;
        Vec2D vec2D = new Vec2D((float)(this.scrX[2] - this.scrX[1]) / f, (float)(this.scrY[2] - this.scrY[1]) / f2);
        Vec2D vec2D2 = new Vec2D((float)(this.scrX[3] - this.scrX[0]) / f, (float)(this.scrY[3] - this.scrY[0]) / f2);
        Point2D point2D = new Point2D(this.scrX[0], this.scrY[0]);
        Point2D point2D2 = new Point2D(this.scrX[1], this.scrY[1]);
        Point2D point2D3 = new Point2D(point2D2.x + vec2D.x, point2D2.y + vec2D.y);
        Point2D point2D4 = new Point2D(point2D.x + vec2D2.x, point2D.y + vec2D2.y);
        int[] nArray2 = new int[4];
        int[] nArray3 = new int[4];
        int n = 0;
        int n2 = 0;
        while ((float)n2 < f2) {
            Vec2D vec2D3 = new Vec2D((point2D2.x - point2D.x) / f, (point2D2.y - point2D.y) / f);
            Vec2D vec2D4 = new Vec2D((point2D3.x - point2D4.x) / f, (point2D3.y - point2D4.y) / f);
            Point2D point2D5 = new Point2D(point2D);
            Point2D point2D6 = new Point2D(point2D4);
            int n3 = 0;
            while ((float)n3 < f) {
                nArray2[0] = (int)point2D5.x;
                nArray3[0] = (int)point2D5.y;
                nArray2[1] = (int)(point2D5.x + vec2D3.x);
                nArray3[1] = (int)(point2D5.y + vec2D3.y);
                nArray2[2] = (int)(point2D6.x + vec2D4.x);
                nArray3[2] = (int)(point2D6.y + vec2D4.y);
                nArray2[3] = (int)point2D6.x;
                nArray3[3] = (int)point2D6.y;
                int n4 = nArray[n3 + n];
                graphics.setColor(new Color(n4 >> 16 & 0xFF, n4 >> 8 & 0xFF, n4 & 0xFF));
                graphics.fillPolygon(nArray2, nArray3, 4);
                point2D5.translate(vec2D3.x, vec2D3.y);
                point2D6.translate(vec2D4.x, vec2D4.y);
                ++n3;
            }
            point2D.translate(vec2D2.x, vec2D2.y);
            point2D2.translate(vec2D.x, vec2D.y);
            point2D3.translate(vec2D.x, vec2D.y);
            point2D4.translate(vec2D2.x, vec2D2.y);
            n += this.buffer.width;
            ++n2;
        }
    }

    public static class TextureBuffer
    implements ImageObserver {
        public int[] buffer;
        public int width;
        public int height;

        public TextureBuffer(Image image) {
            while (image.getWidth(this) == -1 || image.getHeight(this) == -1) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.width = image.getWidth(this);
            this.height = image.getHeight(this);
            this.buffer = new int[this.width * this.height];
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.width, this.height, this.buffer, 0, this.width);
            try {
                pixelGrabber.grabPixels();
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        public TextureBuffer(TextureBuffer textureBuffer) {
            this.buffer = textureBuffer.buffer;
            this.width = textureBuffer.width;
            this.height = textureBuffer.height;
        }

        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            return (n & 0x20) == 0;
        }
    }

    public class Point2D {
        public float x;
        public float y;

        public Point2D(Point2D point2D) {
            Texture3D.this = Texture3D.this;
            this.x = point2D.x;
            this.y = point2D.y;
        }

        public Point2D(float f, float f2) {
            Texture3D.this = Texture3D.this;
            this.x = f;
            this.y = f2;
        }

        public void translate(float f, float f2) {
            this.x += f;
            this.y += f2;
        }
    }

    public class Vec2D {
        public float x;
        public float y;

        public Vec2D(float f, float f2) {
            Texture3D.this = Texture3D.this;
            this.x = f;
            this.y = f2;
        }
    }
}

