/*
 * Decompiled with CFR 0.152.
 */
package chat;

import chat.ChatApplet;
import chat.ChatRepository;
import chat.ChatUtil;
import chat.HistoryEntry;
import chat.Room;
import chat.User;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;

public class RoomCanvas
extends Canvas
implements MouseListener,
MouseMotionListener,
ActionListener {
    private ChatApplet chatApplet;
    private Color nameColor = Color.black;
    private PopupMenu ownRoomPopup;
    private PopupMenu roomPopup;
    private PopupMenu ownUserPopup;
    private PopupMenu userPopup;
    private Menu inviteUserMenu;
    private Menu kickUserMenu;
    private MenuItem roomInfoItem;
    private MenuItem roomSettingsItem;
    private MenuItem userInfoItem;
    private MenuItem userSettingsItem;
    private MenuItem whisperItem;
    private int selectedUserId;
    public final int ACTION_NONE = 0;
    public final int ACTION_MOVING = 1;
    public final int ACTION_ROTATING = 2;
    private int userAction = 0;
    private int focusedUserId = -1;

    public RoomCanvas(ChatApplet chatApplet) {
        this.chatApplet = chatApplet;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.roomPopup = new PopupMenu();
        this.ownRoomPopup = new PopupMenu();
        this.userPopup = new PopupMenu();
        this.ownUserPopup = new PopupMenu();
        this.roomInfoItem = new MenuItem("View room settings");
        this.roomSettingsItem = new MenuItem("Edit room settings");
        this.userInfoItem = new MenuItem("View user info");
        this.userSettingsItem = new MenuItem("Edit user info");
        this.inviteUserMenu = new Menu("Invite user to room");
        this.kickUserMenu = new Menu("Kick user from room");
        this.whisperItem = new MenuItem("Whisper to user");
        this.roomPopup.add(this.roomInfoItem);
        this.ownRoomPopup.add(this.roomSettingsItem);
        this.userPopup.add(this.whisperItem);
        this.userPopup.add(this.userInfoItem);
        this.userPopup.add(this.inviteUserMenu);
        this.userPopup.add(this.kickUserMenu);
        this.ownUserPopup.add(this.userSettingsItem);
        this.add(this.roomPopup);
        this.add(this.ownRoomPopup);
        this.add(this.userPopup);
        this.add(this.ownUserPopup);
        this.roomPopup.addActionListener(this);
        this.ownRoomPopup.addActionListener(this);
        this.userPopup.addActionListener(this);
        this.ownUserPopup.addActionListener(this);
        this.inviteUserMenu.addActionListener(this);
        this.kickUserMenu.addActionListener(this);
    }

    public void paint(Graphics graphics) {
        graphics.setFont(ChatRepository.SMALL_FONT);
        Vector vector = this.chatApplet.historyMode() ? this.chatApplet.getHistoryEntryVector(this.chatApplet.getHistoryDate()) : this.chatApplet.getCurrentSituationVector();
        int n = 0;
        while (n < vector.size()) {
            HistoryEntry historyEntry = (HistoryEntry)vector.elementAt(n);
            if (this.chatApplet.getUser(historyEntry.userId) != null) {
                if (historyEntry.userId == this.chatApplet.getCurrentUserId()) {
                    historyEntry.position = this.chatApplet.getCurrentUser().getPosition();
                    historyEntry.heading = this.chatApplet.getCurrentUser().getHeading();
                    historyEntry.color = this.chatApplet.getCurrentUser().getColor();
                }
                graphics.setColor(ChatUtil.brighten(ChatUtil.brighten(historyEntry.color)));
                graphics.fillOval(historyEntry.position.x - 6, historyEntry.position.y - 6, 12, 12);
                graphics.setColor(historyEntry.color);
                graphics.fillOval(historyEntry.position.x - 4, historyEntry.position.y - 4, 8, 8);
                graphics.setColor(ChatUtil.brighten(historyEntry.color));
                int n2 = 17;
                while (n2 <= 17) {
                    graphics.drawArc(historyEntry.position.x - n2, historyEntry.position.y - n2, n2 * 2, n2 * 2, historyEntry.heading - 60, 120);
                    n2 += 10;
                }
                if (historyEntry.userId == this.focusedUserId) {
                    graphics.setColor(Color.lightGray);
                    graphics.drawOval(historyEntry.position.x - 6 - 2, historyEntry.position.y - 6 - 2, 16, 16);
                    graphics.drawOval(historyEntry.position.x - 6 - 3, historyEntry.position.y - 6 - 3, 18, 18);
                } else if (historyEntry.userId == this.chatApplet.getCurrentUserId()) {
                    graphics.setColor(Color.black);
                    graphics.drawOval(historyEntry.position.x - 6 - 2, historyEntry.position.y - 6 - 2, 16, 16);
                    graphics.drawOval(historyEntry.position.x - 6 - 3, historyEntry.position.y - 6 - 3, 18, 18);
                }
                graphics.setColor(this.nameColor);
                graphics.drawString(this.chatApplet.getUser(historyEntry.userId).getName(), historyEntry.position.x + 6, historyEntry.position.y + 6);
            }
            ++n;
        }
    }

    private int getUserAtPosition(Point point) {
        Enumeration enumeration = this.chatApplet.getRoomUserIdVector(this.chatApplet.getCurrentRoomId()).elements();
        while (enumeration.hasMoreElements()) {
            User user = this.chatApplet.getUser((Integer)enumeration.nextElement());
            if (!new Rectangle(user.getPosition().x - 6, user.getPosition().y - 6, 12, 12).contains(point)) continue;
            return user.getId();
        }
        return -1;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Room room;
        if (actionEvent.getActionCommand().equals(this.roomInfoItem.getLabel())) {
            this.chatApplet.showRoom(this.chatApplet.getCurrentRoomId());
            return;
        }
        if (actionEvent.getActionCommand().equals(this.roomSettingsItem.getLabel())) {
            this.chatApplet.editRoom(this.chatApplet.getCurrentRoomId());
            return;
        }
        if (actionEvent.getActionCommand().equals(this.userInfoItem.getLabel())) {
            this.chatApplet.showUser(this.selectedUserId);
            return;
        }
        if (actionEvent.getActionCommand().equals(this.userSettingsItem.getLabel())) {
            this.chatApplet.editUser(this.selectedUserId);
            return;
        }
        if (actionEvent.getActionCommand().equals(this.whisperItem.getLabel())) {
            this.chatApplet.whisperToUser(this.selectedUserId);
            return;
        }
        if ((actionEvent.getSource() == this.inviteUserMenu || actionEvent.getSource() == this.kickUserMenu) && (room = this.chatApplet.getRoom(actionEvent.getActionCommand())) != null) {
            if (actionEvent.getSource() == this.inviteUserMenu) {
                room.inviteUser(this.chatApplet.getUser(this.selectedUserId).getName());
            } else {
                room.kickUser(this.chatApplet.getUser(this.selectedUserId).getName());
            }
            this.chatApplet.updateRoom(room, this.chatApplet.isConnected());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        int n = this.focusedUserId;
        this.focusedUserId = this.getUserAtPosition(mouseEvent.getPoint());
        if (this.focusedUserId != n) {
            this.repaint();
        }
        if (this.userAction == 1) {
            this.move(mouseEvent.getPoint(), true);
            return;
        }
        if (this.userAction == 2) {
            this.rotate(mouseEvent.getPoint(), true);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!mouseEvent.isMetaDown()) {
            if (this.userAction == 0) {
                int n = this.chatApplet.getCurrentUser().getPosition().x;
                int n2 = this.chatApplet.getCurrentUser().getPosition().y;
                this.userAction = new Rectangle(n - 6, n2 - 6, 12, 12).contains(mouseEvent.getPoint()) ? 1 : 2;
            }
            if (this.userAction == 1) {
                this.move(mouseEvent.getPoint(), false);
                return;
            }
            if (this.userAction == 2) {
                this.rotate(mouseEvent.getPoint(), false);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isMetaDown()) {
            this.selectedUserId = this.getUserAtPosition(new Point(mouseEvent.getX(), mouseEvent.getY()));
            if (this.selectedUserId != -1) {
                if (this.selectedUserId == this.chatApplet.getCurrentUserId()) {
                    this.ownUserPopup.show(this, mouseEvent.getX(), mouseEvent.getY());
                    return;
                }
                this.inviteUserMenu.removeAll();
                this.kickUserMenu.removeAll();
                Enumeration enumeration = this.chatApplet.getRoomIds();
                while (enumeration.hasMoreElements()) {
                    Room room = this.chatApplet.getRoom((Integer)enumeration.nextElement());
                    if (!room.isAdministrator(this.chatApplet.getCurrentUser().getName())) continue;
                    if (room.isPrivate()) {
                        this.inviteUserMenu.add(room.getName());
                        continue;
                    }
                    this.kickUserMenu.add(room.getName());
                }
                this.inviteUserMenu.setEnabled(this.inviteUserMenu.getItemCount() > 0);
                this.kickUserMenu.setEnabled(this.kickUserMenu.getItemCount() > 0);
                this.userPopup.show(this, mouseEvent.getX(), mouseEvent.getY());
                return;
            }
            if (this.chatApplet.getCurrentRoom().isAdministrator(this.chatApplet.getCurrentUser().getName())) {
                this.ownRoomPopup.show(this, mouseEvent.getX(), mouseEvent.getY());
                return;
            }
            this.roomPopup.show(this, mouseEvent.getX(), mouseEvent.getY());
            return;
        }
        if (this.userAction == 1) {
            this.move(mouseEvent.getPoint(), true);
        } else if (this.userAction == 2) {
            this.rotate(mouseEvent.getPoint(), true);
        }
        this.userAction = 0;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!mouseEvent.isMetaDown()) {
            if (this.userAction == 1) {
                this.move(mouseEvent.getPoint(), false);
                return;
            }
            if (this.userAction == 2) {
                this.rotate(mouseEvent.getPoint(), false);
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.focusedUserId;
        this.focusedUserId = this.getUserAtPosition(mouseEvent.getPoint());
        if (this.focusedUserId != n) {
            this.repaint();
        }
    }

    public void move(Point point, boolean bl) {
        if (new Rectangle(this.getSize()).contains(point)) {
            this.chatApplet.setUserPosition(this.chatApplet.getCurrentUser().getId(), point, bl);
        } else if (bl) {
            if (new Rectangle(this.getSize()).contains(point.x, 0)) {
                this.chatApplet.setUserPosition(this.chatApplet.getCurrentUser().getId(), new Point(point.x, this.chatApplet.getCurrentUser().getPosition().y), bl);
            } else if (new Rectangle(this.getSize()).contains(0, point.y)) {
                this.chatApplet.setUserPosition(this.chatApplet.getCurrentUser().getId(), new Point(this.chatApplet.getCurrentUser().getPosition().x, point.y), bl);
            }
        }
        this.repaint();
    }

    public void rotate(Point point, boolean bl) {
        this.chatApplet.setUserHeading(this.chatApplet.getCurrentUser().getId(), ChatUtil.getMiddleAngle(this.chatApplet.getCurrentUser().getHeading(), ChatUtil.getAngle(this.chatApplet.getCurrentUser().getPosition(), point)), bl);
        this.repaint();
    }
}

