/*
 * Decompiled with CFR 0.152.
 */
package chat;

import chat.ChatApplet;
import chat.ChatRepository;
import chat.ChatUtil;
import chat.FramedPanel;
import chat.InsetsPanel;
import chat.User;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class LoginPanel
extends Panel
implements ActionListener,
ItemListener {
    private Thread checkThread;
    private ChatApplet chatApplet;
    private FramedPanel connectionPanel;
    private FramedPanel userPanel;
    private FramedPanel loginAsPanel;
    private InsetsPanel buttonPanel;
    private Label hostLabel1;
    private Label hostLabel2;
    private Label portLabel;
    private Label portNrLabel;
    private Label nameLabel;
    private Label passwordLabel1;
    private Label passwordLabel2;
    private Label statusLabel;
    private CheckboxGroup loginCheckboxGroup;
    protected Checkbox newUserCheckbox;
    protected Checkbox existingUserCheckbox;
    protected TextField nameTextField;
    protected TextField passwordTextField1;
    protected TextField passwordTextField2;
    protected Button connectButton;
    protected Button disconnectButton;
    public static final int MODE_DEFAULT = 0;
    public static final int MODE_NEW_USERS = 1;
    public static final int MODE_EXISTING_USERS = 2;

    public LoginPanel(ChatApplet chatApplet, int n) {
        this.chatApplet = chatApplet;
        this.connectionPanel = new FramedPanel("Connection", ChatRepository.INSETS);
        this.connectionPanel.setLayout(new GridBagLayout());
        this.hostLabel1 = new Label("Host:", 2);
        this.portLabel = new Label("Port:", 2);
        this.hostLabel2 = new Label(this.chatApplet.getHost());
        this.portNrLabel = new Label(new Integer(this.chatApplet.getDefaultPort()).toString());
        ChatUtil.addWithBeginningConstraints(this.connectionPanel, this.hostLabel1);
        ChatUtil.addWithRemainingConstraints(this.connectionPanel, this.hostLabel2);
        ChatUtil.addWithBeginningConstraints(this.connectionPanel, this.portLabel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        ChatUtil.addWithConstraints(this.connectionPanel, this.portNrLabel, gridBagConstraints);
        this.userPanel = new FramedPanel("User", ChatRepository.INSETS);
        this.userPanel.setLayout(new GridBagLayout());
        this.loginAsPanel = new FramedPanel("Login as", ChatRepository.INSETS);
        this.loginAsPanel.setLayout(new GridBagLayout());
        this.loginCheckboxGroup = new CheckboxGroup();
        this.newUserCheckbox = new Checkbox("New User", this.loginCheckboxGroup, n != 2);
        this.existingUserCheckbox = new Checkbox("Existing User", this.loginCheckboxGroup, n == 2);
        this.newUserCheckbox.setEnabled(n != 2);
        this.existingUserCheckbox.setEnabled(n != 1);
        this.nameLabel = new Label("Name:", 2);
        this.passwordLabel1 = new Label("Password:", 2);
        this.passwordLabel2 = new Label("Password (Verification):", 2);
        this.nameTextField = new TextField(30);
        this.passwordTextField1 = new TextField(10);
        this.passwordTextField1.setEchoChar('*');
        this.passwordTextField2 = new TextField(10);
        this.passwordTextField2.setEchoChar('*');
        ChatUtil.addWithRemainingConstraints(this.loginAsPanel, this.newUserCheckbox);
        ChatUtil.addWithRemainingConstraints(this.loginAsPanel, this.existingUserCheckbox);
        ChatUtil.addWithBeginningConstraints(this.userPanel, this.nameLabel);
        ChatUtil.addWithRemainingConstraints(this.userPanel, this.nameTextField);
        ChatUtil.addWithBeginningConstraints(this.userPanel, this.passwordLabel1);
        ChatUtil.addWithRemainingConstraints(this.userPanel, this.passwordTextField1);
        ChatUtil.addWithBeginningConstraints(this.userPanel, this.passwordLabel2);
        ChatUtil.addWithRemainingConstraints(this.userPanel, this.passwordTextField2);
        this.buttonPanel = new InsetsPanel(ChatRepository.INSETS);
        this.buttonPanel.setLayout(new BorderLayout());
        this.connectButton = new Button("Connect");
        this.disconnectButton = new Button("Disconnect");
        this.statusLabel = new Label("Status:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = ChatRepository.SMALL_INSETS;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        ChatUtil.addWithConstraints(this.buttonPanel, this.connectButton, gridBagConstraints);
        gridBagConstraints.anchor = 12;
        ChatUtil.addWithConstraints(this.buttonPanel, this.disconnectButton, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        ChatUtil.addWithConstraints(this.buttonPanel, this.statusLabel, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        ChatUtil.addWithConstraints(this.buttonPanel, this.chatApplet.getLogo(), gridBagConstraints);
        this.passwordLabel2.setEnabled(this.newUserCheckbox.getState());
        this.passwordTextField2.setEnabled(this.newUserCheckbox.getState());
        this.connectButton.setEnabled(true);
        this.disconnectButton.setEnabled(false);
        this.setLayout(new BorderLayout());
        ((Component)this).setFont(ChatRepository.STANDARD_FONT);
        this.add((Component)this.connectionPanel, "North");
        this.add((Component)this.userPanel, "Center");
        this.add((Component)this.buttonPanel, "South");
        this.add((Component)this.loginAsPanel, "East");
        this.newUserCheckbox.addItemListener(this);
        this.existingUserCheckbox.addItemListener(this);
        this.connectButton.addActionListener(this);
        this.disconnectButton.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.connectButton) {
            int n;
            try {
                n = new Integer(this.portNrLabel.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n = this.chatApplet.getDefaultPort();
            }
            this.portNrLabel.setText(new Integer(n).toString());
            if (this.nameTextField.getText().equals("")) {
                this.chatApplet.setStatus("Can't connect: Empty name", true);
                this.nameTextField.requestFocus();
                return;
            }
            if (this.passwordTextField1.getText().equals("")) {
                this.chatApplet.setStatus("Can't connect: Empty password", true);
                return;
            }
            if (this.newUserCheckbox.getState() && this.passwordTextField2.getText().equals("")) {
                this.chatApplet.setStatus("Can't connect: Empty verification password", true);
                return;
            }
            if (this.newUserCheckbox.getState() && !this.passwordTextField1.getText().equals(this.passwordTextField2.getText())) {
                this.chatApplet.setStatus("Can't connect: Unmatching verification password", true);
                return;
            }
            if (this.newUserCheckbox.getState()) {
                this.chatApplet.getClient().connectAsNewUser(new User(this.nameTextField.getText(), this.passwordTextField1.getText()), n);
                return;
            }
            if (this.existingUserCheckbox.getState()) {
                this.chatApplet.getClient().connectAsExistingUser(this.nameTextField.getText(), this.passwordTextField1.getText(), n);
                return;
            }
        } else if (actionEvent.getSource() == this.disconnectButton) {
            this.chatApplet.getClient().disconnect();
            this.chatApplet.setFrameVisibility(false);
        }
    }

    public void setStatus(String string) {
        this.statusLabel.setText("Status: " + string);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.passwordLabel2.setEnabled(this.newUserCheckbox.getState());
        this.passwordTextField2.setEnabled(this.newUserCheckbox.getState());
    }

    public void setConnected(boolean bl) {
        this.connectButton.setEnabled(!bl);
        this.disconnectButton.setEnabled(bl);
    }
}

