/*
 * Decompiled with CFR 0.152.
 */
package chat;

import chat.ChatApplet;
import chat.ChatRepository;
import chat.ChatUtil;
import chat.FocusPanel;
import chat.InsetsPanel;
import chat.User;
import chat.UserPanel;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class EditableUserPanel
extends UserPanel
implements ActionListener,
AdjustmentListener,
ItemListener,
FocusListener,
MouseListener {
    private InsetsPanel buttonPanel;
    private InsetsPanel avatarButtonPanel;
    private Button applyButton = new Button("Apply");
    private Button addAvatarButton;
    private Button removeAvatarButton;

    public EditableUserPanel(ChatApplet chatApplet) {
        super(chatApplet);
        this.buttonPanel = new InsetsPanel(ChatRepository.INSETS);
        this.buttonPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        ChatUtil.addWithConstraints(this.buttonPanel, this.applyButton, gridBagConstraints);
        this.add((Component)this.buttonPanel, "South");
        this.avatarButtonPanel = new InsetsPanel(ChatRepository.INSETS);
        this.avatarButtonPanel.setLayout(new GridBagLayout());
        this.addAvatarButton = new Button("Add avatar");
        ChatUtil.addWithRemainingConstraints(this.avatarButtonPanel, this.addAvatarButton);
        this.removeAvatarButton = new Button("Remove avatar");
        ChatUtil.addWithRemainingConstraints(this.avatarButtonPanel, this.removeAvatarButton);
        this.avatarPanelLevel1.add((Component)this.avatarButtonPanel, "East");
        this.applyButton.addActionListener(this);
        this.addAvatarButton.addActionListener(this);
        this.removeAvatarButton.addActionListener(this);
        this.redBar.addAdjustmentListener(this);
        this.greenBar.addAdjustmentListener(this);
        this.blueBar.addAdjustmentListener(this);
        ((FocusPanel)this.singleAvatarPanel.elementAt(this.getNrOfAvatarPanels() - 1)).requestFocus();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.applyButton) {
            this.updateUser(this.chatApplet.getCurrentUser());
            return;
        }
        if (actionEvent.getSource() == this.addAvatarButton) {
            this.addAvatarPanel();
            return;
        }
        if (actionEvent.getSource() == this.removeAvatarButton && this.focusedAvatarIndex() != -1) {
            this.removeAvatarPanel(this.focusedAvatarIndex());
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getSource() == this.redBar || adjustmentEvent.getSource() == this.greenBar || adjustmentEvent.getSource() == this.blueBar) {
            this.currentPortraitCanvas.setFrameColor(new Color(this.redBar.getValue(), this.greenBar.getValue(), this.blueBar.getValue()));
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n = 0;
        while (n < this.getNrOfAvatarPanels()) {
            if (itemEvent.getItemSelectable() == this.serverAvatarCheck.elementAt(n) || itemEvent.getItemSelectable() == this.webAvatarCheck.elementAt(n)) {
                ((Choice)this.serverAvatarChoice.elementAt(n)).setEnabled(!((Checkbox)this.webAvatarCheck.elementAt(n)).getState());
                ((TextField)this.avatarURLField.elementAt(n)).setEditable(((Checkbox)this.webAvatarCheck.elementAt(n)).getState());
            }
            ++n;
        }
    }

    public void updateUser(User user) {
        boolean bl = this.chatApplet.getClient() != null && this.chatApplet.getClient().connected();
        User user2 = (User)user.clone();
        user2.setEmail(this.emailField.getText());
        user2.setHomepage(this.homepageField.getText());
        user2.setInfo(this.infoArea.getText());
        user2.setColor(new Color(this.redBar.getValue(), this.greenBar.getValue(), this.blueBar.getValue()));
        user2.setNrOfMoods(this.getNrOfAvatarPanels() - 1);
        user2.setBackAvatarURL(((Checkbox)this.webAvatarCheck.firstElement()).getState() ? ((TextField)this.avatarURLField.firstElement()).getText() : ChatApplet.SERVER_POTRAIT_FILENAME[((Choice)this.serverAvatarChoice.firstElement()).getSelectedIndex()][0]);
        int n = 1;
        while (n < this.getNrOfAvatarPanels()) {
            user2.setAvatarURL(n - 1, ((Checkbox)this.webAvatarCheck.elementAt(n)).getState() || n > 6 ? ((TextField)this.avatarURLField.elementAt(n)).getText() : ChatApplet.SERVER_POTRAIT_FILENAME[((Choice)this.serverAvatarChoice.elementAt(n)).getSelectedIndex()][n]);
            user2.setMoodKeywords(n - 1, ((TextField)this.avatarKeywordsField.elementAt(n)).getText());
            user2.setMoodName(n - 1, ((TextField)this.moodNameField.elementAt(n)).getText());
            try {
                user2.setMoodTimeout(n - 1, Integer.parseInt(((TextField)this.moodTimeoutField.elementAt(n)).getText()));
            }
            catch (NumberFormatException numberFormatException) {
                user2.setMoodTimeout(n - 1, 0);
            }
            ++n;
        }
        if (!(this.oldPasswordField.getText().equals("") && this.newPasswordField1.getText().equals("") && this.newPasswordField2.getText().equals(""))) {
            if (this.oldPasswordField.getText().equals("") || this.newPasswordField1.getText().equals("") || this.newPasswordField2.getText().equals("") || !this.newPasswordField1.getText().equals(this.newPasswordField2.getText()) || !this.oldPasswordField.getText().equals(user.getPassword())) {
                this.chatApplet.setStatus("Password could not be changed: Invalid data");
                return;
            }
            user2.setPassword(this.newPasswordField1.getText());
        }
        this.chatApplet.updateUser(user2, bl);
        this.chatApplet.showChat();
    }

    public void addAvatarPanel() {
        super.addAvatarPanel();
        this.updateAvatarButtons();
        ((Checkbox)this.webAvatarCheck.lastElement()).addItemListener(this);
        ((Checkbox)this.serverAvatarCheck.lastElement()).addItemListener(this);
        ((FocusPanel)this.singleAvatarPanel.lastElement()).addFocusListener(this);
        ((FocusPanel)this.singleAvatarPanel.lastElement()).addMouseListener(this);
        Component[] componentArray = ((FocusPanel)this.singleAvatarPanel.lastElement()).getComponents();
        int n = 0;
        while (n < componentArray.length) {
            componentArray[n].addFocusListener(this);
            componentArray[n].addMouseListener(this);
            ++n;
        }
    }

    public void removeAvatarPanel(int n) {
        super.removeAvatarPanel(n);
        this.focusGained(new FocusEvent((FocusPanel)this.singleAvatarPanel.firstElement(), 1004));
        this.updateAvatarButtons();
    }

    public void updateAvatarButtons() {
        if (this.removeAvatarButton != null) {
            this.removeAvatarButton.setEnabled(this.focusedAvatarIndex() > 6);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        int n = 0;
        while (n < this.getNrOfAvatarPanels()) {
            if (((FocusPanel)this.singleAvatarPanel.elementAt(n)).isAncestorOf(focusEvent.getComponent())) {
                if (this.focusedAvatarIndex() != -1) {
                    ((FocusPanel)this.singleAvatarPanel.elementAt(this.focusedAvatarIndex())).transferFocus();
                }
                ((FocusPanel)this.singleAvatarPanel.elementAt(n)).requestFocus();
                this.updateAvatarButtons();
            }
            ++n;
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public int focusedAvatarIndex() {
        int n = 0;
        while (n < this.getNrOfAvatarPanels()) {
            if (((FocusPanel)this.singleAvatarPanel.elementAt(n)).hasFocus()) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.focusGained(new FocusEvent(mouseEvent.getComponent(), 1004));
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

