/*
 * Decompiled with CFR 0.152.
 */
package chat;

import chat.ChatApplet;
import chat.ChatRepository;
import chat.ChatUtil;
import chat.FramedPanel;
import chat.InsetsPanel;
import chat.Room;
import chat.RoomPanel;
import java.awt.Button;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.Vector;

public class EditableRoomPanel
extends RoomPanel
implements ActionListener,
ItemListener,
KeyListener {
    private FramedPanel editUserListPanel;
    private InsetsPanel buttonPanel;
    private Button addUserButton;
    private Button removeUserButton;
    private Button applyButton;
    private Button removeButton;
    private TextField userField;

    public EditableRoomPanel(ChatApplet chatApplet) {
        super(chatApplet);
        this.userList.setSelectable(true);
        this.editUserListPanel = new FramedPanel("", ChatRepository.INSETS);
        this.editUserListPanel.setLayout(new GridBagLayout());
        ChatUtil.addWithBeginningConstraints(this.editUserListPanel, new Label("User:", 2));
        this.userField = new TextField();
        ChatUtil.addWithRemainingConstraints(this.editUserListPanel, this.userField);
        this.addUserButton = new Button("");
        ChatUtil.addWithRemainingConstraints(this.editUserListPanel, this.addUserButton);
        this.removeUserButton = new Button("");
        ChatUtil.addWithRemainingConstraints(this.editUserListPanel, this.removeUserButton);
        this.userAccessPanel.add(this.editUserListPanel);
        this.applyButton = new Button("Apply");
        this.removeButton = new Button("Remove");
        this.buttonPanel = new InsetsPanel(ChatRepository.INSETS);
        this.buttonPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        ChatUtil.addWithConstraints(this.buttonPanel, this.removeButton, gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        ChatUtil.addWithConstraints(this.buttonPanel, this.applyButton, gridBagConstraints);
        this.add((Component)this.buttonPanel, "South");
        this.userField.addKeyListener(this);
        this.publicAccessCheckbox.addItemListener(this);
        this.privateAccessCheckbox.addItemListener(this);
        this.removeButton.addActionListener(this);
        this.applyButton.addActionListener(this);
        this.addUserButton.addActionListener(this);
        this.removeUserButton.addActionListener(this);
        this.addUserButton.setEnabled(false);
        this.removeUserButton.setEnabled(this.userList.getNrOfRows() > 0);
    }

    public void toggleUserPanel(boolean bl) {
        super.toggleUserPanel(bl);
        if (bl) {
            this.editUserListPanel.setTitle("(Un)invite User");
            this.addUserButton.setLabel("Invite");
            this.removeUserButton.setLabel("Uninvite");
        } else {
            this.editUserListPanel.setTitle("(Un)kick User");
            this.addUserButton.setLabel("Kick");
            this.removeUserButton.setLabel("Unkick");
        }
        this.removeUserButton.setEnabled(this.userList.getNrOfRows() > 0);
    }

    private boolean containsString(Vector vector, String string) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement().toString();
            if (string2 == null || !string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private String findString(Vector vector, String string) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement().toString();
            if (string2 == null || !string2.equals(string)) continue;
            return string2;
        }
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.applyButton) {
            this.updateRoom(this.chatApplet.getCurrentRoom());
        }
        if (actionEvent.getSource() == this.removeButton) {
            this.chatApplet.forceRoomRemoval(this.chatApplet.getCurrentRoomId(), this.chatApplet.getClient() != null && this.chatApplet.getClient().connected());
            this.chatApplet.showChat();
            return;
        }
        if (actionEvent.getSource() == this.addUserButton) {
            String[] stringArray = new String[1];
            stringArray[0] = this.userField.getText();
            if (stringArray[0].length() > 0) {
                if (this.privateAccessCheckbox.getState() && !this.containsString(this.invitedUserVector, stringArray[0])) {
                    this.invitedUserVector.addElement(stringArray[0]);
                    this.updateUserList(this.invitedUserVector);
                } else if (!this.containsString(this.kickedUserVector, stringArray[0])) {
                    this.kickedUserVector.addElement(stringArray[0]);
                    this.updateUserList(this.kickedUserVector);
                }
                ((TextComponent)this.userField).setText("");
                this.removeUserButton.setEnabled(this.userList.getNrOfRows() > 0);
                return;
            }
        } else if (actionEvent.getSource() == this.removeUserButton) {
            if (this.privateAccessCheckbox.getState()) {
                this.invitedUserVector.removeElement(this.findString(this.invitedUserVector, this.userList.getCellText(this.userList.getSelectedRow(), 0)));
                this.updateUserList(this.invitedUserVector);
            } else {
                this.kickedUserVector.removeElement(this.findString(this.kickedUserVector, this.userList.getCellText(this.userList.getSelectedRow(), 0)));
                this.updateUserList(this.kickedUserVector);
            }
            this.removeUserButton.setEnabled(this.userList.getNrOfRows() > 0);
        }
    }

    public void showRoom(Room room) {
        super.showRoom(room);
        this.nameField.setEditable(room.getId() != 0);
        this.privateAccessCheckbox.setEnabled(room.getId() != 0);
        this.publicAccessCheckbox.setEnabled(room.getId() != 0);
        this.infoArea.setEditable(room.getId() != 0);
        this.rulesArea.setEditable(room.getId() != 0);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.toggleUserPanel(this.privateAccessCheckbox.getState());
    }

    public void updateRoom(Room room) {
        Room room2 = (Room)room.clone();
        room2.setPrivate(this.privateAccessCheckbox.getState());
        room2.setName(this.nameField.getText());
        room2.setInfo(this.infoArea.getText());
        room2.setRules(this.rulesArea.getText());
        room2.setInvitedUsers((Vector)this.invitedUserVector.clone());
        room2.setKickedUsers((Vector)this.kickedUserVector.clone());
        this.chatApplet.updateRoom(room2, this.chatApplet.isConnected());
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.addUserButton.setEnabled(this.userField.getText().length() > 0);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

