/*
 * Decompiled with CFR 0.152.
 */
package chat;

import chat.ChatApplet;
import chat.ChatPanel;
import chat.ChatRepository;
import chat.EditableRoomPanel;
import chat.EditableUserPanel;
import chat.InfoPanel;
import chat.InsetsPanel;
import chat.Room;
import chat.UneditableRoomPanel;
import chat.UneditableUserPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import symantec.itools.awt.TabPanel;

public class ChatFrame
extends Frame
implements ComponentListener,
WindowListener {
    private TabPanel tabPanel;
    private ChatPanel chatPanel;
    private EditableUserPanel editableUserPanel;
    private UneditableUserPanel uneditableUserPanel;
    protected EditableRoomPanel editableRoomPanel;
    private UneditableRoomPanel uneditableRoomPanel;
    private InfoPanel infoPanel;
    private Panel statusPanel;
    private Label statusLabel;
    private Frame uneditableUserFrame;
    private Frame uneditableRoomFrame;
    private ChatApplet chatApplet;

    public ChatFrame(ChatApplet chatApplet) {
        this.chatApplet = chatApplet;
        this.setIconImage(this.chatApplet.getImage("v.gif"));
        ((Component)this).setBackground(ChatRepository.CONTAINER_BACKGROUND);
        ((Component)this).setFont(ChatRepository.STANDARD_FONT);
        this.setLayout(new BorderLayout());
        this.tabPanel = new TabPanel();
        this.chatPanel = new ChatPanel(chatApplet);
        this.chatPanel.addComponentListener(this);
        this.editableUserPanel = new EditableUserPanel(chatApplet);
        this.uneditableUserPanel = new UneditableUserPanel(chatApplet);
        this.editableUserPanel.showUser(this.chatApplet.getCurrentUser());
        this.editableUserPanel.addComponentListener(this);
        this.uneditableUserFrame = new Frame();
        this.uneditableUserFrame.setIconImage(this.chatApplet.getImage("v.gif"));
        this.uneditableUserFrame.setLayout(new BorderLayout());
        ((Component)this.uneditableUserFrame).setBackground(ChatRepository.CONTAINER_BACKGROUND);
        ((Component)this.uneditableUserFrame).setFont(ChatRepository.STANDARD_FONT);
        this.uneditableUserFrame.add((Component)this.uneditableUserPanel, "Center");
        ((Component)this.uneditableUserFrame).setSize(480, 320);
        ((Component)this.uneditableUserFrame).setVisible(false);
        this.uneditableUserFrame.addWindowListener(this);
        this.editableRoomPanel = new EditableRoomPanel(chatApplet);
        this.uneditableRoomPanel = new UneditableRoomPanel(chatApplet);
        this.editableRoomPanel.showRoom(this.chatApplet.getCurrentRoom());
        this.editableRoomPanel.addComponentListener(this);
        this.uneditableRoomFrame = new Frame();
        this.uneditableRoomFrame.setIconImage(this.chatApplet.getImage("v.gif"));
        this.uneditableRoomFrame.setLayout(new BorderLayout());
        ((Component)this.uneditableRoomFrame).setBackground(ChatRepository.CONTAINER_BACKGROUND);
        ((Component)this.uneditableRoomFrame).setFont(ChatRepository.STANDARD_FONT);
        this.uneditableRoomFrame.add((Component)this.uneditableRoomPanel, "Center");
        ((Component)this.uneditableRoomFrame).setSize(560, 440);
        ((Component)this.uneditableRoomFrame).setVisible(false);
        this.uneditableRoomFrame.addWindowListener(this);
        this.infoPanel = new InfoPanel(chatApplet);
        this.statusPanel = new InsetsPanel(new Insets(0, ChatRepository.INSETS.left, 0, ChatRepository.INSETS.right));
        this.statusPanel.setLayout(new BorderLayout());
        this.statusLabel = new Label("Status:");
        this.statusPanel.add((Component)this.statusLabel, "Center");
        this.statusPanel.add((Component)this.chatApplet.getLogo(), "East");
        this.tabPanel.addTabPanel("Chat", true, this.chatPanel);
        this.tabPanel.addTabPanel("User", true, this.editableUserPanel);
        this.tabPanel.addTabPanel("Room", true, this.editableRoomPanel);
        if (this.chatApplet.getBooleanParam("InfoTabVisibility", true)) {
            this.tabPanel.addTabPanel("Info", true, this.infoPanel);
        }
        this.add((Component)this.tabPanel, "Center");
        this.add((Component)this.statusPanel, "South");
        this.setTitle("Chat");
        this.addWindowListener(this);
        this.updateRoomTab();
    }

    public void repaintView() {
        this.chatPanel.repaintView();
    }

    public void updateRoomList() {
        this.chatPanel.updateRoomList();
        this.updateRoomTab();
    }

    public void repaintRoom() {
        this.chatPanel.repaintRoom();
    }

    public void repaintMood() {
        this.chatPanel.repaintMood();
    }

    public void repaintAll() {
        this.chatPanel.repaintView();
        this.chatPanel.repaintRoom();
        this.chatPanel.repaintMood();
    }

    public void fillRoomList() {
        this.chatPanel.fillRoomList();
    }

    public void setStatus(String string) {
        this.statusLabel.setText("Status: " + string);
    }

    public void showUser(int n) {
        if (this.chatApplet.getUser(n) != null) {
            this.uneditableUserPanel.showUser(this.chatApplet.getUser(n));
            this.uneditableUserFrame.setTitle(this.chatApplet.getUser(n).getName());
            ((Component)this.uneditableUserFrame).setVisible(true);
        }
    }

    public void editUser(int n) {
        if (n == this.chatApplet.getCurrentUserId() && this.chatApplet.getUser(n) != null) {
            this.editableUserPanel.showUser(this.chatApplet.getUser(n));
            try {
                this.tabPanel.setTabPanel("User", true, this.editableUserPanel, 1);
            }
            catch (Exception exception) {}
            this.tabPanel.showTabPanel(1);
        }
    }

    public void repaintCurrentUser() {
        this.editableUserPanel.showUser(this.chatApplet.getCurrentUser());
        try {
            this.tabPanel.setTabPanel("User", true, this.editableUserPanel, 1);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void showChat() {
        this.tabPanel.showTabPanel(0);
    }

    public void showRoom(int n) {
        Room room = this.chatApplet.getRoom(n);
        if (room != null) {
            this.uneditableRoomPanel.showRoom(room);
            this.uneditableRoomFrame.setTitle(room.getName());
            ((Component)this.uneditableRoomFrame).setVisible(true);
        }
    }

    public void editRoom(int n) {
        this.editRoom(n, true);
    }

    public void editRoom(int n, boolean bl) {
        Room room = this.chatApplet.getRoom(n);
        if (room != null && room.isAdministrator(this.chatApplet.getCurrentUser().getName())) {
            this.editableRoomPanel.showRoom(room);
            try {
                this.tabPanel.setTabPanel("Room", true, this.editableRoomPanel, 2);
            }
            catch (Exception exception) {}
            if (bl) {
                this.tabPanel.showTabPanel(2);
            }
        }
    }

    public void updateRoomTab() {
        Room room = this.chatApplet.getCurrentRoom();
        try {
            this.tabPanel.setEnabled(room != null && room.isAdministrator(this.chatApplet.getCurrentUser().getName()), 2);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
        if (componentEvent.getComponent() == this.editableUserPanel) {
            this.editableUserPanel.showUser(this.chatApplet.getCurrentUser());
            try {
                this.tabPanel.setTabPanel("User", true, this.editableUserPanel, 1);
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getComponent() == this) {
            this.chatApplet.stopChat();
            return;
        }
        if (windowEvent.getComponent() == this.uneditableUserFrame) {
            ((Component)this.uneditableUserFrame).setVisible(false);
            return;
        }
        if (windowEvent.getComponent() == this.uneditableRoomFrame) {
            ((Component)this.uneditableRoomFrame).setVisible(false);
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void addMessage(String string, String string2) {
        this.chatPanel.addMessage(string, string2);
    }

    public void clearMessage() {
        this.chatPanel.clearMessage();
    }

    public void setMessageLabel(String string) {
        this.chatPanel.chatLabel.setText(string);
        this.chatPanel.chatLabel.invalidate();
        this.chatPanel.chatLabel.validate();
        this.chatPanel.invalidate();
        this.chatPanel.validate();
        this.chatPanel.chatField.requestFocus();
    }
}

