/*
 * Decompiled with CFR 0.152.
 */
package chat;

import chat.ChatApplet;
import chat.ExistingUserLoginRequest;
import chat.NewUserLoginRequest;
import chat.RoomCreateEvent;
import chat.RoomListEvent;
import chat.RoomRemoveEvent;
import chat.RoomUpdateEvent;
import chat.User;
import chat.UserHeadingEvent;
import chat.UserLoginEvent;
import chat.UserLoginRequest;
import chat.UserLogoutEvent;
import chat.UserMessageEvent;
import chat.UserMoodEvent;
import chat.UserPositionEvent;
import chat.UserRoomEvent;
import chat.UserUpdateEvent;
import chat.UserWhisperEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;

public class ChatClient
implements Runnable {
    private Socket clientSocket;
    private Thread clientThread;
    private String host;
    private boolean connected;
    private ChatApplet chatApplet;
    private ObjectOutputStream output;
    private ObjectInputStream input;
    private volatile UserLoginRequest userLogin;

    public ChatClient(String string, ChatApplet chatApplet) {
        this.host = string;
        this.chatApplet = chatApplet;
    }

    public void connect(int n) {
        try {
            this.chatApplet.setStatus("Connecting...", true);
            this.clientSocket = new Socket(this.host, n);
            this.input = new ObjectInputStream(this.clientSocket.getInputStream());
            this.output = new ObjectOutputStream(this.clientSocket.getOutputStream());
            this.connected = true;
            this.clientThread = new Thread(this);
            this.clientThread.start();
            this.chatApplet.notifyConnected(this.connected);
            this.chatApplet.setStatus("Connected", true);
            return;
        }
        catch (Exception exception) {
            this.connected = false;
            this.chatApplet.notifyConnected(this.connected);
            this.chatApplet.setStatus("Exception while connecting. Server down, firewall config or file-URL applet.", true);
            return;
        }
    }

    public void connectAsExistingUser(String string, String string2, int n) {
        this.connect(n);
        if (this.connected) {
            this.chatApplet.setStatus("Connecting as existing user...", true);
            this.chatApplet.stopSimulator();
            this.chatApplet.removeAllExceptDefaultRoom();
            this.userLogin = new ExistingUserLoginRequest(string, string2);
            this.login();
        }
    }

    public void connectAsNewUser(User user, int n) {
        this.connect(n);
        if (this.connected) {
            this.chatApplet.setStatus("Connecting as new user...", true);
            this.chatApplet.stopSimulator();
            this.chatApplet.removeAllExceptDefaultRoom();
            this.userLogin = new NewUserLoginRequest(user);
            this.login();
        }
    }

    private void login() {
        this.chatApplet.setStatus("Waiting for server reply...", true);
        ChatClient chatClient = this;
        synchronized (chatClient) {
            this.send(this.userLogin);
            while (this.userLogin.status == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.userLogin.status == 1) {
            int n = this.chatApplet.getCurrentUserId();
            this.chatApplet.setCurrentUser(this.userLogin.user);
            if (n != this.userLogin.user.getId()) {
                this.chatApplet.removeUser(n);
            }
            this.chatApplet.moveUserToRoom(this.userLogin.user.getId(), 0, true);
            this.chatApplet.restartHistory();
            this.chatApplet.setStatus("Login accepted: " + this.userLogin.statusString, true);
            this.chatApplet.setFrameVisibility(true);
            return;
        }
        this.disconnect();
        this.chatApplet.setStatus("Login denied: " + this.userLogin.statusString, true);
    }

    public void disconnect() {
        this.disconnect(true);
    }

    public void disconnect(boolean bl) {
        try {
            try {
                if (bl) {
                    this.send(new UserLogoutEvent(this.chatApplet.getCurrentUserId()));
                }
                if (this.clientThread != null && this.clientThread.isAlive()) {
                    this.clientThread.stop();
                }
                if (this.output != null) {
                    this.output.close();
                }
                if (this.input != null) {
                    this.input.close();
                }
                if (this.clientSocket != null) {
                    this.clientSocket.close();
                }
                this.chatApplet.setStatus("Disconnected", true);
            }
            catch (Exception exception) {
                this.chatApplet.setStatus("Exception while disconnecting", true);
            }
            Object var3_2 = null;
            this.connected = false;
            this.chatApplet.notifyConnected(this.connected);
            this.chatApplet.removeAllExceptCurrentUser();
            this.chatApplet.removeAllExceptDefaultRoom();
            return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.connected = false;
            this.chatApplet.notifyConnected(this.connected);
            this.chatApplet.removeAllExceptCurrentUser();
            this.chatApplet.removeAllExceptDefaultRoom();
            throw throwable;
        }
    }

    public void run() {
        ChatClient chatClient;
        while (this.connected) {
            try {
                Object object = this.input.readObject();
                if (object instanceof UserPositionEvent) {
                    this.chatApplet.setUserPosition(((UserPositionEvent)object).userId, ((UserPositionEvent)object).userPosition, false, false);
                    continue;
                }
                if (object instanceof UserHeadingEvent) {
                    this.chatApplet.setUserHeading(((UserHeadingEvent)object).userId, ((UserHeadingEvent)object).userHeading, false);
                    continue;
                }
                if (object instanceof UserWhisperEvent) {
                    this.chatApplet.setUserMessage(((UserWhisperEvent)object).userId, "[Whispers] " + ((UserWhisperEvent)object).userMessage, false);
                    continue;
                }
                if (object instanceof UserMessageEvent) {
                    this.chatApplet.setUserMessage(((UserMessageEvent)object).userId, ((UserMessageEvent)object).userMessage, false);
                    continue;
                }
                if (object instanceof UserMoodEvent) {
                    this.chatApplet.setUserMood(((UserMoodEvent)object).userId, ((UserMoodEvent)object).userMood, false);
                    continue;
                }
                if (object instanceof UserRoomEvent) {
                    this.chatApplet.moveUserToRoom(((UserRoomEvent)object).userId, ((UserRoomEvent)object).roomId, false);
                    this.chatApplet.setUserPosition(((UserRoomEvent)object).userId, ((UserRoomEvent)object).position, false, false);
                    continue;
                }
                if (object instanceof UserUpdateEvent) {
                    this.chatApplet.updateUser(((UserUpdateEvent)object).user, false);
                    if (((UserUpdateEvent)object).user.getId() != this.chatApplet.getCurrentUserId()) continue;
                    this.chatApplet.setStatus(((UserUpdateEvent)object).statusString, false);
                    continue;
                }
                if (object instanceof UserLoginEvent) {
                    this.chatApplet.addUser(((UserLoginEvent)object).user);
                    continue;
                }
                if (object instanceof UserLogoutEvent) {
                    this.chatApplet.removeUser(((UserLogoutEvent)object).userId);
                    continue;
                }
                if (object instanceof NewUserLoginRequest) {
                    chatClient = this;
                    synchronized (chatClient) {
                        this.chatApplet.setStatus("Received login", true);
                        this.userLogin = (NewUserLoginRequest)object;
                        this.notify();
                        continue;
                    }
                }
                if (object instanceof ExistingUserLoginRequest) {
                    chatClient = this;
                    synchronized (chatClient) {
                        this.chatApplet.setStatus("Received login", true);
                        this.userLogin = (ExistingUserLoginRequest)object;
                        this.notify();
                        continue;
                    }
                }
                if (object instanceof RoomUpdateEvent) {
                    this.chatApplet.setStatus("Received room update", true);
                    this.chatApplet.updateRoom(((RoomUpdateEvent)object).room, false);
                    continue;
                }
                if (object instanceof RoomCreateEvent) {
                    this.chatApplet.setStatus("Received room creation", true);
                    this.chatApplet.updateRoom(((RoomCreateEvent)object).room, false);
                    continue;
                }
                if (object instanceof RoomListEvent) {
                    this.chatApplet.setStatus("Received room list", true);
                    this.chatApplet.setRoomTable(((RoomListEvent)object).roomTable);
                    continue;
                }
                if (!(object instanceof RoomRemoveEvent)) continue;
                this.chatApplet.setStatus("Received room removal", true);
                this.chatApplet.forceRoomRemoval(((RoomRemoveEvent)object).roomId, false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("Exception while receiving data: " + exception + ". Going offline...");
                this.chatApplet.setStatus("Exception while receiving data. Going offline...", true);
                this.disconnect();
            }
        }
        chatClient = this;
        synchronized (chatClient) {
            this.notify();
            return;
        }
    }

    public void send(Object object) {
        block5: {
            try {
                if (!this.connected) break block5;
                ObjectOutputStream objectOutputStream = this.output;
                synchronized (objectOutputStream) {
                    this.output.writeObject(object);
                }
                this.output.flush();
                return;
            }
            catch (IOException iOException) {
                System.out.println("Exception while sending data: " + iOException + ". Going offline...");
                this.chatApplet.setStatus("Exception while sending data. Going offline...", true);
                this.disconnect(false);
            }
        }
    }

    public boolean connected() {
        return this.connected;
    }

    public String getHost() {
        return this.host;
    }
}

