/*
 * Decompiled with CFR 0.152.
 */
package chat;

import chat.ChatClient;
import chat.ChatFrame;
import chat.ChatRepository;
import chat.ChatUtil;
import chat.HistoryEntry;
import chat.HistoryPanel;
import chat.ImageCanvas;
import chat.IntegerHashtable;
import chat.LoginPanel;
import chat.Room;
import chat.RoomCreateEvent;
import chat.RoomRemoveEvent;
import chat.RoomUpdateEvent;
import chat.Simulator;
import chat.User;
import chat.UserHeadingEvent;
import chat.UserMessageEvent;
import chat.UserMoodEvent;
import chat.UserPositionEvent;
import chat.UserRoomEvent;
import chat.UserUpdateEvent;
import chat.UserWhisperEvent;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;

public class ChatApplet
extends Applet
implements ChatRepository,
Runnable {
    protected LoginPanel loginPanel;
    private ChatFrame chatFrame;
    private ChatClient chatClient;
    private Image[] moodIcon;
    private Image[] defaultAvatar;
    private Image emptyIcon;
    private Image unknownIcon;
    private Image defaultBackAvatar;
    private Image imgSlider;
    private IntegerHashtable userTable;
    private IntegerHashtable roomTable;
    private IntegerHashtable userRoomTable;
    private int currentUserId;
    private Date histDate;
    private Date chatStartDate;
    private boolean historyMode;
    private boolean chatRunning;
    private String status;
    private Simulator simulator;
    private HistoryPanel pnlHistory;
    private Hashtable hashHistory;
    private Thread thrMoodTimeout;
    private ImageCanvas logoCanvas;
    private MediaTracker tracker;
    private int whisperUserId = -1;
    private int trackerId;
    public static String[][] SERVER_POTRAIT_FILENAME = new String[][]{{"smiley6.gif", "smiley0.gif", "smiley1.gif", "smiley2.gif", "smiley3.gif", "smiley4.gif", "smiley5.gif"}, {"man1.gif", "man1.gif", "man1.gif", "man1.gif", "man1.gif", "man1.gif", "man1.gif"}, {"man2.gif", "man2.gif", "man2.gif", "man2.gif", "man2.gif", "man2.gif", "man2.gif"}, {"woman1.gif", "woman1.gif", "woman1.gif", "woman1.gif", "woman1.gif", "woman1.gif", "woman1.gif"}, {"woman2.gif", "woman2.gif", "woman2.gif", "woman2.gif", "woman2.gif", "woman2.gif", "woman2.gif"}, {"baghead.gif", "baghead.gif", "baghead.gif", "baghead.gif", "baghead.gif", "baghead.gif", "baghead.gif"}, {"teddy.gif", "teddy.gif", "teddy.gif", "teddy.gif", "teddy.gif", "teddy.gif", "teddy.gif"}, {"moonmask.gif", "moonmask.gif", "moonmask.gif", "moonmask.gif", "moonmask.gif", "moonmask.gif", "moonmask.gif"}, {"darkmask.gif", "darkmask.gif", "darkmask.gif", "darkmask.gif", "darkmask.gif", "darkmask.gif", "darkmask.gif"}};
    public static String[] SERVER_POTRAIT_NAME = new String[]{"Smiley", "Man 1", "Man 2", "Woman 1", "Woman 2", "Baghead", "Teddy", "Moon Mask", "Dark Mask"};
    private Random random = new Random();

    protected boolean getBooleanParam(String string, boolean bl) {
        if (this.getParameter(string) == null) {
            return bl;
        }
        return new Boolean(this.getParameter(string));
    }

    public void init() {
        int n;
        String string;
        Vector<AvatarParam> vector = new Vector<AvatarParam>();
        int n2 = 0;
        while ((string = this.getParameter("PredefinedAvatar[" + n2 + "]")) != null) {
            n = string.indexOf(":");
            if (n != -1) {
                AvatarParam avatarParam = new AvatarParam();
                avatarParam.name = string.substring(0, n);
                StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n + 1), ",");
                int n3 = 0;
                while (n3 <= 6) {
                    avatarParam.image[n3] = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : (n3 > 1 ? avatarParam.image[1] : new String(""));
                    ++n3;
                }
                vector.addElement(avatarParam);
            }
            ++n2;
        }
        if (vector.size() > 0) {
            SERVER_POTRAIT_NAME = new String[vector.size()];
            SERVER_POTRAIT_FILENAME = new String[vector.size()][7];
            n = 0;
            while (n < vector.size()) {
                ChatApplet.SERVER_POTRAIT_NAME[n] = ((AvatarParam)vector.elementAt((int)n)).name;
                int n4 = 0;
                while (n4 <= 6) {
                    ChatApplet.SERVER_POTRAIT_FILENAME[n][n4] = ((AvatarParam)vector.elementAt((int)n)).image[n4];
                    ++n4;
                }
                ++n;
            }
        }
        this.logoCanvas = new ImageCanvas(this.getImage("logo.gif", true), ChatRepository.LOGO_DIMENSION);
        this.logoCanvas.showDocumentOnClick(this, "http://www.tk.uni-linz.ac.at");
        this.moodIcon = new Image[6];
        this.defaultAvatar = new Image[6];
        this.defaultBackAvatar = this.getImage(SERVER_POTRAIT_FILENAME[0][0]);
        n = 0;
        while (n < 6) {
            this.moodIcon[n] = this.getImage(ChatRepository.MOOD_ICON_NAME[n]);
            this.defaultAvatar[n] = this.getImage(SERVER_POTRAIT_FILENAME[0][n + 1]);
            ++n;
        }
        this.emptyIcon = this.getImage("iconEmpty.gif");
        this.unknownIcon = this.getImage("iconUnknown.gif");
        this.setBackground(ChatRepository.CONTAINER_BACKGROUND);
        this.imgSlider = this.getImage("slider.gif", true);
        this.setLayout(new GridLayout());
        this.loginPanel = new LoginPanel(this, this.getParameter("LoginMode") == null ? 0 : ChatUtil.getInt(this.getParameter("LoginMode")));
        this.add(this.loginPanel);
        this.chatClient = new ChatClient(this.getHost(), this);
        this.startChat(this.getBooleanParam("DemoMode", true));
        if (this.getBooleanParam("AutoLogin", false) && this.getParameter("User") != null && this.getParameter("Password") != null) {
            ((TextComponent)this.loginPanel.nameTextField).setText(this.getParameter("User"));
            ((TextComponent)this.loginPanel.passwordTextField1).setText(this.getParameter("Password"));
            ((TextComponent)this.loginPanel.passwordTextField2).setText(this.getParameter("Password"));
            this.loginPanel.actionPerformed(new ActionEvent(this.loginPanel.connectButton, 1001, this.loginPanel.connectButton.getActionCommand()));
        }
    }

    public void destroy() {
        if (System.getProperty("java.vendor").indexOf("Netscape") != -1) {
            this.stopChat();
        }
    }

    public void stop() {
        if (System.getProperty("java.vendor").indexOf("Netscape") == -1) {
            this.stopChat();
        }
    }

    public void setFrameVisibility(boolean bl) {
        ((Component)this.chatFrame).setVisible(bl);
    }

    public void startChat(boolean bl) {
        this.userTable = new IntegerHashtable();
        this.roomTable = new IntegerHashtable();
        this.hashHistory = new Hashtable();
        this.chatStartDate = new Date();
        int n = 0;
        while (n < ChatRepository.STANDARD_ROOM_NAME.length) {
            Room room = new Room(n, ChatRepository.STANDARD_ROOM_NAME[n], ChatRepository.ROOM_DIMENSION);
            room.setAdministrator("Admin");
            room.setPrivate(ChatRepository.STANDARD_ROOM_PRIVATE[n]);
            room.setDemo(n != 0);
            if (ChatRepository.STANDARD_ROOM_INVITED[n]) {
                room.inviteUser("Guest");
            }
            this.addRoom(room);
            ++n;
        }
        User user = new User(0, "Guest", "", Color.red, new Point(ChatRepository.ROOM_DIMENSION.width / 2, ChatRepository.ROOM_DIMENSION.height / 2), 0, 0, 0);
        user.setBackAvatar(this.defaultBackAvatar);
        int n2 = 0;
        while (n2 < 6) {
            user.setAvatar(n2, this.defaultAvatar[n2]);
            ++n2;
        }
        this.setCurrentUser(user);
        if (bl) {
            this.simulator = new Simulator(this);
            this.simulator.start();
            User[] userArray = new User[ChatRepository.ROBOT_NAME.length];
            int n3 = 0;
            while (n3 < ChatRepository.ROBOT_NAME.length) {
                userArray[n3] = new User(1000000 + n3, ChatRepository.ROBOT_NAME[n3], "", new Color((int)(this.random.nextDouble() * 160.0), (int)(this.random.nextDouble() * 160.0), (int)(this.random.nextDouble() * 160.0)), new Point((int)(this.random.nextDouble() * 150.0), (int)(this.random.nextDouble() * 150.0)), (int)(this.random.nextDouble() * 360.0), 0, 1);
                this.addUser(userArray[n3]);
                userArray[n3].setAvatar(0, this.getImage(ChatRepository.ROBOT_PORTRAIT_FILENAME[n3]));
                userArray[n3].setCommercialBanner(ChatRepository.ROBOT_COMMERCIAL_BANNER[n3]);
                this.simulator.addUser(userArray[n3]);
                ++n3;
            }
        }
        this.chatFrame = new ChatFrame(this);
        ((Component)this.chatFrame).setSize(800, 720);
        ((Component)this.chatFrame).setVisible(bl);
        this.historyMode = false;
        this.setStatus("", true);
        this.chatRunning = true;
    }

    public void stopChat() {
        this.chatRunning = false;
        this.chatClient.disconnect();
        if (this.simulator != null && this.simulator.isAlive()) {
            this.simulator.stop();
        }
        if (this.chatFrame != null) {
            ((Component)this.chatFrame).setVisible(false);
        }
    }

    public boolean chatRunning() {
        return this.chatRunning;
    }

    public void fillRoomList() {
        if (this.chatFrame != null) {
            this.chatFrame.fillRoomList();
        }
    }

    public void repaintAll() {
        if (this.chatFrame != null) {
            this.chatFrame.repaintAll();
        }
    }

    public void repaintView() {
        if (this.chatFrame != null) {
            this.chatFrame.repaintView();
        }
    }

    public void updateRoomList() {
        if (this.chatFrame != null) {
            this.chatFrame.updateRoomList();
        }
    }

    public void repaintRoom() {
        if (this.chatFrame != null) {
            this.chatFrame.repaintRoom();
        }
    }

    public void repaintMood() {
        if (this.chatFrame != null) {
            this.chatFrame.repaintMood();
        }
    }

    public void repaintUser() {
    }

    public synchronized void addUser(User user) {
        this.userTable.put(user.getId(), user);
        this.moveUserToRoom(user.getId(), user.getRoom(), false);
        if (user.getRoom() == this.getCurrentRoomId()) {
            this.repaintRoom();
            if (user.getId() == this.getCurrentUserId() || this.inVisualRange(this.getCurrentUserId(), user.getId())) {
                this.repaintView();
            }
        }
    }

    public synchronized void addRoom(Room room) {
        this.roomTable.put(room.getId(), room);
        this.repaintAll();
        this.fillRoomList();
    }

    public synchronized void removeUser(int n) {
        if (n != this.getCurrentUserId() && this.userTable.containsKey(n)) {
            int n2 = this.getUser(n).getRoom();
            this.getRoom(n2).removeUser(this.getUser(n).getName());
            this.userTable.remove(n);
            this.updateRoomList();
            if (n2 == this.getCurrentRoomId()) {
                this.repaintRoom();
                this.repaintView();
            }
        }
    }

    public synchronized void removeRoom(int n) {
        this.removeRoom(n, true);
    }

    public synchronized void removeRoom(int n, boolean bl) {
        if (this.getRoom(n) != null && this.getRoom(n).getNrOfUsers() == 0) {
            this.roomTable.remove(n);
            if (bl) {
                this.repaintAll();
                this.fillRoomList();
            }
        }
    }

    public void notifyConnected(boolean bl) {
        this.loginPanel.setConnected(bl);
    }

    public synchronized void removeAllExceptCurrentUser() {
        User user = this.getCurrentUser();
        this.userTable = new IntegerHashtable();
        Enumeration enumeration = this.getRoomIds();
        while (enumeration.hasMoreElements()) {
            this.getRoom((Integer)enumeration.nextElement()).removeAllUsers();
        }
        this.addUser(user);
        this.repaintRoom();
        this.repaintView();
    }

    public synchronized void removeUnknownUser() {
        if (this.getCurrentUserId() != 0) {
            this.removeUser(0);
        }
    }

    public void stopSimulator() {
        int n = 0;
        while (n < ChatRepository.ROBOT_NAME.length) {
            if (this.getUser(1000000 + n) != null) {
                this.removeUser(1000000 + n);
            }
            ++n;
        }
    }

    public synchronized void removeAllExceptDefaultRoom() {
        this.moveUserToRoom(this.currentUserId, 0, false);
        Enumeration enumeration = this.roomTable.elements();
        while (enumeration.hasMoreElements()) {
            Room room = (Room)enumeration.nextElement();
            if (room.getId() == 0) continue;
            this.forceRoomRemoval(room.getId(), false, false);
        }
        this.repaintAll();
        this.fillRoomList();
    }

    public User getUser(int n) {
        Object object = this.userTable.get(n);
        if (object != null) {
            return (User)object;
        }
        return null;
    }

    public void setCurrentUserId(int n) {
        if (this.userTable.containsKey(n)) {
            this.currentUserId = n;
            this.moveUserToRoom(n, this.getUser(n).getRoom(), false);
            this.repaintView();
            this.repaintRoom();
            this.repaintMood();
            this.repaintCurrentUser();
        }
    }

    public int getCurrentUserId() {
        return this.currentUserId;
    }

    public User getCurrentUser() {
        return this.getUser(this.currentUserId);
    }

    public void setCurrentUser(User user) {
        this.addUser(user);
        this.setCurrentUserId(user.getId());
    }

    public IntegerHashtable getAllUsers() {
        return this.userTable;
    }

    public void setUserPosition(int n, Point point, boolean bl) {
        this.setUserPosition(n, point, bl, true);
    }

    public void setUserPosition(int n, Point point, boolean bl, boolean bl2) {
        Room room = this.getCurrentRoom();
        if (room != null) {
            point = new Point(Math.max(Math.min(point.x, room.getSize().width - 2), 2), Math.max(Math.min(point.y, room.getSize().height - 2), 2));
            User user = this.getUser(n);
            if (user != null) {
                boolean bl3 = false;
                if (bl2) {
                    Enumeration enumeration = this.getRoomUserIdVector(this.getCurrentRoomId()).elements();
                    while (enumeration.hasMoreElements() && !bl3) {
                        User user2 = this.getUser((Integer)enumeration.nextElement());
                        if (user2 == null || user2 == user) continue;
                        bl3 = new Rectangle(user2.getPosition().x - 6, user2.getPosition().y - 6, 12, 12).contains(point);
                    }
                }
                if (!bl2 || !bl3) {
                    boolean bl4 = this.inVisualRange(this.getCurrentUser().getId(), user.getId());
                    user.setPosition(point);
                    if (bl4 || this.inVisualRange(this.getCurrentUser().getId(), user.getId()) || user == this.getCurrentUser()) {
                        this.repaintView();
                    }
                    this.repaintRoom();
                    if (n != this.getCurrentUserId() && user.getRoom() == this.getCurrentRoomId()) {
                        this.generateHistoryEntry();
                    }
                }
                if (user == this.getCurrentUser() && bl && this.isConnected()) {
                    this.chatClient.send(new UserPositionEvent(user.getId(), user.getPosition()));
                }
            }
        }
    }

    public void setUserHeading(int n, int n2, boolean bl) {
        User user = this.getUser(n);
        if (user != null) {
            user.setHeading(n2);
            if (user == this.getCurrentUser() || this.inVisualRange(this.getCurrentUser().getId(), user.getId())) {
                this.repaintView();
            }
            this.repaintRoom();
            if (n != this.getCurrentUserId() && user.getRoom() == this.getCurrentRoomId()) {
                this.generateHistoryEntry();
            }
            if (user == this.getCurrentUser() && bl && this.isConnected()) {
                this.chatClient.send(new UserHeadingEvent(user.getId(), user.getHeading()));
            }
        }
    }

    public int getDistance(int n, Point point) {
        return this.getDistance(this.getUser(n).getPosition(), point);
    }

    public int getDistance(Point point, Point point2) {
        return (int)Math.sqrt(Math.pow(point.x - point2.x, 2.0) + Math.pow(point.y - point2.y, 2.0));
    }

    public boolean inVisualRange(int n, Point point) {
        try {
            return this.inVisualRange(this.getUser(n).getPosition(), this.getUser(n).getHeading(), point);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean inVisualRange(Point point, int n, Point point2) {
        int n2 = this.getDistance(point, point2);
        int n3 = this.getAngle(point, point2);
        return n2 <= 240 && ChatUtil.inAngleRange(n3, ChatUtil.subAngle(n, 80), ChatUtil.addAngle(n, 80));
    }

    public boolean inVisualRange(int n, int n2) {
        try {
            User user = this.getUser(n);
            User user2 = this.getUser(n2);
            if (user != user2 && user.getRoom() == user2.getRoom()) {
                return this.inVisualRange(user.getPosition(), user.getHeading(), user2.getPosition());
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public boolean inPhonicalRange(int n, int n2) {
        User user;
        User user2 = this.getUser(n);
        if (user2 != (user = this.getUser(n2)) && user2.getRoom() == user.getRoom()) {
            return this.inPhonicalRange(n, user.getPosition());
        }
        return false;
    }

    public boolean inPhonicalRange(int n, Point point) {
        User user = this.getUser(n);
        int n2 = this.getDistance(n, point);
        int n3 = this.getAngle(n, point);
        return n2 <= 60 && ChatUtil.inAngleRange(n3, ChatUtil.subAngle(user.getHeading(), 60), ChatUtil.addAngle(user.getHeading(), 60));
    }

    public int getAngle(int n, Point point) {
        return ChatUtil.getAngle(this.getUser(n).getPosition(), point);
    }

    public int getAngle(Point point, Point point2) {
        return ChatUtil.getAngle(point, point2);
    }

    public int getAngle(int n, int n2) {
        return ChatUtil.getAngle(this.getUser(n).getPosition(), this.getUser(n2).getPosition());
    }

    public void setUserMessage(int n, String string, boolean bl) {
        User user = this.getUser(n);
        if (user != null && (string != null && string.length() > 0 || user.getMessage() != null && user.getMessage().length() > 0)) {
            user.setMessage(string);
            if (user == this.getCurrentUser()) {
                if (bl && this.isConnected()) {
                    if (this.whisperUserId != -1) {
                        this.chatClient.send(new UserWhisperEvent(user.getId(), string, this.whisperUserId));
                    } else {
                        this.chatClient.send(new UserMessageEvent(user.getId(), string));
                    }
                }
                this.setUserMood(user.getId(), user.getMood(string), bl);
                this.repaintView();
            } else if (this.inVisualRange(this.getCurrentUser().getId(), user.getId())) {
                this.repaintView();
            }
            if (user.getRoom() == this.getCurrentRoomId()) {
                if (this.pnlHistory != null) {
                    this.pnlHistory.addMessageEntry(new Date(), user != this.getCurrentUser() || this.whisperUserId == -1 ? string : "[Whispers] " + string, user.getColor());
                    this.generateHistoryEntry();
                }
                if (this.chatFrame != null) {
                    this.chatFrame.addMessage(user.getName(), user != this.getCurrentUser() || this.whisperUserId == -1 ? string : "[Whispers] " + string);
                }
            }
        }
        if (user == this.getCurrentUser() && this.whisperUserId != -1) {
            this.whisperUserId = -1;
            this.chatFrame.setMessageLabel("Chat:");
        }
    }

    public void setUserMood(int n, int n2, boolean bl) {
        User user = this.getUser(n);
        if (user != null) {
            user.setMood(n2);
            if (user == this.getCurrentUser()) {
                this.chatFrame.repaintMood();
                if (bl && this.isConnected()) {
                    this.chatClient.send(new UserMoodEvent(user.getId(), n2));
                }
                if (user.getMoodTimeout() > 0) {
                    if (this.thrMoodTimeout != null && this.thrMoodTimeout.isAlive()) {
                        this.thrMoodTimeout.stop();
                    }
                    this.thrMoodTimeout = new Thread(this);
                    this.thrMoodTimeout.start();
                }
            } else if (this.inVisualRange(this.getCurrentUser().getId(), user.getId())) {
                this.repaintView();
            }
            if (user.getRoom() == this.getCurrentRoomId()) {
                this.generateHistoryEntry();
            }
        }
    }

    public void updateUser(User user, boolean bl) {
        if (bl) {
            this.chatClient.send(new UserUpdateEvent((User)user.clone(), true));
            return;
        }
        if (!this.isConnected()) {
            if (!user.getBackAvatarURL().equals("")) {
                user.setBackAvatar(this.getImage(user.getBackAvatarURL()));
            } else {
                user.setBackAvatar(null);
            }
            int n = 0;
            while (n < user.getNrOfMoods()) {
                if (!user.getAvatarURL(n).equals("")) {
                    user.setAvatar(n, this.getImage(user.getAvatarURL(n)));
                } else {
                    user.setAvatar(n, null);
                }
                ++n;
            }
        }
        this.addUser(user);
        this.repaintAll();
        if (user.getId() == this.getCurrentUser().getId() && this.chatFrame != null) {
            this.chatFrame.repaintCurrentUser();
        }
    }

    public void updateRoom(Room room, boolean bl) {
        if (bl) {
            if (room.getId() == -1) {
                this.chatClient.send(new RoomCreateEvent(room));
                return;
            }
            this.chatClient.send(new RoomUpdateEvent(room));
            if (room.getId() == 0 && room.isAdministrator(this.getCurrentUser().getName())) {
                room.setInvitedUsers(new Vector());
                room.setKickedUsers(new Vector());
                this.chatFrame.editableRoomPanel.showRoom(room);
                return;
            }
        } else {
            this.addRoom(room);
            if (room.isAdministrator(this.getCurrentUser().getName())) {
                if (this.chatFrame.editableRoomPanel.getRoomId() == room.getId()) {
                    this.chatFrame.editableRoomPanel.showRoom(room);
                }
                if (this.getCurrentRoomId() == -1) {
                    this.moveUserToRoom(this.getCurrentUserId(), room.getId(), this.isConnected());
                    this.removeRoom(-1);
                    this.chatFrame.editableRoomPanel.showRoom(room);
                }
            }
            this.repaintAll();
        }
    }

    public synchronized void forceRoomRemoval(int n, boolean bl) {
        this.forceRoomRemoval(n, bl, true);
    }

    public synchronized void forceRoomRemoval(int n, boolean bl, boolean bl2) {
        Room room = this.getRoom(n);
        if (room != null) {
            Enumeration enumeration = this.getRoomUserIdVector(n).elements();
            while (enumeration.hasMoreElements()) {
                this.moveUserToRoom((Integer)enumeration.nextElement(), 0, bl);
            }
            this.removeRoom(n, bl2);
            if (bl) {
                this.chatClient.send(new RoomRemoveEvent(n));
            }
        }
    }

    public void enterHistoryMode(Date date) {
        this.historyMode = true;
        this.histDate = date;
        this.repaintView();
        this.repaintRoom();
    }

    public void exitHistoryMode() {
        this.historyMode = false;
        this.histDate = null;
        this.repaintView();
        this.repaintRoom();
    }

    public boolean historyMode() {
        return this.historyMode;
    }

    public Date getHistoryDate() {
        return this.histDate;
    }

    public Date getChatStartDate() {
        return this.chatStartDate;
    }

    public void setStatus(String string) {
        this.setStatus(string, false);
    }

    public void setStatus(String string, boolean bl) {
        this.status = string;
        if (this.chatFrame != null) {
            this.chatFrame.setStatus(string);
        }
        if (this.loginPanel != null && bl) {
            this.loginPanel.setStatus(string);
        }
    }

    public String getStatus() {
        return this.status;
    }

    public Image getUserAvatar(int n) {
        return this.getUserAvatar(n, this.getUser(n).getMood());
    }

    public Image getUserAvatar(int n, int n2) {
        Image image = this.getUser(n).getAvatar(n2);
        if (image == null) {
            image = n2 < 6 ? this.defaultAvatar[n2] : this.defaultAvatar[0];
        }
        return image;
    }

    public Image getUserBackAvatar(int n) {
        return this.getUser(n).getBackAvatar();
    }

    public Image getMoodIcon(int n) {
        if (n < 6) {
            return this.moodIcon[n];
        }
        return this.unknownIcon;
    }

    public Image getUnknownIcon() {
        return this.unknownIcon;
    }

    public Image getEmptyIcon() {
        return this.emptyIcon;
    }

    public String getHost() {
        return this.getCodeBase().getHost();
    }

    public int getDefaultPort() {
        try {
            if (this.getParameter("Port") != null) {
                return new Integer(this.getParameter("Port"));
            }
            return 5555;
        }
        catch (NumberFormatException numberFormatException) {
            return 5555;
        }
    }

    public ChatClient getClient() {
        return this.chatClient;
    }

    public void showDocument(URL uRL, String string) {
        this.getAppletContext().showDocument(uRL, string);
    }

    public int getCurrentRoomId() {
        try {
            return this.getCurrentUser().getRoom();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public Room getCurrentRoom() {
        return this.getRoom(this.getCurrentUser().getRoom());
    }

    public void setCurrentRoomId(int n) {
        this.moveUserToRoom(this.getCurrentUserId(), n, this.isConnected());
    }

    public Room getRoom(int n) {
        Object object = this.roomTable.get(n);
        if (object != null) {
            return (Room)object;
        }
        return null;
    }

    public Enumeration getRoomIds() {
        return this.roomTable.keys();
    }

    public Vector getRoomUserIdVector(int n) {
        Vector<Integer> vector = new Vector<Integer>();
        Room room = this.getRoom(n);
        if (room != null) {
            Enumeration enumeration = room.getUserNameVector().elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(new Integer(this.getUserId((String)enumeration.nextElement())));
            }
        }
        return vector;
    }

    public int getUserId(String string) {
        Enumeration enumeration = this.userTable.keys();
        while (enumeration.hasMoreElements()) {
            int n = (Integer)enumeration.nextElement();
            if (!((User)this.userTable.get(n)).getName().equals(string)) continue;
            return n;
        }
        return -1;
    }

    public void moveUserToRoom(int n, int n2, boolean bl) {
        if (this.userTable.containsKey(n) && this.roomTable.containsKey(n2)) {
            User user;
            Room room = this.getRoom(n2);
            if (room.hasAccess((user = this.getUser(n)).getName())) {
                boolean bl2;
                boolean bl3 = user.getRoom() == this.getCurrentRoomId() && n2 != this.getCurrentRoomId();
                boolean bl4 = bl2 = user.getRoom() == this.getCurrentRoomId() || n2 == this.getCurrentRoomId();
                if (this.getRoom(this.getUser(n).getRoom()) != null) {
                    this.getRoom(user.getRoom()).removeUser(user.getName());
                }
                user.setRoom(n2);
                room.addUser(user.getName());
                if (n == this.getCurrentUserId()) {
                    this.setStatus("Joined room \"" + room.getName() + "\"");
                    if (room.isAdministrator(this.getCurrentUser().getName())) {
                        this.chatFrame.editRoom(n2, false);
                    }
                    if (bl3) {
                        this.restartHistory();
                        this.chatFrame.clearMessage();
                    }
                    if (bl) {
                        this.chatClient.send(new UserRoomEvent(n, n2, user.getPosition()));
                    }
                }
                this.repaintView();
                this.repaintRoom();
                this.updateRoomList();
                if (bl2) {
                    this.generateHistoryEntry();
                    return;
                }
            } else if (n == this.getCurrentUserId()) {
                this.setStatus("You do not have access to room \"" + room.getName() + "\"");
            }
        }
    }

    public int getNrOfRooms() {
        return this.roomTable.size();
    }

    public int getRoomId(String string) {
        Enumeration enumeration = this.getRoomIds();
        while (enumeration.hasMoreElements()) {
            int n = (Integer)enumeration.nextElement();
            if (!this.getRoom(n).getName().equals(string)) continue;
            return n;
        }
        return -1;
    }

    public byte[] getResourceFromArchive(String string) {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(string.startsWith("/") ? string : "/" + string);
            if (inputStream == null) {
                return null;
            }
            byte[] byArray = new byte[4096];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
            int n = inputStream.read(byArray);
            while (n != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public Image getImage(String string, boolean bl) {
        Image image;
        byte[] byArray = this.getResourceFromArchive("images/" + string);
        if (byArray != null) {
            image = Toolkit.getDefaultToolkit().createImage(byArray);
        } else {
            image = this.getImage(this.getCodeBase(), "images/" + string);
            if (bl) {
                ChatApplet chatApplet = this;
                synchronized (chatApplet) {
                    if (this.tracker == null) {
                        this.tracker = new MediaTracker(this);
                    }
                    this.tracker.addImage(image, ++this.trackerId);
                    try {
                        this.tracker.waitForID(this.trackerId, 1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        }
        return image;
    }

    public Image getImage(String string) {
        return this.getImage(string, false);
    }

    public void showUser(int n) {
        if (this.chatFrame != null) {
            this.chatFrame.showUser(n);
        }
    }

    public void editUser(int n) {
        if (this.chatFrame != null) {
            this.chatFrame.editUser(n);
        }
    }

    public void whisperToUser(int n) {
        this.whisperUserId = n;
        if (this.chatFrame != null) {
            this.chatFrame.setMessageLabel("Whisper to " + this.getUser(n).getName() + ":");
        }
    }

    public void showRoom(int n) {
        if (this.chatFrame != null) {
            this.chatFrame.showRoom(n);
        }
    }

    public void editRoom(int n) {
        if (this.chatFrame != null) {
            this.chatFrame.editRoom(n);
        }
    }

    public void createRoom() {
        int n = this.isConnected() ? -1 : this.getNrOfRooms();
        Room room = new Room(n, "New Room", ChatRepository.ROOM_DIMENSION);
        if (this.roomExists(room.getName())) {
            int n2 = 1;
            while (this.roomExists(String.valueOf(room.getName()) + n2)) {
                ++n2;
            }
            room.setName(String.valueOf(room.getName()) + n2);
        }
        room.setAdministrator(this.getCurrentUser().getName());
        room.setDemo(!this.isConnected());
        this.addRoom(room);
        this.moveUserToRoom(this.getCurrentUserId(), n, false);
        if (this.chatFrame != null) {
            this.chatFrame.editRoom(n);
        }
        this.updateRoom(room, this.isConnected());
    }

    public void repaintCurrentUser() {
        if (this.chatFrame != null) {
            this.chatFrame.repaintCurrentUser();
        }
    }

    public Room getRoom(String string) {
        return this.getRoom(this.getRoomId(string));
    }

    public boolean roomExists(String string) {
        return this.getRoom(string) != null;
    }

    public boolean isConnected() {
        return this.chatClient != null && this.chatClient.connected();
    }

    public void setHistoryPanel(HistoryPanel historyPanel) {
        this.pnlHistory = historyPanel;
    }

    public Image getSliderImage() {
        return this.imgSlider;
    }

    public void showChat() {
        if (this.chatFrame != null) {
            this.chatFrame.showChat();
        }
    }

    private void generateHistoryEntry() {
        this.hashHistory.put(new Date(), this.getCurrentSituationVector());
    }

    public Vector getCurrentSituationVector() {
        Date date = new Date();
        Vector<HistoryEntry> vector = new Vector<HistoryEntry>();
        Vector vector2 = this.getRoomUserIdVector(this.getCurrentRoomId());
        int n = 0;
        while (n < vector2.size()) {
            User user = this.getUser((Integer)vector2.elementAt(n));
            if (user != null) {
                vector.addElement(new HistoryEntry(date, this.getCurrentRoomId(), user.getId(), user.getPosition(), user.getHeading(), user.getColor(), user.getMessage(), user.getMood()));
            }
            ++n;
        }
        return (Vector)vector.clone();
    }

    public Vector getHistoryEntryVector(Date date) {
        Date date2 = new Date(0L);
        Enumeration enumeration = this.hashHistory.keys();
        while (enumeration.hasMoreElements()) {
            Date date3 = (Date)enumeration.nextElement();
            if (date3.getTime() >= date.getTime() || date3.getTime() <= date2.getTime()) continue;
            date2 = date3;
        }
        Object v = this.hashHistory.get(date2);
        if (v != null) {
            return (Vector)((Vector)v).clone();
        }
        return new Vector();
    }

    public void restartHistory() {
        this.hashHistory = new Hashtable();
        if (this.pnlHistory != null) {
            this.pnlHistory.clear();
        }
    }

    public void run() {
        try {
            try {
                Thread.sleep(this.getCurrentUser().getMoodTimeout() * 1000);
            }
            catch (InterruptedException interruptedException) {
            }
            Object var2_1 = null;
            this.setUserMood(this.getCurrentUserId(), 0, this.isConnected());
            return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.setUserMood(this.getCurrentUserId(), 0, this.isConnected());
            throw throwable;
        }
    }

    public User getRandomUser() {
        Vector vector = this.getRoomUserIdVector(this.getCurrentRoomId());
        return this.getUser((Integer)vector.elementAt((int)((float)vector.size() * this.random.nextFloat())));
    }

    public ImageCanvas getLogo() {
        return (ImageCanvas)this.logoCanvas.clone();
    }

    public Image getDefaultAvatar(int n) {
        if (n >= 0 && n < 6) {
            return this.defaultAvatar[n];
        }
        return null;
    }

    public Image getDefaultBackAvatar() {
        return this.defaultBackAvatar;
    }

    public synchronized void setRoomTable(IntegerHashtable integerHashtable) {
        Room room = (Room)this.roomTable.get(0);
        this.roomTable = integerHashtable;
        this.roomTable.put(0, room);
        if (this.getParameter("Room") != null) {
            int n = this.getRoomId(this.getParameter("Room"));
            if (n != -1) {
                this.moveUserToRoom(this.getCurrentUserId(), n, true);
            }
        } else {
            this.moveUserToRoom(this.getCurrentUserId(), 0, false);
        }
        this.fillRoomList();
        this.repaintAll();
    }

    public class AvatarParam {
        public String name;
        public String[] image = new String[7];

        public AvatarParam() {
            ChatApplet.this = ChatApplet.this;
        }
    }
}

