/*
 * Decompiled with CFR 0.152.
 */
package chat;

import chat.ChatRepository;
import chat.FramedPanel;
import chat.ServerAdministrationRequest;
import chat.ServerDeleteUserRequest;
import chat.ServerGetUserDataRequest;
import chat.ServerStopRequest;
import chat.ServerUpdateUserDataRequest;
import chat.ServerUserListRequest;
import chat.SortedStringVector;
import chat.User;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;

public class ServerAdministrationApplet
extends Applet
implements Runnable,
ActionListener,
ItemListener {
    private Thread clientThread;
    private Socket clientSocket;
    private ObjectOutputStream output;
    private ObjectInputStream input;
    private Button connectButton;
    private Button disconnectButton;
    private Button stopButton;
    private Button deleteUserButton;
    private Button updateUserButton;
    private Button getUserListButton;
    private TextField keyField;
    private TextField portField;
    private Label keyLabel;
    private String host;
    private boolean connected;
    private FramedPanel connectionPanel;
    private FramedPanel userPanel;
    private Choice userListChoice;
    private TextField passwordField;
    private TextField emailField;

    public void init() {
        this.connectionPanel = new FramedPanel("Connection", this.getInsets());
        this.userPanel = new FramedPanel("User", this.getInsets());
        this.setBackground(Color.lightGray);
        this.connectionPanel.setLayout(new GridBagLayout());
        ServerAdministrationApplet.addWithBeginningConstraints(this.connectionPanel, new Label("Server-Key:", 2), this.getInsets());
        this.keyField = new TextField(20);
        ServerAdministrationApplet.addWithRemainingConstraints(this.connectionPanel, this.keyField, this.getInsets());
        ServerAdministrationApplet.addWithBeginningConstraints(this.connectionPanel, new Label("Port:", 2), this.getInsets());
        this.portField = new TextField(5);
        ServerAdministrationApplet.addWithRemainingConstraints(this.connectionPanel, this.portField, this.getInsets());
        this.keyField.setEchoChar('*');
        this.connectButton = new Button("Connect");
        this.getUserListButton = new Button("Get User List");
        this.disconnectButton = new Button("Disconnect");
        this.stopButton = new Button("Stop Server");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = this.getInsets();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        ServerAdministrationApplet.addWithConstraints(this.connectionPanel, this.connectButton, gridBagConstraints);
        ServerAdministrationApplet.addWithConstraints(this.connectionPanel, this.getUserListButton, gridBagConstraints);
        ServerAdministrationApplet.addWithConstraints(this.connectionPanel, this.stopButton, gridBagConstraints);
        ServerAdministrationApplet.addWithConstraints(this.connectionPanel, this.disconnectButton, gridBagConstraints);
        this.userPanel.setLayout(new GridBagLayout());
        ServerAdministrationApplet.addWithBeginningConstraints(this.userPanel, new Label("User:", 2), this.getInsets());
        this.userListChoice = new Choice();
        ServerAdministrationApplet.addWithRemainingConstraints(this.userPanel, this.userListChoice, this.getInsets());
        ServerAdministrationApplet.addWithBeginningConstraints(this.userPanel, new Label("Password:", 2), this.getInsets());
        this.passwordField = new TextField();
        ServerAdministrationApplet.addWithRemainingConstraints(this.userPanel, this.passwordField, this.getInsets());
        ServerAdministrationApplet.addWithBeginningConstraints(this.userPanel, new Label("E-Mail:", 2), this.getInsets());
        this.emailField = new TextField();
        ServerAdministrationApplet.addWithRemainingConstraints(this.userPanel, this.emailField, this.getInsets());
        this.updateUserButton = new Button("Update User");
        ServerAdministrationApplet.addWithConstraints(this.userPanel, this.updateUserButton, gridBagConstraints);
        this.deleteUserButton = new Button("Delete User");
        ServerAdministrationApplet.addWithConstraints(this.userPanel, this.deleteUserButton, gridBagConstraints);
        this.setLayout(new BorderLayout());
        this.add((Component)this.connectionPanel, "North");
        this.add((Component)this.userPanel, "Center");
        this.connectButton.addActionListener(this);
        this.getUserListButton.addActionListener(this);
        this.disconnectButton.addActionListener(this);
        this.stopButton.addActionListener(this);
        this.userListChoice.addItemListener(this);
        this.updateUserButton.addActionListener(this);
        this.deleteUserButton.addActionListener(this);
        this.host = this.getCodeBase().getHost();
        ((TextComponent)this.portField).setText(this.getParameter("Port"));
        this.disconnect();
    }

    public static void addWithConstraints(Container container, Component component, GridBagConstraints gridBagConstraints) {
        if (!(container.getLayout() instanceof GridBagLayout)) {
            container.setLayout(new GridBagLayout());
        }
        ((GridBagLayout)container.getLayout()).setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    public static void addWithBeginningConstraints(Container container, Component component, Insets insets) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(insets.top / 2, insets.left / 2, insets.bottom / 2, insets.right / 2);
        gridBagConstraints.fill = 1;
        ServerAdministrationApplet.addWithConstraints(container, component, gridBagConstraints);
    }

    public static void addWithBeginningConstraints(Container container, Component component) {
        ServerAdministrationApplet.addWithBeginningConstraints(container, component, ChatRepository.INSETS);
    }

    public static void addWithRemainingConstraints(Container container, Component component, Insets insets) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(insets.top / 2, insets.left / 2, insets.bottom / 2, insets.right / 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        ServerAdministrationApplet.addWithConstraints(container, component, gridBagConstraints);
    }

    public static void addWithRemainingConstraints(Container container, Component component) {
        ServerAdministrationApplet.addWithRemainingConstraints(container, component, ChatRepository.INSETS);
    }

    public void disconnect() {
        try {
            this.connected = false;
            if (this.clientSocket != null) {
                this.clientSocket.close();
            }
            if (this.output != null) {
                this.output.close();
            }
            if (this.input != null) {
                this.input.close();
            }
            this.connectButton.setEnabled(true);
            this.getUserListButton.setEnabled(false);
            this.disconnectButton.setEnabled(false);
            this.stopButton.setEnabled(false);
            this.userPanel.setEnabled(false);
            System.out.println("Disconnected");
            return;
        }
        catch (IOException iOException) {
            System.out.println("Exception while disconnecting: " + iOException);
            return;
        }
    }

    public void connect() {
        try {
            System.out.println("Connecting...");
            this.clientSocket = new Socket(this.host, (int)new Integer(this.portField.getText()));
            this.input = new ObjectInputStream(this.clientSocket.getInputStream());
            this.output = new ObjectOutputStream(this.clientSocket.getOutputStream());
            this.clientThread = new Thread(this);
            this.clientThread.start();
            this.connected = true;
            this.connectButton.setEnabled(false);
            this.getUserListButton.setEnabled(true);
            this.disconnectButton.setEnabled(true);
            this.stopButton.setEnabled(true);
            System.out.println("Connected");
            return;
        }
        catch (IOException iOException) {
            System.out.println("Exception while connecting: " + iOException);
            return;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.stopButton) {
            this.send(new ServerStopRequest(this.keyField.getText()));
            return;
        }
        if (actionEvent.getSource() == this.getUserListButton) {
            this.send(new ServerUserListRequest(this.keyField.getText()));
            return;
        }
        if (actionEvent.getSource() == this.updateUserButton) {
            User user = new User(this.userListChoice.getSelectedItem(), this.passwordField.getText());
            user.setEmail(this.emailField.getText());
            this.send(new ServerUpdateUserDataRequest(this.keyField.getText(), user));
            return;
        }
        if (actionEvent.getSource() == this.deleteUserButton) {
            this.send(new ServerDeleteUserRequest(this.keyField.getText(), this.userListChoice.getSelectedItem()));
            return;
        }
        if (actionEvent.getSource() == this.connectButton) {
            this.connect();
            return;
        }
        if (actionEvent.getSource() == this.disconnectButton) {
            this.disconnect();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.userListChoice) {
            this.send(new ServerGetUserDataRequest(this.keyField.getText(), this.userListChoice.getSelectedItem()));
        }
    }

    public void run() {
        while (this.connected) {
            try {
                Object object = this.input.readObject();
                if (!(object instanceof ServerAdministrationRequest)) continue;
                switch (((ServerAdministrationRequest)object).status) {
                    case 1: {
                        System.out.println(String.valueOf(object) + " has been accepted");
                        break;
                    }
                    case 2: {
                        System.out.println(String.valueOf(object) + " has been denied");
                        break;
                    }
                    case 3: {
                        System.out.println("An error occured while handling " + object);
                        break;
                    }
                    case 0: {
                        System.out.println(String.valueOf(object) + " has not been processed");
                        break;
                    }
                }
                if (((ServerAdministrationRequest)object).status != 1) continue;
                if (object instanceof ServerUserListRequest) {
                    SortedStringVector sortedStringVector = ((ServerUserListRequest)object).userListVector;
                    this.userListChoice.removeAll();
                    int n = 0;
                    while (n < sortedStringVector.size()) {
                        this.userListChoice.add(sortedStringVector.elementAt(n));
                        ++n;
                    }
                    if (this.userListChoice.getItemCount() > 0) {
                        this.userListChoice.select(0);
                        this.send(new ServerGetUserDataRequest(this.keyField.getText(), this.userListChoice.getItem(0)));
                    }
                    this.userPanel.setEnabled(true);
                    continue;
                }
                if (object instanceof ServerGetUserDataRequest) {
                    User user = ((ServerGetUserDataRequest)object).user;
                    this.userListChoice.select(user.getName());
                    ((TextComponent)this.passwordField).setText(user.getPassword());
                    ((TextComponent)this.emailField).setText(user.getEmail());
                    continue;
                }
                if (!(object instanceof ServerDeleteUserRequest)) continue;
                this.send(new ServerUserListRequest(this.keyField.getText()));
            }
            catch (Exception exception) {
                System.out.println("Exception while receiving data: " + exception + ". Going offline...");
                this.disconnect();
            }
        }
    }

    public void send(Object object) {
        try {
            if (this.connected) {
                System.out.println("Sending: " + object);
                this.output.writeObject(object);
                return;
            }
        }
        catch (IOException iOException) {
            System.out.println("Exception while sending data: " + iOException + ". Going offline...");
            this.disconnect();
        }
    }

    public void stop() {
        this.disconnect();
    }

    public Insets getInsets() {
        return new Insets(10, 10, 10, 10);
    }
}

