/*
 * Decompiled with CFR 0.152.
 */
package chat;

import chat.ChatServer;
import chat.ChatUtil;
import chat.Connection;
import chat.User;
import chat.UserUpdateEvent;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class UserUpdateThread
extends Thread {
    private ChatServer server;
    private Connection connection;
    private UserUpdateEvent updateEvent;
    private User oldUser;
    private int overallAvatarSize;

    public UserUpdateThread(UserUpdateEvent userUpdateEvent, ChatServer chatServer, Connection connection) {
        this.server = chatServer;
        this.connection = connection;
        this.updateEvent = userUpdateEvent;
        this.oldUser = this.server.loadUser(this.updateEvent.user.getName());
    }

    public void run() {
        if (this.oldUser == null) {
            return;
        }
        String string = this.updateEvent.user.getPassword();
        if (string != null && string.length() > 0) {
            if (!string.equals(this.oldUser.getPassword())) {
                this.server.log("Wrong password");
                return;
            }
        } else {
            this.updateEvent.user.setPassword(this.oldUser.getPassword());
        }
        this.server.log("Updating user avatars...");
        this.overallAvatarSize = 0;
        this.updateAvatar(-1, this.updateEvent.user.getBackAvatarURL());
        int n = 0;
        while (n < this.updateEvent.user.getNrOfMoods()) {
            this.updateAvatar(n, this.updateEvent.user.getAvatarURL(n));
            ++n;
        }
        this.updateEvent.done = true;
        if (this.updateEvent.statusString == null || this.updateEvent.statusString.equals("")) {
            this.updateEvent.statusString = "User Update successful";
        }
        this.server.handleUserEvent(this.updateEvent, this.connection);
    }

    private void updateAvatar(int n, String string) {
        if (string != null && string.length() > 0 && !string.equals(n == -1 ? this.oldUser.getBackAvatarURL() : this.oldUser.getAvatarURL(n))) {
            boolean bl = false;
            if (string.startsWith("http://")) {
                try {
                    bl = this.updateAvatarImpl(n, new URL(string));
                }
                catch (MalformedURLException malformedURLException) {
                    this.reportAvatarUpdateFailure(n, "Invalid URL: " + string);
                }
            } else {
                bl = this.updateAvatarImpl(n, new File(String.valueOf(this.server.getImageFolder()) + string));
            }
            if (!bl) {
                this.resetAvatar(n);
                return;
            }
        } else {
            if (string == null || string.length() == 0) {
                if (n == -1) {
                    this.updateEvent.user.setBackAvatarURL("");
                    this.updateEvent.user.setBackAvatar(null);
                    return;
                }
                this.updateEvent.user.setAvatarURL(n, "");
                this.updateEvent.user.setAvatar(n, null);
                return;
            }
            this.resetAvatar(n);
        }
    }

    private void resetAvatar(int n) {
        if (n == -1) {
            this.updateEvent.user.setBackAvatarURL(this.oldUser.getBackAvatarURL());
            this.updateEvent.user.setBackAvatar(this.oldUser.getBackAvatar());
            return;
        }
        this.updateEvent.user.setAvatarURL(n, this.oldUser.getNrOfMoods() > n ? this.oldUser.getAvatarURL(n) : "");
        this.updateEvent.user.setAvatar(n, this.oldUser.getNrOfMoods() > n ? this.oldUser.getAvatar(n) : null);
    }

    private void setAvatar(int n, Image image) {
        if (n == -1) {
            this.updateEvent.user.setBackAvatar(image);
            return;
        }
        this.updateEvent.user.setAvatar(n, image);
    }

    private boolean checkAvatarSize(int n, String string, long l) {
        if (l > 50000L) {
            this.reportAvatarUpdateFailure(n, "Avatar " + string + " exceeds maximum size");
            return false;
        }
        if ((long)this.overallAvatarSize + l > 100000L) {
            this.reportAvatarUpdateFailure(n, "With avatar " + string + " the overall user-file size exceeds maximum file length");
            return false;
        }
        return true;
    }

    private boolean updateAvatarImpl(int n, URL uRL) {
        this.server.log("Updating avatar to " + uRL);
        try {
            URLConnection uRLConnection = uRL.openConnection();
            long l = uRLConnection.getContentLength();
            String string = uRLConnection.getHeaderField("content-type");
            if (string != null) {
                string = string.toLowerCase();
            }
            if (string == null || string.indexOf("html") != -1 || uRLConnection.getHeaderField(0).indexOf("404") != -1) {
                this.reportAvatarUpdateFailure(n, "Avatar " + uRL + " doesn't exist on the web");
                return false;
            }
            if (string.indexOf("gif") == -1 && string.indexOf("jpg") == -1 && string.indexOf("jpeg") == -1) {
                this.reportAvatarUpdateFailure(n, "Avatar " + uRL + " has wrong format, only GIFs and JPEGs supported");
                return false;
            }
            if (this.checkAvatarSize(n, uRL.toString(), uRLConnection.getContentLength())) {
                this.setAvatar(n, ChatUtil.getImage(uRL));
                this.overallAvatarSize = (int)((long)this.overallAvatarSize + l);
                return true;
            }
        }
        catch (IOException iOException) {
            this.reportAvatarUpdateFailure(n, "Avatar " + uRL + " doesn't exist on the web");
        }
        return false;
    }

    private boolean updateAvatarImpl(int n, File file) {
        this.server.log("Updating avatar to " + file);
        if (!file.exists()) {
            this.reportAvatarUpdateFailure(n, "Avatar " + file + " doesn't exist on the server");
            return false;
        }
        if (!this.checkAvatarSize(n, file.toString(), file.length())) {
            return false;
        }
        this.setAvatar(n, ChatUtil.getImage(file.getPath()));
        this.overallAvatarSize = (int)((long)this.overallAvatarSize + file.length());
        return true;
    }

    private void reportAvatarUpdateFailure(int n, String string) {
        this.server.log(string);
        this.updateEvent.statusString = string;
        this.resetAvatar(n);
    }
}

