/*
 * Decompiled with CFR 0.152.
 */
package chat;

import chat.ChatApplet;
import chat.ChatRepository;
import chat.ChatUtil;
import chat.FramedPanel;
import chat.Room;
import chat.XList;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.util.Enumeration;
import java.util.Vector;

public class RoomPanel
extends Panel {
    protected ChatApplet chatApplet;
    protected Panel userAccessPanel;
    protected FramedPanel namePanel;
    protected FramedPanel accessPanel;
    protected FramedPanel userListPanel;
    protected TextField nameField;
    protected TextField administratorField;
    protected TextField usersOnlineField;
    protected TextArea infoArea;
    protected TextArea rulesArea;
    protected Checkbox privateAccessCheckbox;
    protected Checkbox publicAccessCheckbox;
    protected CheckboxGroup accessCheckboxGroup;
    protected XList userList;
    protected Vector invitedUserVector;
    protected Vector kickedUserVector;
    private int roomId;

    public RoomPanel(ChatApplet chatApplet) {
        int[] nArray = new int[]{160};
        String[] stringArray = new String[]{"User"};
        this.chatApplet = chatApplet;
        this.invitedUserVector = new Vector();
        this.kickedUserVector = new Vector();
        this.namePanel = new FramedPanel("Room", ChatRepository.INSETS);
        this.namePanel.setLayout(new GridBagLayout());
        ChatUtil.addWithBeginningConstraints(this.namePanel, new Label("Name:", 2));
        this.nameField = new TextField();
        ChatUtil.addWithRemainingConstraints(this.namePanel, this.nameField);
        ChatUtil.addWithBeginningConstraints(this.namePanel, new Label("Users online:", 2));
        this.usersOnlineField = new TextField();
        ChatUtil.addWithRemainingConstraints(this.namePanel, this.usersOnlineField);
        ChatUtil.addWithBeginningConstraints(this.namePanel, new Label("Administrator:", 2));
        this.administratorField = new TextField();
        ChatUtil.addWithRemainingConstraints(this.namePanel, this.administratorField);
        ChatUtil.addWithRemainingConstraints(this.namePanel, new Label("Info:", 0));
        this.infoArea = new TextArea("", 3, 80, 3);
        ChatUtil.addWithRemainingConstraints(this.namePanel, this.infoArea);
        ChatUtil.addWithRemainingConstraints(this.namePanel, new Label("Rules:", 0));
        this.rulesArea = new TextArea("", 5, 80, 3);
        ChatUtil.addWithRemainingConstraints(this.namePanel, this.rulesArea);
        this.administratorField.setEditable(false);
        this.usersOnlineField.setEditable(false);
        this.accessPanel = new FramedPanel("Access", ChatRepository.INSETS);
        this.accessPanel.setLayout(new GridBagLayout());
        this.accessCheckboxGroup = new CheckboxGroup();
        this.publicAccessCheckbox = new Checkbox("Public", this.accessCheckboxGroup, true);
        this.privateAccessCheckbox = new Checkbox("Private", this.accessCheckboxGroup, true);
        ChatUtil.addWithRemainingConstraints(this.accessPanel, this.publicAccessCheckbox);
        ChatUtil.addWithRemainingConstraints(this.accessPanel, this.privateAccessCheckbox);
        this.userListPanel = new FramedPanel("", ChatRepository.INSETS);
        this.userListPanel.setLayout(new BorderLayout());
        this.userList = new XList(1);
        this.userListPanel.add((Component)this.userList, "Center");
        this.userList.setColumnWidths(nArray);
        this.userList.setColumnHeaders(stringArray);
        this.userList.setSorted(true);
        this.userList.setSelectable(false);
        this.userAccessPanel = new Panel();
        this.userAccessPanel.setLayout(new GridLayout(3, 1));
        this.userAccessPanel.add(this.accessPanel);
        this.userAccessPanel.add(this.userListPanel);
        this.userAccessPanel.add(this.userListPanel);
        this.setLayout(new BorderLayout());
        ((Component)this).setFont(ChatRepository.STANDARD_FONT);
        this.add((Component)this.namePanel, "Center");
        this.add((Component)this.userAccessPanel, "East");
    }

    public void toggleUserPanel(boolean bl) {
        this.userListPanel.setTitle(bl ? "Inivited Users" : "Kicked Users");
        this.updateUserList(bl ? this.invitedUserVector : this.kickedUserVector);
    }

    public void updateUserList(Vector vector) {
        Enumeration enumeration = vector.elements();
        this.userList.clear();
        while (enumeration.hasMoreElements()) {
            String[] stringArray = new String[]{(String)enumeration.nextElement()};
            this.userList.addRow(stringArray);
        }
    }

    public void showRoom(Room room) {
        this.setRoomId(room.getId());
        ((TextComponent)this.nameField).setText(room.getName());
        ((TextComponent)this.usersOnlineField).setText(new Integer(room.getNrOfUsers()).toString());
        this.publicAccessCheckbox.setState(!room.isPrivate());
        this.privateAccessCheckbox.setState(room.isPrivate());
        ((TextComponent)this.administratorField).setText(room.getAdministrator());
        this.infoArea.setText(room.getInfo());
        this.rulesArea.setText(room.getRules());
        this.invitedUserVector = room.getInvitedUsers();
        this.kickedUserVector = room.getKickedUsers();
        this.toggleUserPanel(room.isPrivate());
    }

    private void setRoomId(int n) {
        this.roomId = n;
    }

    public int getRoomId() {
        return this.roomId;
    }
}

