/*
 * Decompiled with CFR 0.152.
 */
package chat;

import chat.ChatApplet;
import chat.ChatRepository;
import chat.InsetsPanel;
import chat.Room;
import chat.XList;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;

public class RoomListPanel
extends InsetsPanel
implements ActionListener {
    private ChatApplet chatApplet;
    private XList roomList;
    private InsetsPanel buttonPanel;
    private Button jumpButton;
    private Button createButton;
    private String[] headings = new String[]{"Room", "Users"};
    private int[] widths = new int[]{110, 45};
    private int[] orientations = new int[]{2, 1};

    public RoomListPanel(ChatApplet chatApplet) {
        super(ChatRepository.INSETS);
        this.chatApplet = chatApplet;
        ((Component)this).setFont(ChatRepository.SMALL_FONT);
        this.roomList = new XList(2);
        this.roomList.setColumnHeaders(this.headings);
        this.roomList.setColumnWidths(this.widths);
        this.roomList.setColumnOrientations(this.orientations);
        this.roomList.setSelectable(true);
        this.roomList.setSorted(true);
        this.jumpButton = new Button("Join");
        this.jumpButton.setEnabled(this.chatApplet.getBooleanParam("RoomJoining", true));
        this.createButton = new Button("Create");
        this.createButton.setEnabled(this.chatApplet.getBooleanParam("RoomCreation", true));
        this.buttonPanel = new InsetsPanel(ChatRepository.INSETS);
        this.buttonPanel.setLayout(new GridLayout(1, 2, 10, 10));
        this.buttonPanel.add(this.jumpButton);
        this.buttonPanel.add(this.createButton);
        this.setLayout(new BorderLayout());
        this.add((Component)this.roomList, "Center");
        this.add((Component)this.buttonPanel, "South");
        ((Component)this).setFont(ChatRepository.STANDARD_FONT);
        this.jumpButton.addActionListener(this);
        this.createButton.addActionListener(this);
        this.fillRoomList();
    }

    public synchronized void fillRoomList() {
        this.roomList.clear();
        Enumeration enumeration = this.chatApplet.getRoomIds();
        String[] stringArray = new String[2];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            int n2;
            Room room;
            Integer n3 = (Integer)enumeration.nextElement();
            if (n3 != null && (room = this.chatApplet.getRoom(n2 = n3.intValue())) != null) {
                stringArray[0] = room.getName();
                stringArray[1] = new Integer(room.getNrOfUsers()).toString();
                this.roomList.addRow(stringArray, n2, new Color(0, 160, 0));
            }
            ++n;
        }
        this.updateRoomList();
    }

    public synchronized void updateRoomList() {
        String[] stringArray = new String[2];
        int n = 0;
        while (n < this.roomList.getNrOfRows()) {
            int n2 = this.roomList.getKey(n);
            Room room = this.chatApplet.getRoom(n2);
            if (room != null) {
                this.roomList.setCellText(n, 1, new Integer(room.getNrOfUsers()).toString());
                if (room.getId() == this.chatApplet.getCurrentRoomId()) {
                    this.roomList.setRowColor(n, new Color(0, 0, 160));
                } else if (!room.hasAccess(this.chatApplet.getCurrentUser().getName())) {
                    this.roomList.setRowColor(n, new Color(160, 0, 0));
                } else {
                    this.roomList.setRowColor(n, new Color(0, 160, 0));
                }
            }
            ++n;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.jumpButton && this.chatApplet.getCurrentRoomId() != this.roomList.getKey(this.roomList.getSelectedRow())) {
            this.chatApplet.moveUserToRoom(this.chatApplet.getCurrentUserId(), this.roomList.getKey(this.roomList.getSelectedRow()), true);
            return;
        }
        if (actionEvent.getSource() == this.createButton) {
            this.chatApplet.createRoom();
        }
    }
}

