/*
 * Decompiled with CFR 0.152.
 */
package chat;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;

public class PortraitCanvas
extends Canvas {
    Image image;
    double portraitScale = 1.0;
    boolean drawFrame;
    Color frameColor;

    public PortraitCanvas(Image image) {
        this.image = image;
        this.drawFrame = false;
        this.frameColor = Color.black;
    }

    public PortraitCanvas() {
        this((Image)null);
    }

    public void setImage(Image image) {
        this.image = image;
        this.repaint();
    }

    public void setScale(double d) {
        this.portraitScale = d;
    }

    public void setDrawFrame(boolean bl) {
        this.drawFrame = bl;
        this.repaint();
    }

    public void setFrameColor(Color color) {
        this.frameColor = color;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        if (this.image != null) {
            Rectangle rectangle = this.getImageRectangle();
            graphics.drawImage(this.image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
            if (this.drawFrame) {
                graphics.setColor(this.frameColor);
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
                graphics.drawRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 3, rectangle.height - 3);
            }
        }
    }

    public Rectangle getImageRectangle() {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        if (this.image != null) {
            double d = (float)n / (float)this.getSize().height / ((float)this.image.getWidth(this) / (float)this.image.getHeight(this));
            Rectangle rectangle = new Rectangle();
            if (d > 1.0) {
                rectangle.x = (int)((double)n * (1.0 - this.portraitScale / d) / 2.0);
                rectangle.y = (int)((double)n2 * (1.0 - this.portraitScale) / 2.0);
                rectangle.width = (int)((double)n * this.portraitScale / d);
                rectangle.height = (int)((double)n2 * this.portraitScale);
            } else {
                rectangle.x = (int)((double)n * (1.0 - this.portraitScale) / 2.0);
                rectangle.y = (int)((double)n2 * (1.0 - this.portraitScale * d) / 2.0);
                rectangle.width = (int)((double)n * this.portraitScale);
                rectangle.height = (int)((double)n2 * this.portraitScale * d);
            }
            return rectangle;
        }
        return new Rectangle();
    }
}

