/*
 * Decompiled with CFR 0.152.
 */
package chat;

import chat.Light;
import chat.Orientation;
import chat.Plane3D;
import chat.Vertex3D;
import java.awt.Color;
import java.awt.Graphics;

public class Polygon3D {
    private static final int MAX_NR_OF_POINTS = 32;
    public int[] scrX = new int[32];
    public int[] scrY = new int[32];
    protected Vertex3D[] ver = new Vertex3D[32];
    public Vertex3D normVec = new Vertex3D();
    protected double lightProperty;
    public Color col;
    protected double maxZ;
    private int nrOfPoints;

    public Polygon3D() {
        this.col = Color.black;
    }

    public Polygon3D(Polygon3D polygon3D) {
        int n = 0;
        while (n < this.scrX.length) {
            this.scrX[n] = polygon3D.scrX[n];
            this.scrY[n] = polygon3D.scrY[n];
            if (polygon3D.ver[n] != null) {
                this.ver[n] = new Vertex3D(polygon3D.ver[n]);
            }
            ++n;
        }
        this.normVec = new Vertex3D(polygon3D.normVec);
        this.lightProperty = polygon3D.lightProperty;
        this.nrOfPoints = polygon3D.getNrOfPoints();
        this.col = new Color(polygon3D.col.getRed(), polygon3D.col.getGreen(), polygon3D.col.getBlue());
        this.maxZ = polygon3D.maxZ;
    }

    public Polygon3D doClone() {
        return new Polygon3D(this);
    }

    public void addPoint(Vertex3D vertex3D) {
        this.ver[this.nrOfPoints++] = new Vertex3D(vertex3D);
    }

    private void setNrOfPoints(int n) {
        this.nrOfPoints = n;
    }

    public int getNrOfPoints() {
        return this.nrOfPoints;
    }

    public void setLight(Light light) {
        this.lightProperty = Math.max(0.75, light.pos.dotProduct(this.normVec) / light.len);
    }

    public boolean clipBack(Plane3D plane3D) {
        int n = 0;
        int n2 = 0;
        Vertex3D vertex3D = new Vertex3D();
        Polygon3D polygon3D = this.doClone();
        boolean bl = false;
        double d = this.ver[n].dotProduct(plane3D.normVec);
        boolean bl2 = d >= plane3D.dist;
        while (n < this.nrOfPoints) {
            double d2;
            boolean bl3;
            if (bl2) {
                polygon3D.ver[n2++] = new Vertex3D(this.ver[n % this.nrOfPoints]);
                bl = true;
            }
            boolean bl4 = bl3 = (d2 = this.ver[++n % this.nrOfPoints].dotProduct(plane3D.normVec)) >= plane3D.dist;
            if (bl3 != bl2) {
                double d3 = (plane3D.dist - d) / (d2 - d);
                vertex3D.x = this.ver[n - 1].x + d3 * (this.ver[n % this.nrOfPoints].x - this.ver[n - 1].x);
                vertex3D.y = this.ver[n - 1].y + d3 * (this.ver[n % this.nrOfPoints].y - this.ver[n - 1].y);
                vertex3D.z = this.ver[n - 1].z + d3 * (this.ver[n % this.nrOfPoints].z - this.ver[n - 1].z);
                polygon3D.ver[n2++] = new Vertex3D(vertex3D);
                bl = true;
            }
            bl2 = bl3;
            d = d2;
        }
        polygon3D.setNrOfPoints(n2);
        int n3 = 0;
        while (n3 < polygon3D.getNrOfPoints()) {
            this.scrX[n3] = polygon3D.scrX[n3];
            this.scrY[n3] = polygon3D.scrY[n3];
            if (n3 < polygon3D.getNrOfPoints()) {
                this.ver[n3] = new Vertex3D(polygon3D.ver[n3]);
            }
            ++n3;
        }
        this.normVec = polygon3D.normVec;
        this.lightProperty = polygon3D.lightProperty;
        this.nrOfPoints = polygon3D.getNrOfPoints();
        this.col = new Color(polygon3D.col.getRed(), polygon3D.col.getGreen(), polygon3D.col.getBlue());
        this.maxZ = polygon3D.maxZ;
        return bl;
    }

    public void rotate(int n, int n2, int n3) {
        this.rotate(new Orientation(n, n2, n3));
    }

    public void rotate(Orientation orientation) {
        int n = 0;
        while (n < this.nrOfPoints) {
            this.ver[n].rotate(orientation);
            ++n;
        }
        this.normVec.rotate(orientation);
    }

    public void translate(Vertex3D vertex3D) {
        int n = 0;
        while (n < this.nrOfPoints) {
            this.ver[n].x += vertex3D.x;
            this.ver[n].y += vertex3D.y;
            this.ver[n].z += vertex3D.z;
            ++n;
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(new Color((int)(this.lightProperty * (double)this.col.getRed()), (int)(this.lightProperty * (double)this.col.getGreen()), (int)(this.lightProperty * (double)this.col.getBlue())));
        graphics.fillPolygon(this.scrX, this.scrY, this.nrOfPoints);
    }
}

