/*
 * Decompiled with CFR 0.152.
 */
package chat;

import chat.Light;
import chat.Orientation;
import chat.Plane3D;
import chat.Polygon3D;
import chat.Vertex3D;
import java.awt.Graphics;
import java.util.Vector;

public class Object3D {
    private Vector poly = new Vector(100, 100);

    public Object3D() {
    }

    public Object3D(Object3D object3D) {
        this();
        this.add(object3D);
    }

    public Object3D(Polygon3D polygon3D) {
        this();
        this.add(polygon3D);
    }

    public Polygon3D getPolygon(int n) {
        return (Polygon3D)this.poly.elementAt(n);
    }

    public int getNrOfPolygons() {
        return this.poly.size();
    }

    public void add(Polygon3D polygon3D) {
        this.poly.addElement(polygon3D);
    }

    public void remove(Polygon3D polygon3D) {
        this.poly.removeElement(polygon3D);
    }

    public void add(Object3D object3D) {
        int n = 0;
        while (n < object3D.getNrOfPolygons()) {
            this.add(object3D.getPolygon(n).doClone());
            ++n;
        }
    }

    public boolean contains(Polygon3D polygon3D) {
        return this.poly.contains(polygon3D);
    }

    public void rotate(int n, int n2, int n3) {
        this.rotate(new Orientation(n, n2, n3));
    }

    public void rotate(Orientation orientation) {
        int n = 0;
        while (n < this.getNrOfPolygons()) {
            this.getPolygon(n).rotate(orientation);
            ++n;
        }
    }

    public void translate(Vertex3D vertex3D) {
        int n = 0;
        while (n < this.getNrOfPolygons()) {
            this.getPolygon(n).translate(vertex3D);
            ++n;
        }
    }

    public synchronized void orderByDepth() {
        Vector<Polygon3D> vector = new Vector<Polygon3D>(this.getNrOfPolygons());
        int n = 0;
        while (n < this.getNrOfPolygons()) {
            int n2;
            int n3 = n2 = vector.size() / 2;
            boolean bl = false;
            while (!bl) {
                if (n3 - (n2 = Math.max(1, n2 / 2)) >= 0 && this.getPolygon((int)n).maxZ > ((Polygon3D)vector.elementAt((int)(n3 - 1))).maxZ) {
                    n3 -= n2;
                    continue;
                }
                if (n3 + n2 <= vector.size() && this.getPolygon((int)n).maxZ < ((Polygon3D)vector.elementAt((int)n3)).maxZ) {
                    n3 += n2;
                    continue;
                }
                bl = true;
            }
            vector.insertElementAt(this.getPolygon(n), n3);
            ++n;
        }
        this.poly = vector;
    }

    public void bringToScreen(int n, int n2, Light light, boolean bl) {
        int n3 = n / 2;
        int n4 = n2 / 2;
        int n5 = 0;
        while (n5 < this.getNrOfPolygons()) {
            double d = 0.0;
            int n6 = 0;
            while (n6 < this.getPolygon(n5).getNrOfPoints()) {
                double d2 = this.getPolygon((int)n5).ver[n6].z;
                d = Math.max(d, d2);
                this.getPolygon((int)n5).scrX[n6] = (int)((double)n3 + (double)n3 * this.getPolygon((int)n5).ver[n6].x / d2);
                this.getPolygon((int)n5).scrY[n6] = (int)((double)n4 - (double)n3 * this.getPolygon((int)n5).ver[n6].y / d2);
                if (bl) {
                    this.getPolygon((int)n5).scrX[n6] = n - this.getPolygon((int)n5).scrX[n6];
                }
                ++n6;
            }
            this.getPolygon((int)n5).maxZ = d;
            this.getPolygon(n5).setLight(light);
            ++n5;
        }
    }

    public Object3D clip(Plane3D plane3D) {
        Object3D object3D = new Object3D();
        int n = 0;
        while (n < this.getNrOfPolygons()) {
            boolean bl = false;
            boolean bl2 = true;
            if (this.getPolygon((int)n).ver[0].dotProduct(this.getPolygon((int)n).normVec) > 0.0) {
                bl2 = false;
            } else {
                int n2 = 0;
                while (n2 < this.getPolygon(n).getNrOfPoints() && !bl) {
                    bl = this.getPolygon((int)n).ver[n2].z <= 2.0 || this.getPolygon((int)n).ver[n2].z <= Math.abs(this.getPolygon((int)n).ver[n2].x) || this.getPolygon((int)n).ver[n2].z <= Math.abs(this.getPolygon((int)n).ver[n2].y);
                    ++n2;
                }
                if (bl) {
                    bl2 = this.getPolygon(n).clipBack(plane3D);
                }
            }
            if (bl2) {
                object3D.add(this.getPolygon(n));
            }
            ++n;
        }
        return object3D;
    }

    public void paint(Graphics graphics) {
        int n = 0;
        while (n < this.getNrOfPolygons()) {
            this.getPolygon(n).paint(graphics);
            ++n;
        }
    }
}

