/*
 * Decompiled with CFR 0.152.
 */
package chat;

import chat.ChatApplet;
import chat.ChatMath;
import chat.ChatRepository;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class NavigationCanvas
extends Canvas
implements MouseListener,
MouseMotionListener,
Runnable {
    private Image imgForward;
    private Image imgBackward;
    private Image imgLeft;
    private Image imgRight;
    private Rectangle rectForward;
    private Rectangle rectBackward;
    private Rectangle rectLeft;
    private Rectangle rectRight;
    private ChatApplet chatApplet;
    private Thread mouseListenerThread;
    private static final int PROLONGATION_DELAY = 100;
    private static final int INITIAL_PROLONGATION_DELAY = 250;
    private static final int MOTION_NONE = -1;
    private static final int MOTION_FORWARD = 0;
    private static final int MOTION_LEFT = 1;
    private static final int MOTION_RIGHT = 2;
    private static final int MOTION_BACKWARD = 3;
    private int motion = -1;
    private int prevMotion = -1;

    public NavigationCanvas(ChatApplet chatApplet, Image image, Image image2, Image image3, Image image4) {
        this.chatApplet = chatApplet;
        this.imgForward = image;
        this.imgBackward = image2;
        this.imgLeft = image3;
        this.imgRight = image4;
        this.updateRectangles();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.mouseListenerThread = new Thread(this);
    }

    public Dimension getPreferredSize() {
        return this.getCalculatedSize();
    }

    public Dimension getMinimumSize() {
        return this.getCalculatedSize();
    }

    private Dimension getCalculatedSize() {
        return new Dimension(20 + ChatRepository.NAVIGATION_ARROW_DIMENSION.width * 3, 20 + ChatRepository.NAVIGATION_ARROW_DIMENSION.height * 3);
    }

    private void updateRectangles() {
        this.rectForward = new Rectangle((this.getSize().width - this.imgForward.getWidth(this)) / 2, this.getSize().height / 2 - ChatRepository.NAVIGATION_ARROW_DIMENSION.height * 3 / 2, this.imgForward.getWidth(this), this.imgForward.getHeight(this));
        this.rectLeft = new Rectangle(this.getSize().width / 2 - ChatRepository.NAVIGATION_ARROW_DIMENSION.width * 3 / 2, (this.getSize().height - this.imgLeft.getHeight(this)) / 2, this.imgLeft.getWidth(this), this.imgLeft.getHeight(this));
        this.rectRight = new Rectangle(this.getSize().width / 2 + ChatRepository.NAVIGATION_ARROW_DIMENSION.width / 2, (this.getSize().height - this.imgRight.getHeight(this)) / 2, this.imgRight.getWidth(this), this.imgRight.getHeight(this));
        this.rectBackward = new Rectangle((this.getSize().width - this.imgBackward.getWidth(this)) / 2, this.getSize().height / 2 + ChatRepository.NAVIGATION_ARROW_DIMENSION.height / 2, this.imgBackward.getWidth(this), this.imgBackward.getHeight(this));
    }

    public void paint(Graphics graphics) {
        this.updateRectangles();
        graphics.drawImage(this.imgForward, this.rectForward.x, this.rectForward.y, this);
        graphics.drawImage(this.imgLeft, this.rectLeft.x, this.rectLeft.y, this);
        graphics.drawImage(this.imgRight, this.rectRight.x, this.rectRight.y, this);
        graphics.drawImage(this.imgBackward, this.rectBackward.x, this.rectBackward.y, this);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        NavigationCanvas navigationCanvas = this;
        synchronized (navigationCanvas) {
            if (this.motion == -1) {
                this.setMotion(mouseEvent);
                this.motion();
                this.motion = -1;
                this.repaint();
            }
            return;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        NavigationCanvas navigationCanvas = this;
        synchronized (navigationCanvas) {
            this.prevMotion = this.motion;
            this.motion = -1;
            this.repaint();
            return;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        NavigationCanvas navigationCanvas = this;
        synchronized (navigationCanvas) {
            this.setMotion(mouseEvent);
            this.motion();
            if (!this.mouseListenerThread.isAlive()) {
                this.mouseListenerThread.start();
            }
            return;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        NavigationCanvas navigationCanvas = this;
        synchronized (navigationCanvas) {
            this.prevMotion = this.motion;
            this.motion = -1;
            this.repaint();
            return;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        NavigationCanvas navigationCanvas = this;
        synchronized (navigationCanvas) {
            this.mousePressed(mouseEvent);
            return;
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private void setMotion(MouseEvent mouseEvent) {
        this.prevMotion = this.motion;
        if (this.rectBackward != null && this.rectBackward.contains(mouseEvent.getPoint())) {
            this.motion = 3;
            return;
        }
        if (this.rectForward != null && this.rectForward.contains(mouseEvent.getPoint())) {
            this.motion = 0;
            return;
        }
        if (this.rectLeft != null && this.rectLeft.contains(mouseEvent.getPoint())) {
            this.motion = 1;
            return;
        }
        if (this.rectRight != null && this.rectRight.contains(mouseEvent.getPoint())) {
            this.motion = 2;
            return;
        }
        this.motion = -1;
    }

    public void motion() {
        NavigationCanvas navigationCanvas = this;
        synchronized (navigationCanvas) {
            Point point = this.chatApplet.getCurrentUser().getPosition();
            int n = this.chatApplet.getCurrentUser().getHeading();
            int n2 = this.chatApplet.getCurrentUser().getId();
            if (this.motion == 3) {
                if (this.prevMotion != this.motion) {
                    this.getGraphics().drawImage(this.imgBackward, this.rectBackward.x + 1, this.rectBackward.y + 1, this);
                }
                this.chatApplet.setUserPosition(n2, new Point(point.x - (int)(ChatMath.getCos(n) * 4.0), point.y + (int)(ChatMath.getSin(n) * 4.0)), true);
            } else if (this.motion == 0) {
                if (this.prevMotion != this.motion) {
                    this.getGraphics().drawImage(this.imgForward, this.rectForward.x + 1, this.rectForward.y + 1, this);
                }
                this.chatApplet.setUserPosition(n2, new Point(point.x + (int)(ChatMath.getCos(n) * 4.0), point.y - (int)(ChatMath.getSin(n) * 4.0)), true);
            } else if (this.motion == 1) {
                if (this.prevMotion != this.motion) {
                    this.getGraphics().drawImage(this.imgLeft, this.rectLeft.x + 1, this.rectLeft.y + 1, this);
                }
                this.chatApplet.setUserHeading(n2, n + 4, true);
            } else if (this.motion == 2) {
                if (this.prevMotion != this.motion) {
                    this.getGraphics().drawImage(this.imgRight, this.rectRight.x + 1, this.rectRight.y + 1, this);
                }
                this.chatApplet.setUserHeading(n2, n - 4, true);
            }
            return;
        }
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(this.motion == -1 ? 250 : 100);
            }
            catch (InterruptedException interruptedException) {}
            NavigationCanvas navigationCanvas = this;
            synchronized (navigationCanvas) {
                if (this.motion != -1) {
                    this.motion();
                }
            }
        }
    }
}

