/*
 * Decompiled with CFR 0.152.
 */
package chat;

import chat.ChatApplet;
import chat.ChatMath;
import chat.ChatRepository;
import chat.ChatUtil;
import chat.PortraitCanvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class MoodCanvas
extends PortraitCanvas
implements MouseListener,
MouseMotionListener,
ActionListener {
    private static final double PORTRAIT_SCALE = 0.6;
    private ChatApplet chatApplet;
    private Image bufferImage;
    private PopupMenu moodPopup;

    public MoodCanvas(ChatApplet chatApplet) {
        this.portraitScale = 0.6;
        this.chatApplet = chatApplet;
        this.moodPopup = new PopupMenu();
        this.add(this.moodPopup);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.moodPopup.addActionListener(this);
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void paint(Graphics graphics) {
        this.moodPopup.removeAll();
        int n = 0;
        while (n < this.chatApplet.getCurrentUser().getNrOfMoods()) {
            this.moodPopup.add(this.chatApplet.getCurrentUser().getMoodName(n));
            ++n;
        }
        int n2 = this.getSize().width;
        int n3 = this.getSize().height;
        if (this.bufferImage == null || this.bufferImage.getWidth(this) != n2 || this.bufferImage.getHeight(this) != n3) {
            this.bufferImage = this.createImage(n2, n3);
        }
        Graphics graphics2 = this.bufferImage.getGraphics();
        graphics2.setColor(this.getBackground());
        graphics2.fillRect(0, 0, n2, n3);
        this.setImage(this.chatApplet.getUserAvatar(this.chatApplet.getCurrentUserId()));
        super.paint(graphics2);
        graphics2.setColor(Color.darkGray);
        graphics2.drawOval(ChatRepository.ICON_DIMENSION.width / 2, ChatRepository.ICON_DIMENSION.height / 2, n2 - ChatRepository.ICON_DIMENSION.width, n3 - ChatRepository.ICON_DIMENSION.height);
        graphics2.setColor(Color.black);
        int n4 = 0;
        while (n4 < this.chatApplet.getCurrentUser().getNrOfMoods()) {
            double d = n4 * 360 / this.chatApplet.getCurrentUser().getNrOfMoods();
            int n5 = (int)((double)(n2 / 2) + ChatMath.getSin(d) * (double)(n2 / 2 - ChatRepository.ICON_DIMENSION.width / 2)) - ChatRepository.ICON_DIMENSION.width / 2;
            int n6 = (int)((double)(n3 / 2) + ChatMath.getCos(d) * (double)(n3 / 2 - ChatRepository.ICON_DIMENSION.height / 2) - (double)(ChatRepository.ICON_DIMENSION.height / 2));
            graphics2.drawImage(this.chatApplet.getMoodIcon(n4), n5, n6, this);
            if (n4 == this.chatApplet.getCurrentUser().getMood()) {
                graphics2.drawOval(n5, n6, ChatRepository.ICON_DIMENSION.width - 1, ChatRepository.ICON_DIMENSION.height - 1);
                graphics2.drawOval(n5 + 1, n6 + 1, ChatRepository.ICON_DIMENSION.width - 3, ChatRepository.ICON_DIMENSION.height - 3);
            }
            ++n4;
        }
        graphics.drawImage(this.bufferImage, 0, 0, this);
    }

    public int getMood(Point point) {
        return ChatUtil.addAngle(ChatUtil.getAngle(new Point(this.getSize().width / 2, this.getSize().height / 2), point), 90 + 360 / this.chatApplet.getCurrentUser().getNrOfMoods() / 2) * this.chatApplet.getCurrentUser().getNrOfMoods() / 360;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!mouseEvent.isMetaDown() && this.getMood(mouseEvent.getPoint()) != this.chatApplet.getCurrentUser().getMood()) {
            this.chatApplet.setUserMood(this.chatApplet.getCurrentUser().getId(), this.getMood(mouseEvent.getPoint()), true);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isMetaDown()) {
            this.moodPopup.show(this, mouseEvent.getX(), mouseEvent.getY());
            return;
        }
        if (this.getMood(mouseEvent.getPoint()) != this.chatApplet.getCurrentUser().getMood()) {
            this.chatApplet.setUserMood(this.chatApplet.getCurrentUser().getId(), this.getMood(mouseEvent.getPoint()), true);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!mouseEvent.isMetaDown() && this.getMood(mouseEvent.getPoint()) != this.chatApplet.getCurrentUser().getMood()) {
            this.chatApplet.setUserMood(this.chatApplet.getCurrentUser().getId(), this.getMood(mouseEvent.getPoint()), true);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.moodPopup) {
            int n = 0;
            while (n < this.moodPopup.getItemCount()) {
                if (this.moodPopup.getItem(n).getLabel().equals(actionEvent.getActionCommand())) {
                    this.chatApplet.setUserMood(this.chatApplet.getCurrentUserId(), n, this.chatApplet.isConnected());
                }
                ++n;
            }
        }
    }
}

