/*
 * Decompiled with CFR 0.152.
 */
package chat;

import chat.Balloon;
import chat.ChatRepository;
import chat.ChatUtil;
import chat.Polygon3D;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;

public class Image3D {
    private Polygon3D poly;
    private Image image;
    private String label;
    private String text;
    private Color col;

    public Image3D(Polygon3D polygon3D, Image image, String string, String string2, Color color) {
        this.poly = polygon3D;
        this.image = image;
        this.label = string;
        this.text = string2;
        this.col = color;
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle;
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        int n5 = 0;
        while (n5 < this.poly.getNrOfPoints()) {
            n = Math.min(n, this.poly.scrX[n5]);
            n2 = Math.max(n2, this.poly.scrX[n5]);
            n3 = Math.min(n3, this.poly.scrY[n5]);
            n4 = Math.max(n4, this.poly.scrY[n5]);
            ++n5;
        }
        if (this.image != null && this.image.getWidth(null) > 0 && this.image.getHeight(null) > 0) {
            rectangle = new Rectangle(n, n3, this.image.getWidth(null) * (n4 - n3) / this.image.getHeight(null), n4 - n3);
            graphics.drawImage(this.image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
        } else {
            rectangle = new Rectangle(n, n3, (n4 - n3) / 2, n4 - n3);
            ChatUtil.paintPattern(graphics, rectangle, Color.black);
        }
        graphics.setFont(ChatRepository.STANDARD_FONT);
        graphics.setColor(this.col);
        graphics.drawString(this.label, n, n4 + ChatRepository.STANDARD_FONT.getSize());
        if (this.text != null && this.text.length() > 0) {
            int n6 = rectangle.height;
            int n7 = ChatRepository.BALLOON_DIMENSION.width * n6 / ChatRepository.BALLOON_DIMENSION.height;
            new Balloon(new Rectangle(rectangle.x - n7 - 10, rectangle.y - n6 / 2, n7, n6), this.text, new Font(ChatRepository.STANDARD_FONT.getName(), ChatRepository.STANDARD_FONT.getStyle(), 8 + n7 / ChatRepository.BALLOON_DIMENSION.width * 4), this.col, 0).paint(graphics);
        }
    }
}

