/*
 * Decompiled with CFR 0.152.
 */
package chat;

import chat.ChatApplet;
import chat.ChatRepository;
import chat.FramedPanel;
import chat.MessageEntry;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;

public class HistoryPanel
extends FramedPanel
implements Runnable,
MouseListener,
MouseMotionListener {
    private Image imgBuffer;
    private Image imgSlider;
    private Vector vecMessageEntry;
    private ChatApplet chatAdm;
    private Date dateFrom;
    private Date dateTo;
    private Date dateHist;
    private Thread thrUpdate;
    private int iMaxMessageLength;

    public HistoryPanel(String string, ChatApplet chatApplet) {
        super(string, ChatRepository.INSETS);
        this.chatAdm = chatApplet;
        this.imgSlider = this.chatAdm.getSliderImage();
        this.clear();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.thrUpdate = new Thread(this);
        this.thrUpdate.setPriority(1);
        this.thrUpdate.start();
    }

    public void addMessageEntry(Date date, String string, Color color) {
        this.vecMessageEntry.addElement(new MessageEntry(date, string, color));
        this.iMaxMessageLength = Math.max(this.iMaxMessageLength, string.length());
    }

    public void setFromDate(Date date) {
        this.vecMessageEntry = new Vector();
        this.iMaxMessageLength = 1;
        this.dateFrom = date;
        this.dateHist = date;
        this.setToDate(new Date(date.getTime() + 1000L));
        this.repaint();
    }

    public void setToDate(Date date) {
        this.dateTo = date;
        this.repaint();
    }

    private void enterHistoryMode(Date date) {
        this.dateHist = date;
        this.chatAdm.enterHistoryMode(this.dateHist);
        this.repaint();
    }

    public long getFromTime() {
        return this.dateFrom.getTime();
    }

    public long getToTime() {
        return this.dateTo.getTime();
    }

    public int getBarTop() {
        return 10 + ChatRepository.MESSAGE_DOT_DIMENSION.height;
    }

    public int getBarBottom() {
        return 10 + ChatRepository.MESSAGE_DOT_DIMENSION.height + this.imgSlider.getHeight(this);
    }

    public int getBarLeft() {
        return 5;
    }

    public int getBarRight() {
        return this.getSize().width - 5;
    }

    public int getSliderX(long l) {
        try {
            return (int)((long)this.getBarLeft() + (long)(this.getBarRight() - this.getBarLeft()) * (l - this.getFromTime()) / (this.getToTime() - this.getFromTime()) - (long)(this.imgSlider.getWidth(this) / 2));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getSliderX(Date date) {
        return this.getSliderX(date.getTime());
    }

    public int getDotX(long l) {
        return (int)((long)this.getBarLeft() + (long)(this.getBarRight() - this.getBarLeft()) * (l - this.getFromTime()) / (this.getToTime() - this.getFromTime()) - (long)(ChatRepository.MESSAGE_DOT_DIMENSION.width / 2));
    }

    public int getDotX(Date date) {
        return this.getDotX(date.getTime());
    }

    public long getSliderTime() {
        return this.dateHist.getTime();
    }

    public Date getSliderDate() {
        return this.dateHist;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        if (this.imgBuffer == null || this.imgBuffer.getWidth(this) != n || this.imgBuffer.getHeight(this) != n2) {
            this.imgBuffer = this.createImage(n, n2);
        }
        Graphics graphics2 = this.imgBuffer.getGraphics();
        graphics2.setColor(ChatRepository.CONTAINER_BACKGROUND);
        graphics2.fillRect(0, 0, n, n2);
        graphics2.setColor(Color.black);
        graphics2.drawLine(this.getBarLeft(), (this.getBarTop() + this.getBarBottom()) / 2, this.getBarRight(), (this.getBarTop() + this.getBarBottom()) / 2);
        graphics2.drawLine(this.getBarLeft(), (this.getBarTop() + this.getBarBottom()) / 2 + 1, this.getBarRight(), (this.getBarTop() + this.getBarBottom()) / 2 + 1);
        graphics2.drawLine(this.getBarLeft(), (this.getBarTop() + this.getBarBottom()) / 2 - 2, this.getBarLeft(), (this.getBarTop() + this.getBarBottom()) / 2 + 3);
        graphics2.drawLine(this.getBarLeft() + 1, (this.getBarTop() + this.getBarBottom()) / 2 - 2, this.getBarLeft() + 1, (this.getBarTop() + this.getBarBottom()) / 2 + 3);
        graphics2.drawLine(this.getBarRight(), (this.getBarTop() + this.getBarBottom()) / 2 - 2, this.getBarRight(), (this.getBarTop() + this.getBarBottom()) / 2 + 3);
        graphics2.drawLine(this.getBarRight() - 1, (this.getBarTop() + this.getBarBottom()) / 2 - 2, this.getBarRight() - 1, (this.getBarTop() + this.getBarBottom()) / 2 + 3);
        graphics2.drawString(DateFormat.getTimeInstance().format(this.dateFrom), this.getBarLeft(), this.getBarBottom() + 5);
        graphics2.drawString(DateFormat.getTimeInstance().format(this.dateTo), this.getBarRight() - this.getFontMetrics(this.getFont()).stringWidth(DateFormat.getTimeInstance().format(this.dateFrom)), this.getBarBottom() + 5);
        graphics2.drawImage(this.imgSlider, this.getSliderX(this.dateHist), this.getBarTop(), this);
        int n3 = 0;
        while (n3 < this.vecMessageEntry.size()) {
            MessageEntry messageEntry = (MessageEntry)this.vecMessageEntry.elementAt(n3);
            int n4 = 1 + (ChatRepository.MESSAGE_DOT_DIMENSION.height - 1) * messageEntry.text.length() / this.iMaxMessageLength;
            graphics2.setColor(messageEntry.color);
            graphics2.fillRect(this.getDotX(messageEntry.date) - ChatRepository.MESSAGE_DOT_DIMENSION.width / 2, 5 + ChatRepository.MESSAGE_DOT_DIMENSION.height - n4, ChatRepository.MESSAGE_DOT_DIMENSION.width, n4);
            ++n3;
        }
        graphics.drawImage(this.imgBuffer, 0, 0, this);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.getX() > this.getBarLeft() && mouseEvent.getX() < this.getBarRight()) {
            this.enterHistoryMode(new Date(this.getFromTime() + (this.getToTime() - this.getFromTime()) * (long)(mouseEvent.getX() - this.getBarLeft()) / (long)(this.getBarRight() - this.getBarLeft())));
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(1000L);
                    if (this.chatAdm.historyMode()) continue;
                    this.setToDate(new Date());
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    public void clear() {
        this.iMaxMessageLength = 1;
        this.vecMessageEntry = new Vector();
        this.setFromDate(new Date());
    }
}

