/*
 * Decompiled with CFR 0.152.
 */
package chat;

import chat.ChatServer;
import chat.UserLogoutEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;

public class Connection
extends Thread {
    private Object closeLock = new Object();
    private Socket clientSocket;
    private ChatServer server;
    private ObjectOutputStream output;
    private ObjectInputStream input;
    private boolean connected;
    private boolean disconnecting;
    private int userId;
    private SenderThread sender;

    public Connection(ChatServer chatServer, Socket socket) {
        this.server = chatServer;
        this.clientSocket = socket;
        this.userId = 0;
        this.disconnecting = false;
    }

    private ChatServer getServer() {
        return this.server;
    }

    public String getIPAddress() {
        if (this.connected) {
            return this.clientSocket.getInetAddress().getHostAddress();
        }
        return new String("");
    }

    public void run() {
        this.sender = new SenderThread(this);
        this.sender.start();
        try {
            this.output = new ObjectOutputStream(this.clientSocket.getOutputStream());
            this.input = new ObjectInputStream(this.clientSocket.getInputStream());
            this.connected = true;
        }
        catch (IOException iOException) {
            this.server.log("IOException while opening connection: " + iOException);
        }
        while (this.connected) {
            try {
                Object object;
                ObjectInputStream objectInputStream = this.input;
                synchronized (objectInputStream) {
                    object = this.input.readObject();
                }
                this.server.handleUserEvent(object, this);
            }
            catch (Exception exception) {
                if (!this.connected || this.disconnecting) continue;
                this.disconnecting = true;
                this.server.handleUserEvent(new UserLogoutEvent(this.userId), this);
                this.close();
            }
        }
    }

    public void send(Object object) {
        this.sender.send(object);
    }

    private void sendInternal(Object object) {
        block6: {
            if (this.connected) {
                try {
                    ObjectOutputStream objectOutputStream = this.output;
                    synchronized (objectOutputStream) {
                        this.output.writeObject(object);
                        return;
                    }
                }
                catch (Exception exception) {
                    if (!this.connected || this.disconnecting) break block6;
                    this.disconnecting = true;
                    this.server.handleUserEvent(new UserLogoutEvent(this.userId), this);
                    this.close();
                    return;
                }
            }
        }
    }

    public void close() {
        if (!this.connected) {
            return;
        }
        new Thread(new 1()).start();
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int n) {
        this.userId = n;
    }

    public Socket getSocket() {
        return this.clientSocket;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean bl) {
        this.connected = bl;
    }

    public static class SenderThread
    extends Thread {
        private Object spinLock = new Object();
        private ChatServer.LinkedList pendingEvents;
        public Connection conn;
        private boolean stopped = false;

        public SenderThread(Connection connection) {
            this.conn = connection;
            this.pendingEvents = new ChatServer.LinkedList(this.conn.getServer());
        }

        public void run() {
            while (!this.stopped) {
                Object object = this.spinLock;
                synchronized (object) {
                    if (this.pendingEvents.isEmpty()) {
                        try {
                            this.spinLock.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (this.stopped || this.pendingEvents.isEmpty()) continue;
                object = this.pendingEvents.popFront();
                this.conn.sendInternal(object);
            }
        }

        public void send(Object object) {
            this.pendingEvents.pushBack(object);
            Object object2 = this.spinLock;
            synchronized (object2) {
                this.spinLock.notify();
                return;
            }
        }

        public void terminate() {
            this.stopped = true;
            Object object = this.spinLock;
            synchronized (object) {
                this.spinLock.notify();
                return;
            }
        }
    }

    private final class 1
    implements Runnable {
        public void run() {
            Object object = Connection.this.closeLock;
            synchronized (object) {
                if (Connection.this.connected) {
                    Connection.this.connected = false;
                    try {
                        Connection.this.sender.terminate();
                        if (Connection.this.output != null) {
                            Connection.this.output.close();
                        }
                        if (Connection.this.input != null) {
                            Connection.this.input.close();
                        }
                        if (Connection.this.clientSocket != null) {
                            Connection.this.clientSocket.close();
                        }
                    }
                    catch (Exception exception) {
                        Connection.this.server.log("Exception while closing connection");
                    }
                }
                return;
            }
        }

        /* synthetic */ 1() {
        }
    }
}

