/*
 * Decompiled with CFR 0.152.
 */
package chat;

import chat.ChatRepository;
import chat.ChatUtil;
import chat.Connection;
import chat.ExistingUserLoginRequest;
import chat.IntegerHashtable;
import chat.NewUserLoginRequest;
import chat.Room;
import chat.RoomCreateEvent;
import chat.RoomEvent;
import chat.RoomListEvent;
import chat.RoomRemoveEvent;
import chat.RoomUpdateEvent;
import chat.ServerAdministrationRequest;
import chat.ServerDeleteUserRequest;
import chat.ServerGetUserDataRequest;
import chat.ServerStopRequest;
import chat.ServerUpdateUserDataRequest;
import chat.ServerUserListRequest;
import chat.SortedStringVector;
import chat.User;
import chat.UserEvent;
import chat.UserHeadingEvent;
import chat.UserLoginEvent;
import chat.UserLoginRequest;
import chat.UserLogoutEvent;
import chat.UserMessageEvent;
import chat.UserMoodEvent;
import chat.UserPositionEvent;
import chat.UserRoomEvent;
import chat.UserUpdateEvent;
import chat.UserUpdateThread;
import chat.UserWhisperEvent;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;

public class ChatServer
implements Runnable {
    private WorkerThread worker;
    private static final String STORAGE_FOLDER = "users/";
    private static final String IMAGE_FOLDER = "images/";
    private static final String ROOM_FOLDER = "rooms/";
    private static final String ROOM_FILENAME = "rooms";
    private static final String KEY = "Admin";
    private static final String BANNED_IP_FILENAME = "banned_ip";
    public static final int LOGLEVEL0 = 0;
    public static final int LOGLEVEL1 = 1;
    public static final int LOGLEVEL2 = 2;
    public static final int LOGLEVEL3 = 3;
    public static final int DEFAULT_LOGLEVEL = 1;
    public static final int STANDARD_LOGLEVEL = 1;
    public static final int DELAY = 10000;
    public static final int ROOM_EXPIRATION = 2;
    private ServerSocket listener;
    private Vector connectionVector;
    private Vector bannedIPs;
    private Thread serverThread;
    private IntegerHashtable onlineTable;
    private IntegerHashtable roomTable;
    private String key;
    private String storageFolder;
    private String imageFolder;
    private String roomFolder;
    private String roomFilename;
    private int logLevel;
    private Random rand = new Random();
    private Object loginLogoutLock = new Object();

    public static void main(String[] stringArray) {
        int n;
        try {
            n = stringArray.length >= 1 ? new Integer(stringArray[0]) : 5555;
        }
        catch (NumberFormatException numberFormatException) {
            n = 5555;
        }
        if (stringArray.length >= 1 && (stringArray[0].indexOf("?") != -1 || stringArray[0].toLowerCase().indexOf("help") != -1)) {
            System.out.println("Visual Chat Server");
            System.out.println("Usage: java [-DVCHAT_USERLIST=filename] chat.ChatServer [ port [ serverkey [ storagefolder [ imagefolder [ roomfolder [ roomfilename [ loglevel ] ] ] ] ] ] ]");
            System.out.println("Hint: Store banned ip-addresses in a file named \"banned_ip\"");
            return;
        }
        new ChatServer(n, stringArray.length >= 2 ? stringArray[1] : KEY, stringArray.length >= 3 ? stringArray[2] : STORAGE_FOLDER, stringArray.length >= 4 ? stringArray[3] : IMAGE_FOLDER, stringArray.length >= 5 ? stringArray[4] : ROOM_FOLDER, stringArray.length >= 6 ? stringArray[5] : ROOM_FILENAME, stringArray.length >= 7 ? ChatUtil.getInt(stringArray[6]) : 1);
    }

    public ChatServer(int n, String string, String string2, String string3, String string4, String string5, int n2) {
        this.key = string;
        this.storageFolder = String.valueOf(string2) + (string2.endsWith("/") ? "" : "/");
        this.imageFolder = String.valueOf(string3) + (string3.endsWith("/") ? "" : "/");
        this.roomFolder = String.valueOf(string4) + (string4.endsWith("/") ? "" : "/");
        this.roomFilename = string5;
        this.logLevel = n2;
        try {
            Object object;
            Object object2;
            Object object3;
            new File(this.storageFolder).mkdirs();
            new File(this.imageFolder).mkdirs();
            new File(this.roomFolder).mkdirs();
            this.listener = new ServerSocket(n);
            this.connectionVector = new Vector();
            this.onlineTable = new IntegerHashtable();
            if (!this.exists(KEY)) {
                this.saveUser(new User(KEY, string));
                this.log("Created admin user...");
            }
            if (new File(String.valueOf(this.roomFolder) + this.roomFilename).exists()) {
                try {
                    this.roomTable = (IntegerHashtable)this.load(String.valueOf(this.roomFolder) + this.roomFilename);
                    object3 = new Vector();
                    object2 = new GregorianCalendar();
                    ((GregorianCalendar)object2).add(5, -2);
                    Enumeration enumeration = this.roomTable.elements();
                    while (enumeration.hasMoreElements()) {
                        object = (Room)enumeration.nextElement();
                        if (((Room)object).getId() == 0 || !((Room)object).getLastAccess().before(object2)) continue;
                        ((Vector)object3).addElement(object);
                    }
                    object = ((Vector)object3).elements();
                    while (object.hasMoreElements()) {
                        Room room = (Room)object.nextElement();
                        this.roomTable.remove(room.getId());
                    }
                    this.saveRooms();
                }
                catch (Exception exception) {
                    this.log(exception.toString());
                    this.createStandardRooms();
                }
            } else {
                this.createStandardRooms();
            }
            try {
                this.roomTable = (IntegerHashtable)this.load(String.valueOf(this.roomFolder) + this.roomFilename);
            }
            catch (Exception exception) {
                this.log(exception.toString());
                this.createStandardRooms();
            }
            this.bannedIPs = new Vector();
            try {
                char c;
                object3 = new StringBuffer(1024);
                object = new BufferedInputStream(new FileInputStream(new File(BANNED_IP_FILENAME)));
                while ((c = (char)((BufferedInputStream)object).read()) != '\uffff') {
                    ((StringBuffer)object3).append(c);
                }
                ((FilterInputStream)object).close();
                object2 = new StringTokenizer(((StringBuffer)object3).toString(), System.getProperty("line.separator"));
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    this.bannedIPs.addElement(((StringTokenizer)object2).nextToken().trim());
                }
            }
            catch (Exception exception) {
                this.log(exception.toString());
            }
            object3 = new Thread(new 1());
            ((Thread)object3).start();
            this.log("Listening on port " + n + "...");
            this.log("Storage folder is " + this.storageFolder + "...");
            this.log("Image folder is " + this.imageFolder + "...");
            this.log("Room folder is " + this.roomFolder + "...");
            this.log("Room filename is " + this.roomFilename + "...");
            this.log("Log level is " + this.logLevel + "...");
            this.log("Nr of banned ip-addresses read from banned_ip: " + this.bannedIPs.size());
            this.worker = new WorkerThread(this);
            this.serverThread = new Thread(this);
            this.serverThread.start();
            this.log("ChatServer up and running...");
        }
        catch (IOException iOException) {
            this.log("IOException while starting ChatServer: " + iOException);
        }
        this.saveUserList();
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Connection connection = new Connection(this, this.listener.accept());
                    connection.start();
                    this.log("Opened connection to " + connection.getSocket().getInetAddress());
                }
            }
            catch (Exception exception) {
                this.log("Exception while opening a new connection: " + exception);
                continue;
            }
            catch (Error error) {
                this.log("Error while opening a new connection: " + error);
                continue;
            }
            break;
        }
    }

    private Room createDeepCopy(Room room) {
        Room room2 = new Room(room.getId(), new String(room.getName()), new Dimension(room.getSize().width, room.getSize().height));
        room2.setAdministrator(new String(room.getAdministrator()));
        room2.setInfo(new String(room.getInfo()));
        room2.setRules(new String(room.getRules()));
        room2.setPrivate(room.isPrivate());
        room2.setLastAccess(new GregorianCalendar());
        int n = 0;
        while (n < room.getUserNameVector().size()) {
            room2.addUser(new String((String)room.getUserNameVector().elementAt(n)));
            ++n;
        }
        int n2 = 0;
        while (n2 < room.getInvitedUsers().size()) {
            room2.inviteUser(new String((String)room.getInvitedUsers().elementAt(n2)));
            ++n2;
        }
        int n3 = 0;
        while (n3 < room.getKickedUsers().size()) {
            room2.kickUser(new String((String)room.getKickedUsers().elementAt(n3)));
            ++n3;
        }
        return room2;
    }

    public boolean isBannedIP(String string) {
        int n = 0;
        while (n < this.bannedIPs.size()) {
            if (string.startsWith((String)this.bannedIPs.elementAt(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void handleUserEvent(Object object, Connection connection) {
        this.worker.handleEvent(object, connection);
    }

    private void handleUserEventInternal(Object object, Connection connection) {
        Room room = null;
        if (object instanceof UserLoginRequest) {
            if (this.isBannedIP(connection.getIPAddress())) {
                ((UserLoginRequest)object).status = 2;
                ((UserLoginRequest)object).statusString = "IP-Address has been banned";
                this.log("Login for new user " + ((UserLoginRequest)object).user.getName() + " denied: Banned IP-Address");
                this.send(object, connection);
                return;
            }
            if (object instanceof ExistingUserLoginRequest) {
                boolean bl;
                ExistingUserLoginRequest existingUserLoginRequest = (ExistingUserLoginRequest)object;
                this.log("Login for user " + existingUserLoginRequest.user.getName() + " received");
                User user = this.loadUser(existingUserLoginRequest.user.getName());
                boolean bl2 = user != null;
                boolean bl3 = bl = user != null && user.getPassword().equals(existingUserLoginRequest.user.getPassword());
                if (!bl2 || !bl) {
                    existingUserLoginRequest.status = 2;
                    if (!bl2) {
                        existingUserLoginRequest.statusString = "User does not exist. Correct name or login as new user";
                        this.log("Login for user " + existingUserLoginRequest.user.getName() + " denied: User does not exist");
                    } else if (!bl) {
                        existingUserLoginRequest.statusString = "Wrong password. Correct password or create new user";
                        this.log("Login for user " + existingUserLoginRequest.user.getName() + " denied: Wrong password");
                    }
                    this.send(existingUserLoginRequest, connection);
                    return;
                }
                this.log("Login for user " + existingUserLoginRequest.user.getName() + " accepted");
                existingUserLoginRequest.status = 1;
                existingUserLoginRequest.statusString = "Everything ok";
                existingUserLoginRequest.user = user;
                if (this.isOnline(existingUserLoginRequest.user.getName())) {
                    this.log("Closing old connection of user " + existingUserLoginRequest.user.getName());
                    this.closeConnection(this.getConnection(this.getOnlineUserId(existingUserLoginRequest.user.getName())));
                }
                this.handleAcceptedUserLoginRequest(existingUserLoginRequest, connection);
                return;
            }
            if (object instanceof NewUserLoginRequest) {
                NewUserLoginRequest newUserLoginRequest = (NewUserLoginRequest)object;
                this.log("Login for user " + newUserLoginRequest.user.getName() + " received");
                if (this.exists(newUserLoginRequest.user.getName())) {
                    newUserLoginRequest.status = 2;
                    newUserLoginRequest.statusString = "User exists. Choose different name or login as existing user";
                    this.log("Login for new user " + newUserLoginRequest.user.getName() + " denied: Already existing");
                    this.send(newUserLoginRequest, connection);
                    return;
                }
                newUserLoginRequest.status = 1;
                newUserLoginRequest.statusString = "Everything ok";
                this.log("Login for new user " + newUserLoginRequest.user.getName() + " accepted");
                this.saveUser(newUserLoginRequest.user);
                this.handleAcceptedUserLoginRequest(newUserLoginRequest, connection);
                return;
            }
        } else {
            if (object instanceof UserUpdateEvent) {
                UserUpdateEvent userUpdateEvent = (UserUpdateEvent)object;
                if (!userUpdateEvent.done) {
                    this.log("Update for user " + userUpdateEvent.user.getName() + " received");
                    new UserUpdateThread(userUpdateEvent, this, connection).start();
                    return;
                }
                this.handleUserUpdateInternal(userUpdateEvent, connection);
                return;
            }
            if (object instanceof RoomEvent) {
                if (object instanceof RoomUpdateEvent || object instanceof RoomCreateEvent) {
                    RoomEvent roomEvent;
                    Room room2 = room = object instanceof RoomUpdateEvent ? ((RoomUpdateEvent)object).room : ((RoomCreateEvent)object).room;
                    if (object instanceof RoomCreateEvent && this.roomExists(room.getName())) {
                        int n = 1;
                        while (this.roomExists(String.valueOf(room.getName()) + n)) {
                            ++n;
                        }
                        room.setName(String.valueOf(room.getName()) + n);
                    }
                    if (object instanceof RoomUpdateEvent) {
                        roomEvent = (RoomUpdateEvent)object;
                        if (room.getId() != 0) {
                            this.addRoom(room);
                        }
                        roomEvent = new RoomUpdateEvent(room);
                        this.log("Handling room update for room " + room.getName() + " from user " + this.getOnlineUser(connection.getUserId()).getName());
                    } else {
                        roomEvent = (RoomCreateEvent)object;
                        room.removeAllUsers();
                        this.setNextAvailableRoomIdAndAdd(room);
                        roomEvent = new RoomCreateEvent(room);
                        this.log("Handling room creation for room " + room.getName() + " from user " + this.getOnlineUser(connection.getUserId()).getName());
                    }
                    if (room.getId() != 0) {
                        this.broadcast(roomEvent);
                    }
                    IntegerHashtable integerHashtable = this.onlineTable;
                    synchronized (integerHashtable) {
                        Enumeration enumeration = this.onlineTable.elements();
                        while (enumeration.hasMoreElements()) {
                            User user = (User)enumeration.nextElement();
                            if (room.getId() == 0 && KEY.equals(this.getOnlineUser(connection.getUserId()).getName()) && room.isKicked(user.getName())) {
                                this.log("User " + user.getName() + " is kicked out");
                                Connection connection2 = this.getConnection(user.getId());
                                if (connection2 == null) continue;
                                this.bannedIPs.addElement(new String(connection2.getIPAddress()));
                                this.closeConnection(connection2);
                                try {
                                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(BANNED_IP_FILENAME)));
                                    Enumeration enumeration2 = this.bannedIPs.elements();
                                    while (enumeration2.hasMoreElements()) {
                                        bufferedOutputStream.write(enumeration2.nextElement().toString().getBytes("ISO-8859-1"));
                                        bufferedOutputStream.write(System.getProperty("line.separator").getBytes("ISO-8859-1"));
                                    }
                                    bufferedOutputStream.close();
                                }
                                catch (IOException iOException) {
                                    this.log("Exception while saving banned IPs: " + iOException.getMessage());
                                }
                                continue;
                            }
                            if (room.getId() == 0 || user.getRoom() != room.getId() || room.hasAccess(user.getName())) continue;
                            this.log("User " + user.getName() + " is moved back to the lobby");
                            user.setRoom(0);
                            user.setPosition(this.getAvailablePosition(0));
                            this.broadcast(new UserRoomEvent(user.getId(), user.getRoom(), user.getPosition()));
                        }
                    }
                }
                if (object instanceof RoomRemoveEvent && (room = this.getRoom(((RoomRemoveEvent)object).roomId)) != null && room.getId() != 0) {
                    IntegerHashtable integerHashtable = this.onlineTable;
                    synchronized (integerHashtable) {
                        Enumeration enumeration = this.onlineTable.elements();
                        while (enumeration.hasMoreElements()) {
                            User user = (User)enumeration.nextElement();
                            if (user.getRoom() != room.getId()) continue;
                            this.log("User " + user.getName() + " is moved back to the lobby");
                            user.setRoom(0);
                            user.setPosition(this.getAvailablePosition(0));
                            this.broadcast(new UserRoomEvent(user.getId(), user.getRoom(), user.getPosition()));
                        }
                    }
                    this.removeRoom(room.getId());
                    this.broadcast(object);
                }
                this.saveRooms();
                return;
            }
            if (object instanceof UserEvent) {
                boolean bl = true;
                User user = this.getOnlineUser(((UserEvent)object).userId);
                if (user != null) {
                    if (object instanceof UserPositionEvent) {
                        user.setPosition(((UserPositionEvent)object).userPosition);
                    } else if (object instanceof UserHeadingEvent) {
                        user.setHeading(((UserHeadingEvent)object).userHeading);
                    } else {
                        if (object instanceof UserWhisperEvent) {
                            this.log("User " + user.getName() + " whispers " + ((UserWhisperEvent)object).userMessage);
                            this.send(object, this.getConnection(((UserWhisperEvent)object).receivingUserId));
                            return;
                        }
                        if (object instanceof UserMessageEvent) {
                            user.setMessage(((UserMessageEvent)object).userMessage);
                            this.log("User " + user.getName() + " says " + user.getMessage());
                        } else if (object instanceof UserMoodEvent) {
                            user.setMood(((UserMoodEvent)object).userMood);
                        } else if (object instanceof UserRoomEvent) {
                            room = this.getRoom(((UserRoomEvent)object).roomId);
                            if (room != null) {
                                this.getRoom(room.getId()).removeUser(user.getName());
                                user.setRoom(room.getId());
                                room.addUser(user.getName());
                                room.setLastAccess(new GregorianCalendar());
                                user.setPosition(this.getAvailablePosition(room.getId()));
                                ((UserRoomEvent)object).position = user.getPosition();
                            }
                            bl = false;
                        }
                    }
                    if (object instanceof UserLogoutEvent) {
                        this.closeConnection(connection);
                        return;
                    }
                    this.addOnlineUser(user);
                    if (bl) {
                        this.broadcastExcluding(object, connection);
                        return;
                    }
                    this.broadcast(object);
                    return;
                }
            } else if (object instanceof ServerAdministrationRequest) {
                if (((ServerAdministrationRequest)object).key.equals(this.key)) {
                    ((ServerAdministrationRequest)object).status = 1;
                    if (object instanceof ServerStopRequest) {
                        try {
                            this.log("Stopping server...");
                            this.listener.close();
                            this.serverThread.stop();
                            Vector vector = this.connectionVector;
                            synchronized (vector) {
                                Enumeration enumeration = this.connectionVector.elements();
                                while (enumeration.hasMoreElements()) {
                                    Connection connection3 = (Connection)enumeration.nextElement();
                                    if (connection3.getUserId() == 0) continue;
                                    this.closeConnection(connection3);
                                }
                            }
                            this.saveUserList();
                            Runtime.getRuntime().exit(0);
                            return;
                        }
                        catch (IOException iOException) {
                            this.log("Exception while stopping server: " + iOException);
                            return;
                        }
                    }
                    if (object instanceof ServerUserListRequest) {
                        ServerUserListRequest serverUserListRequest = (ServerUserListRequest)object;
                        Connection connection4 = connection;
                        if (serverUserListRequest.userListVector == null) {
                            new Thread(new 2(connection4, serverUserListRequest, this)).start();
                            return;
                        }
                        this.log("Sending user list...");
                        this.send(serverUserListRequest, connection4);
                        return;
                    }
                    if (object instanceof ServerGetUserDataRequest) {
                        this.log("Retrieving data for user " + ((ServerGetUserDataRequest)object).user.getName());
                        User user = this.loadUser(((ServerGetUserDataRequest)object).user.getName());
                        if (user != null) {
                            ((ServerGetUserDataRequest)object).user.setPassword(user.getPassword());
                            ((ServerGetUserDataRequest)object).user.setEmail(user.getEmail());
                        } else {
                            this.log("Error: User " + ((ServerGetUserDataRequest)object).user.getName() + " doesn't exist");
                            ((ServerGetUserDataRequest)object).status = 3;
                        }
                        this.send(object, connection);
                        return;
                    }
                    if (object instanceof ServerUpdateUserDataRequest) {
                        this.log("Updating data for user " + ((ServerUpdateUserDataRequest)object).user.getName());
                        User user = this.loadUser(((ServerUpdateUserDataRequest)object).user.getName());
                        if (user != null) {
                            user.setPassword(((ServerUpdateUserDataRequest)object).user.getPassword());
                            user.setEmail(((ServerUpdateUserDataRequest)object).user.getEmail());
                            this.saveUser(user);
                            if (this.isOnline(user.getName())) {
                                this.addOnlineUser(user);
                                User user2 = (User)user.clone();
                                user2.setPassword("");
                                this.handleUserUpdateInternal(new UserUpdateEvent(user2), this.getConnection(user.getId()));
                            }
                        } else {
                            this.log("Error: User " + ((ServerUpdateUserDataRequest)object).user.getName() + " doesn't exist");
                            ((ServerGetUserDataRequest)object).status = 3;
                        }
                        this.send(object, connection);
                        return;
                    }
                    if (object instanceof ServerDeleteUserRequest) {
                        this.log("Deleting user " + ((ServerDeleteUserRequest)object).userName);
                        String string = ((ServerDeleteUserRequest)object).userName;
                        if (this.exists(string)) {
                            if (this.isOnline(string)) {
                                this.closeConnection(this.getConnection(this.getOnlineUserId(string)));
                            }
                            this.deleteUser(string);
                        } else {
                            this.log("Error: User " + ((ServerDeleteUserRequest)object).userName + " doesn't exist");
                            ((ServerDeleteUserRequest)object).status = 3;
                        }
                        this.send(object, connection);
                        return;
                    }
                } else {
                    this.log("Wrong server key");
                    ((ServerAdministrationRequest)object).status = 2;
                    this.send(object, connection);
                }
            }
        }
    }

    private void handleAcceptedUserLoginRequest(UserLoginRequest userLoginRequest, Connection connection) {
        Cloneable cloneable;
        userLoginRequest.user.setRoom(0);
        userLoginRequest.user.setLoginDate(new Date());
        userLoginRequest.user.setPosition(this.getAvailablePosition(0));
        this.setNextAvailableUserIdAndAdd(userLoginRequest.user);
        connection.setUserId(userLoginRequest.user.getId());
        this.send(userLoginRequest, connection);
        Cloneable cloneable2 = this.roomTable;
        synchronized (cloneable2) {
            this.send(new RoomListEvent(this.roomTable), connection);
        }
        cloneable2 = new Vector();
        Object object = this.onlineTable;
        synchronized (object) {
            Enumeration enumeration = this.onlineTable.elements();
            while (enumeration.hasMoreElements()) {
                ((Vector)cloneable2).addElement(enumeration.nextElement());
            }
        }
        object = ((Vector)cloneable2).elements();
        while (object.hasMoreElements()) {
            cloneable = (User)object.nextElement();
            cloneable = (User)((User)cloneable).clone();
            ((User)cloneable).setPassword("");
            if (((User)cloneable).getId() == userLoginRequest.user.getId()) continue;
            this.send(new UserLoginEvent((User)cloneable), connection);
        }
        cloneable = this.connectionVector;
        synchronized (cloneable) {
            this.connectionVector.addElement(connection);
        }
        cloneable = (User)userLoginRequest.user.clone();
        ((User)cloneable).setPassword("");
        UserLoginEvent userLoginEvent = new UserLoginEvent((User)cloneable);
        this.broadcastExcluding(userLoginEvent, connection);
        this.saveUserList();
    }

    private void handleUserUpdateInternal(UserUpdateEvent userUpdateEvent, Connection connection) {
        this.saveUser(userUpdateEvent.user);
        this.addOnlineUser(userUpdateEvent.user);
        this.send(userUpdateEvent, connection);
        User user = (User)userUpdateEvent.user.clone();
        user.setPassword("");
        UserUpdateEvent userUpdateEvent2 = new UserUpdateEvent(user, false);
        userUpdateEvent2.statusString = "";
        userUpdateEvent2.done = true;
        this.broadcastExcluding(userUpdateEvent2, connection);
    }

    private void broadcastExcluding(Object object, Connection connection) {
        this.log("Broadcasting...", 3);
        Enumeration enumeration = this.getConnectionEnum(connection);
        while (enumeration.hasMoreElements()) {
            Connection connection2 = (Connection)enumeration.nextElement();
            connection2.send(object);
        }
    }

    private Enumeration getConnectionEnum(Connection connection) {
        Vector<Connection> vector = new Vector<Connection>();
        Vector vector2 = this.connectionVector;
        synchronized (vector2) {
            Enumeration enumeration = this.connectionVector.elements();
            while (enumeration.hasMoreElements()) {
                Connection connection2 = (Connection)enumeration.nextElement();
                if (connection2.getUserId() == 0 || connection2 == connection) continue;
                vector.addElement(connection2);
            }
        }
        return vector.elements();
    }

    private void broadcast(Object object) {
        this.broadcastExcluding(object, null);
    }

    private void send(Object object, Connection connection) {
        if (connection != null) {
            this.log("Sending...", 3);
            connection.send(object);
        }
    }

    private void closeConnection(Connection connection) {
        if (connection != null) {
            int n = connection.getUserId();
            User user = this.getOnlineUser(n);
            this.removeOnlineUser(n);
            if (user != null) {
                this.log("Closing connection of " + user.getName());
            }
            connection.close();
            Cloneable cloneable = this.connectionVector;
            synchronized (cloneable) {
                this.connectionVector.removeElement(connection);
            }
            try {
                if (n != 0) {
                    this.broadcastExcluding(new UserLogoutEvent(n), connection);
                    if (user != null && (cloneable = this.getRoom(user.getRoom())) != null) {
                        ((Room)cloneable).removeUser(user.getName());
                    }
                }
            }
            catch (Exception exception) {
                this.log("Exception while closing connection: " + exception);
                exception.printStackTrace();
            }
            this.saveUserList();
        }
    }

    private Connection getConnection(int n) {
        Vector vector = this.connectionVector;
        synchronized (vector) {
            Enumeration enumeration = this.connectionVector.elements();
            while (enumeration.hasMoreElements()) {
                Connection connection = (Connection)enumeration.nextElement();
                if (connection.getUserId() != n) continue;
                Connection connection2 = connection;
                Object var6_6 = null;
                return connection2;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean roomExists(String string) {
        IntegerHashtable integerHashtable = this.roomTable;
        synchronized (integerHashtable) {
            if (ChatRepository.STANDARD_ROOM_NAME[0].equals(string)) {
                return true;
            }
            Enumeration enumeration = this.roomTable.elements();
            while (enumeration.hasMoreElements()) {
                if (!((Room)enumeration.nextElement()).getName().equals(string)) continue;
                return true;
            }
            return false;
        }
    }

    private boolean isOnline(int n) {
        return this.onlineTable.containsKey(n);
    }

    private boolean isOnline(String string) {
        return this.getOnlineUserId(string) != -1;
    }

    private int getOnlineUserId(String string) {
        IntegerHashtable integerHashtable = this.onlineTable;
        synchronized (integerHashtable) {
            Enumeration enumeration = this.onlineTable.elements();
            while (enumeration.hasMoreElements()) {
                User user = (User)enumeration.nextElement();
                if (!user.getName().equals(string)) continue;
                int n = user.getId();
                Object var6_6 = null;
                return n;
            }
        }
        return -1;
    }

    private boolean exists(String string) {
        return new File(String.valueOf(this.storageFolder) + string).exists();
    }

    private void saveUser(User user) {
        this.save(user, String.valueOf(this.storageFolder) + user.getName());
    }

    public User loadUser(String string) {
        Object object = this.load(String.valueOf(this.storageFolder) + string);
        if (object instanceof User) {
            return (User)object;
        }
        return null;
    }

    private void deleteUser(String string) {
        new File(String.valueOf(this.storageFolder) + string).delete();
    }

    private void setNextAvailableUserIdAndAdd(User user) {
        IntegerHashtable integerHashtable = this.onlineTable;
        synchronized (integerHashtable) {
            int n;
            while (this.onlineTable.containsKey(n = this.rand.nextInt())) {
            }
            user.setId(n);
            this.addOnlineUser(user);
            return;
        }
    }

    private void setNextAvailableRoomIdAndAdd(Room room) {
        IntegerHashtable integerHashtable = this.roomTable;
        synchronized (integerHashtable) {
            room.setId(Math.max(1, this.roomTable.getMaxKey() + 1));
            this.addRoom(room);
            return;
        }
    }

    private boolean correctPassword(String string, String string2) {
        User user = this.loadUser(string);
        if (user instanceof User) {
            return user.getPassword().equals(string2);
        }
        return false;
    }

    private void save(Object object, String string) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string));
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            this.log("IOException while writing file " + string);
            return;
        }
    }

    private void saveUserList() {
        String string = (String)((Hashtable)System.getProperties()).get("VCHAT_USERLIST");
        if (string != null && string.length() > 0) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                IntegerHashtable integerHashtable = this.onlineTable;
                synchronized (integerHashtable) {
                    Enumeration enumeration = this.onlineTable.elements();
                    while (enumeration.hasMoreElements()) {
                        byte[] byArray = ("(" + ((User)enumeration.nextElement()).getName() + ")").getBytes();
                        fileOutputStream.write(byArray);
                        fileOutputStream.write(10);
                    }
                }
                fileOutputStream.close();
                return;
            }
            catch (IOException iOException) {
                this.log("IOException while writing file " + string);
                return;
            }
        }
    }

    private Object load(String string) {
        Object object = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(string));
            object = objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log("ClassNotFoundException while reading file " + string);
        }
        catch (IOException iOException) {
            this.log("IOException while reading file " + string);
        }
        return object;
    }

    private void addOnlineUser(User user) {
        IntegerHashtable integerHashtable = this.onlineTable;
        synchronized (integerHashtable) {
            this.onlineTable.put(user.getId(), user);
            return;
        }
    }

    private void removeOnlineUser(int n) {
        IntegerHashtable integerHashtable = this.onlineTable;
        synchronized (integerHashtable) {
            this.onlineTable.remove(n);
            return;
        }
    }

    private void addRoom(Room room) {
        IntegerHashtable integerHashtable = this.roomTable;
        synchronized (integerHashtable) {
            this.roomTable.put(room.getId(), room);
            return;
        }
    }

    private void removeRoom(int n) {
        IntegerHashtable integerHashtable = this.roomTable;
        synchronized (integerHashtable) {
            this.roomTable.remove(n);
            return;
        }
    }

    private User getOnlineUser(int n) {
        Object object = this.onlineTable.get(n);
        if (object != null) {
            return (User)object;
        }
        return null;
    }

    private Room getRoom(int n) {
        Object object = this.roomTable.get(n);
        if (object != null) {
            return (Room)object;
        }
        return null;
    }

    private Point getAvailablePosition(int n) {
        Point point;
        while (this.collides(n, point = new Point(Math.abs(this.rand.nextInt()) % (ChatRepository.ROOM_DIMENSION.width - 10) + 5, Math.abs(this.rand.nextInt()) % (ChatRepository.ROOM_DIMENSION.height - 10) + 5), -1)) {
        }
        return point;
    }

    private boolean collides(int n, Point point, int n2) {
        IntegerHashtable integerHashtable = this.onlineTable;
        synchronized (integerHashtable) {
            Enumeration enumeration = this.onlineTable.elements();
            while (enumeration.hasMoreElements()) {
                User user = (User)enumeration.nextElement();
                if (user.getRoom() != n || user.getId() == n2 || !new Rectangle(user.getPosition().x - 6, user.getPosition().y - 6, 12, 12).contains(point)) continue;
                boolean bl = true;
                Object var8_8 = null;
                return bl;
            }
        }
        return false;
    }

    public synchronized void log(String string) {
        this.log(string, 1);
    }

    public synchronized void log(String string, int n) {
        if (n <= this.logLevel) {
            System.out.println(String.valueOf(DateFormat.getDateInstance(3).format(new Date())) + " " + DateFormat.getTimeInstance(2).format(new Date()) + ": " + string);
        }
    }

    public String getImageFolder() {
        return this.imageFolder;
    }

    private void createStandardRooms() {
        this.roomTable = new IntegerHashtable();
        int n = 0;
        while (n < ChatRepository.STANDARD_ROOM_NAME.length) {
            Room room = new Room(n, ChatRepository.STANDARD_ROOM_NAME[n], ChatRepository.ROOM_DIMENSION);
            room.setPrivate(ChatRepository.STANDARD_ROOM_PRIVATE[n]);
            room.setAdministrator(KEY);
            this.addRoom(room);
            ++n;
        }
        this.log("Created standard rooms...");
        this.saveRooms();
    }

    private void saveRooms() {
        IntegerHashtable integerHashtable = this.roomTable;
        synchronized (integerHashtable) {
            this.save(this.roomTable, String.valueOf(this.roomFolder) + this.roomFilename);
        }
        this.log("Saved rooms...");
    }

    public static class LinkedList {
        private ChatServer server;
        private LinkedElem front;

        public LinkedList(ChatServer chatServer) {
            this.server = chatServer;
        }

        public synchronized Object popFront() {
            LinkedElem linkedElem = this.front;
            if (linkedElem == null) {
                return null;
            }
            this.front = this.front.next;
            linkedElem.next = null;
            return linkedElem.obj;
        }

        public synchronized void pushBack(Object object) {
            LinkedElem linkedElem = new LinkedElem(object);
            if (this.front == null) {
                this.front = linkedElem;
                return;
            }
            LinkedElem linkedElem2 = this.front;
            while (linkedElem2.next != null) {
                linkedElem2 = linkedElem2.next;
            }
            linkedElem2.next = linkedElem;
        }

        public synchronized boolean isEmpty() {
            return this.front == null;
        }

        public class LinkedElem {
            public Object obj;
            public LinkedElem next;

            public LinkedElem(Object object) {
                LinkedList.this = LinkedList.this;
                this.obj = object;
            }
        }
    }

    public static class WorkerThread
    implements Runnable {
        private Object spinLock = new Object();
        private LinkedList pendingEvents;
        private ChatServer server;
        private boolean stopped;

        public WorkerThread(ChatServer chatServer) {
            this.server = chatServer;
            this.pendingEvents = new LinkedList(this.server);
            new Thread(this).start();
            this.stopped = false;
        }

        public void run() {
            while (!this.stopped) {
                Object object = this.spinLock;
                synchronized (object) {
                    if (this.pendingEvents.isEmpty()) {
                        try {
                            this.spinLock.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (this.pendingEvents.isEmpty()) continue;
                object = (EventContainer)this.pendingEvents.popFront();
                try {
                    this.server.handleUserEventInternal(((EventContainer)object).event, ((EventContainer)object).conn);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                catch (Error error) {
                    error.printStackTrace();
                }
            }
        }

        public void handleEvent(Object object, Connection connection) {
            this.pendingEvents.pushBack(new EventContainer(object, connection));
            Object object2 = this.spinLock;
            synchronized (object2) {
                this.spinLock.notify();
                return;
            }
        }

        public void stop() {
            this.stopped = true;
            Object object = this.spinLock;
            synchronized (object) {
                this.spinLock.notify();
                return;
            }
        }

        public class EventContainer {
            public Object event;
            public Connection conn;

            public EventContainer(Object object, Connection connection) {
                WorkerThread.this = WorkerThread.this;
                this.event = object;
                this.conn = connection;
            }
        }
    }

    public class EventContainer {
        public Object event;
        public Connection conn;

        public EventContainer(Object object, Connection connection) {
            ChatServer.this = ChatServer.this;
            this.event = object;
            this.conn = connection;
        }
    }

    private final class 1
    implements Runnable {
        public void run() {
            while (true) {
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {}
                System.gc();
            }
        }

        /* synthetic */ 1() {
        }
    }

    private static final class 2
    implements Runnable {
        private final /* synthetic */ Connection val$adminConn;
        private final /* synthetic */ ServerUserListRequest val$req;
        private final /* synthetic */ ChatServer this$0;

        public void run() {
            this.this$0.log("Received ServerUserListRequest...");
            SortedStringVector sortedStringVector = new SortedStringVector(1000);
            this.this$0.log("Retrieving user list...");
            String[] stringArray = new File(this.this$0.storageFolder).list();
            int n = 0;
            while (n < stringArray.length) {
                sortedStringVector.addElement(stringArray[n]);
                ++n;
            }
            this.this$0.log("Sorting user list...");
            sortedStringVector.sort();
            this.val$req.userListVector = sortedStringVector;
            this.this$0.handleUserEvent(this.val$req, this.val$adminConn);
        }

        /* synthetic */ 2(Connection connection, ServerUserListRequest serverUserListRequest, ChatServer chatServer) {
            this.val$adminConn = connection;
            this.val$req = serverUserListRequest;
            this.this$0 = chatServer;
        }
    }
}

