/*
 * Decompiled with CFR 0.152.
 */
package chat;

import chat.ChatApplet;
import chat.ChatMath;
import chat.ChatRepository;
import chat.ChatUtil;
import chat.HistoryPanel;
import chat.InsetsPanel;
import chat.MoodCanvas;
import chat.NavigationCanvas;
import chat.RoomCanvas;
import chat.RoomListPanel;
import chat.ViewCanvas;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class ChatPanel
extends Panel
implements ActionListener,
MouseListener,
KeyListener,
FocusListener {
    private ChatApplet chatApplet;
    private Dimension roomListPanelSize = ChatRepository.ROOM_DIMENSION;
    private Dimension roomCanvasSize = ChatRepository.ROOM_DIMENSION;
    private Dimension moodCanvasSize = ChatRepository.ROOM_DIMENSION;
    private InsetsPanel viewPanel;
    private InsetsPanel controlPanel;
    private InsetsPanel mapPanel;
    private InsetsPanel roomPanel;
    private InsetsPanel textPanel;
    private InsetsPanel textNavigationPanel;
    private InsetsPanel portraitPanel;
    private InsetsPanel historyCheckboxGroupPanel;
    private NavigationCanvas navigationCanvas;
    private RoomListPanel roomListPanel;
    private MoodCanvas moodCanvas;
    protected TextField chatField;
    protected Label chatLabel;
    private RoomCanvas roomCanvas;
    private ViewCanvas viewCanvas;
    private HistoryPanel pnlHistory;
    private TextArea messageArea;

    public ChatPanel(ChatApplet chatApplet) {
        this.chatApplet = chatApplet;
        this.viewPanel = new InsetsPanel(ChatRepository.INSETS);
        this.viewPanel.setLayout(new BorderLayout());
        this.viewCanvas = new ViewCanvas(this.chatApplet);
        this.viewCanvas.setBackground(ChatRepository.COMPONENT_BACKGROUND);
        this.viewPanel.add((Component)this.viewCanvas, "Center");
        this.controlPanel = new InsetsPanel();
        this.controlPanel.setLayout(new BorderLayout());
        this.roomListPanel = new RoomListPanel(chatApplet);
        this.roomListPanel.setSize(this.roomListPanelSize);
        this.roomPanel = new InsetsPanel(ChatRepository.INSETS);
        this.roomCanvas = new RoomCanvas(this.chatApplet);
        this.roomCanvas.setBackground(ChatRepository.COMPONENT_BACKGROUND);
        this.roomCanvas.setSize(this.roomCanvasSize);
        this.roomPanel.add(this.roomCanvas);
        this.portraitPanel = new InsetsPanel(ChatRepository.INSETS);
        this.moodCanvas = new MoodCanvas(this.chatApplet);
        this.moodCanvas.setSize(this.moodCanvasSize);
        this.portraitPanel.add(this.moodCanvas);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 1));
        panel.add(this.roomPanel);
        panel.add(this.portraitPanel);
        this.controlPanel.add((Component)this.roomListPanel, "Center");
        this.controlPanel.add((Component)panel, "South");
        this.textPanel = new InsetsPanel(new Insets(ChatRepository.INSETS.top, 0, ChatRepository.INSETS.bottom, 0));
        this.chatLabel = new Label("Chat:", 2);
        this.pnlHistory = new HistoryPanel("History", this.chatApplet);
        this.chatField = new TextField(75);
        this.messageArea = new TextArea("", 6, 25, 1);
        this.messageArea.setEditable(false);
        this.chatField.addKeyListener(this);
        this.chatField.addActionListener(this);
        this.chatField.addMouseListener(this);
        this.textPanel.setLayout(new GridBagLayout());
        if (this.chatApplet.getBooleanParam("HistoryBarVisibility", true)) {
            ChatUtil.addWithRemainingConstraints(this.textPanel, this.pnlHistory);
        }
        ChatUtil.addWithBeginningConstraints(this.textPanel, this.chatLabel);
        ChatUtil.addWithRemainingConstraints(this.textPanel, this.chatField);
        this.navigationCanvas = new NavigationCanvas(this.chatApplet, this.chatApplet.getImage("arrowforward.gif"), this.chatApplet.getImage("arrowbackward.gif"), this.chatApplet.getImage("arrowleft.gif"), this.chatApplet.getImage("arrowright.gif"));
        this.textNavigationPanel = new InsetsPanel(new Insets(0, ChatRepository.SMALL_INSETS.left, 0, ChatRepository.SMALL_INSETS.right));
        this.textNavigationPanel.setLayout(new BorderLayout());
        this.textNavigationPanel.add((Component)this.textPanel, "Center");
        this.textNavigationPanel.add((Component)this.navigationCanvas, "East");
        this.textNavigationPanel.add((Component)this.messageArea, "South");
        this.viewPanel.add((Component)this.textNavigationPanel, "South");
        this.setLayout(new BorderLayout());
        ((Component)this).setFont(ChatRepository.STANDARD_FONT);
        this.add((Component)this.viewPanel, "Center");
        this.add((Component)this.controlPanel, "East");
        this.chatApplet.setHistoryPanel(this.pnlHistory);
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.chatField) {
            this.chatApplet.setUserMessage(this.chatApplet.getCurrentUser().getId(), this.chatField.getText(), true);
            ((TextComponent)this.chatField).setText("");
        }
    }

    public void handleKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.isAltDown()) {
            if (keyEvent.getKeyCode() == 40) {
                this.chatApplet.setUserPosition(this.chatApplet.getCurrentUser().getId(), new Point(this.chatApplet.getCurrentUser().getPosition().x - (int)(ChatMath.getCos(this.chatApplet.getCurrentUser().getHeading()) * 2.0), this.chatApplet.getCurrentUser().getPosition().y + (int)(ChatMath.getSin(this.chatApplet.getCurrentUser().getHeading()) * 2.0)), true);
            } else if (keyEvent.getKeyCode() == 38) {
                this.chatApplet.setUserPosition(this.chatApplet.getCurrentUser().getId(), new Point(this.chatApplet.getCurrentUser().getPosition().x + (int)(ChatMath.getCos(this.chatApplet.getCurrentUser().getHeading()) * 2.0), this.chatApplet.getCurrentUser().getPosition().y - (int)(ChatMath.getSin(this.chatApplet.getCurrentUser().getHeading()) * 2.0)), true);
            } else if (keyEvent.getKeyCode() == 37) {
                this.chatApplet.setUserHeading(this.chatApplet.getCurrentUser().getId(), this.chatApplet.getCurrentUser().getHeading() + 2, true);
            } else if (keyEvent.getKeyCode() == 39) {
                this.chatApplet.setUserHeading(this.chatApplet.getCurrentUser().getId(), this.chatApplet.getCurrentUser().getHeading() - 2, true);
            }
        }
        if (keyEvent.getComponent() == this.chatField && this.chatApplet.historyMode()) {
            this.chatApplet.exitHistoryMode();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.handleKeyEvent(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.handleKeyEvent(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.handleKeyEvent(keyEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this.chatField && this.chatApplet.historyMode()) {
            this.chatApplet.exitHistoryMode();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void repaintView() {
        this.viewCanvas.repaint();
    }

    public void updateRoomList() {
        this.roomListPanel.updateRoomList();
    }

    public void fillRoomList() {
        this.roomListPanel.fillRoomList();
    }

    public void repaintRoom() {
        this.roomCanvas.repaint();
    }

    public void repaintMood() {
        this.moodCanvas.repaint();
    }

    public void addMessage(String string, String string2) {
        this.messageArea.append("\n<" + string + "> " + string2);
    }

    public void clearMessage() {
        this.messageArea.setText("");
    }
}

