/*
 * Decompiled with CFR 0.152.
 */
package chat;

public class ChatMath {
    private static final int ENTRY_COUNT = 3600;
    private static final int FACTOR = 10;
    private static double[] sinTable = new double[3600];
    private static double[] cosTable = new double[3600];
    public static final double PI_RAD = Math.PI / 180;

    public static double getSin(double d) {
        int n = (int)(d * 10.0);
        if (n < 0 || n >= 3600) {
            n = (n + 3600) % 3600;
        }
        if (sinTable[n] == Double.MAX_VALUE) {
            ChatMath.sinTable[n] = Math.sin(d * (Math.PI / 180));
        }
        return sinTable[n];
    }

    public static double getCos(double d) {
        int n = (int)(d * 10.0);
        if (n < 0 || n >= 3600) {
            n = (n + 3600) % 3600;
        }
        if (cosTable[n] == Double.MAX_VALUE) {
            ChatMath.cosTable[n] = Math.cos(d * (Math.PI / 180));
        }
        return cosTable[n];
    }

    static {
        int n = 0;
        while (n < 3600) {
            ChatMath.sinTable[n] = Double.MAX_VALUE;
            ChatMath.cosTable[n] = Double.MAX_VALUE;
            ++n;
        }
    }
}

