/*
 * Decompiled with CFR 0.152.
 */
package chat;

import chat.ChatRepository;
import chat.ChatUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.StringTokenizer;

public class Balloon
extends Component {
    public static final int FACING_RIGHT = 0;
    public static final int FACING_LEFT = 1;
    public static final int DIAMETER = 5;
    public static final int MARGIN = 5;
    public static final double VERTICAL_SCALE = 0.8;
    public static final double HORICONTAL_SCALE = 0.2;
    public static final double LINE_SPACING = 1.2;
    private Rectangle area;
    private String text;
    private Color color;
    private Font font;
    private int facing;

    public Balloon(Rectangle rectangle, String string, Color color) {
        this(rectangle, string, color, 0);
    }

    public Balloon(Rectangle rectangle, String string, Color color, int n) {
        this(rectangle, string, ChatRepository.STANDARD_FONT, color, n);
    }

    public Balloon(Rectangle rectangle, String string, Font font, Color color, int n) {
        this.area = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.text = string;
        this.font = font;
        this.color = color;
        this.facing = n;
    }

    public void paint(Graphics graphics) {
        if (this.text != null && !this.text.equals("")) {
            int[] nArray = new int[]{this.facing == 0 ? this.area.x + this.area.width : this.area.x, this.area.x + (int)((double)this.area.width * 0.8 / 2.0), this.area.x + (int)((double)this.area.width * 1.2 / 2.0)};
            int[] nArray2 = new int[]{this.area.y + this.area.height, this.area.y + (int)((double)this.area.height * 0.8), this.area.y + (int)((double)this.area.height * 0.8)};
            ChatUtil.paintPattern(graphics, new Rectangle(this.area.x, this.area.y, this.area.width, (int)((double)this.area.height * 0.8)), Color.white);
            graphics.setColor(this.color);
            graphics.drawLine(this.area.x, this.area.y, this.area.x + this.area.width, this.area.y);
            graphics.drawLine(this.area.x, this.area.y, this.area.x, this.area.y + (int)((double)this.area.height * 0.8));
            graphics.drawLine(this.area.x + this.area.width, this.area.y, this.area.x + this.area.width, this.area.y + (int)((double)this.area.height * 0.8));
            graphics.drawLine(this.area.x, this.area.y + (int)((double)this.area.height * 0.8), nArray[1], nArray2[1]);
            graphics.drawLine(this.area.x + this.area.width, this.area.y + (int)((double)this.area.height * 0.8), nArray[2], nArray2[2]);
            graphics.drawLine(nArray[0], nArray2[0], nArray[1], nArray2[1]);
            graphics.drawLine(nArray[0], nArray2[0], nArray[2], nArray2[2]);
            Font font = graphics.getFont();
            graphics.setFont(this.font);
            int n = this.getFontMetrics(this.font).getAscent();
            int n2 = (int)((double)this.getFontMetrics(this.font).getHeight() * 1.2);
            StringTokenizer stringTokenizer = new StringTokenizer(String.valueOf(this.text) + " ");
            Rectangle rectangle = new Rectangle(this.area.x + 5, this.area.y + 5, this.area.width - 10, (int)((double)this.area.height * 0.8) - 10);
            int n3 = rectangle.x;
            int n4 = rectangle.y;
            String string = "";
            String string2 = "";
            while (n4 + n < rectangle.y + rectangle.height && (stringTokenizer.hasMoreTokens() || string2.length() > 0)) {
                int n5 = 0;
                boolean bl = this.getFontMetrics(this.font).stringWidth(string2) > rectangle.width;
                while (!bl) {
                    boolean bl2 = bl = !stringTokenizer.hasMoreTokens();
                    if (bl) continue;
                    string = String.valueOf(stringTokenizer.nextToken()) + " ";
                    boolean bl3 = bl = this.getFontMetrics(this.font).stringWidth(String.valueOf(string2) + string) > rectangle.width;
                    if (bl) continue;
                    string2 = String.valueOf(string2) + string;
                    string = "";
                    ++n5;
                }
                if (n5 == 0 && string.length() > 0) {
                    string2 = String.valueOf(string2) + string;
                    string = "";
                }
                while (this.getFontMetrics(this.font).stringWidth(string2) > rectangle.width && string2.length() > 0) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                graphics.drawString(string2, n3, n4 + n);
                n4 += n2;
                string2 = string;
                string = "";
            }
            graphics.setFont(font);
        }
    }
}

