/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.swing;

import com.swabunga.spell.event.SpellCheckEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JSpellForm
extends JPanel
implements ActionListener,
ListSelectionListener {
    public static final String IGNORE_CMD = "IGNORE";
    public static final String IGNOREALL_CMD = "IGNOREALL";
    public static final String ADD_CMD = "ADD";
    public static final String REPLACE_CMD = "REPLACE";
    public static final String REPLACEALL_CMD = "REPLACEALL";
    public static final String CANCEL_CMD = "CANCEL";
    private static final String SUGGESTIONS_RES = "SUGGESTIONS";
    private static final String INVALIDWORD_RES = "INVALIDWORD";
    protected JList suggestList;
    protected JTextArea checkText;
    protected SpellCheckEvent spellEvent;
    protected EventListenerList listenerList = new EventListenerList();
    protected ResourceBundle messages = ResourceBundle.getBundle("com.swabunga.spell.swing.messages", Locale.getDefault());
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public JSpellForm() {
        this.initialiseGUI();
    }

    private static final JButton createButton(String string, String string2, ActionListener actionListener) {
        JButton jButton = new JButton(string2);
        jButton.setActionCommand(string);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    protected JPanel makeEastPanel() {
        JPanel jPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel, 1);
        jPanel.setLayout(boxLayout);
        JButton jButton = JSpellForm.createButton(IGNORE_CMD, this.messages.getString(IGNORE_CMD), this);
        jButton.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        jPanel.add(jButton);
        JButton jButton2 = JSpellForm.createButton(IGNOREALL_CMD, this.messages.getString(IGNOREALL_CMD), this);
        jButton2.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        jPanel.add(jButton2);
        JButton jButton3 = JSpellForm.createButton(ADD_CMD, this.messages.getString(ADD_CMD), this);
        jButton3.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        jPanel.add(jButton3);
        JButton jButton4 = JSpellForm.createButton(REPLACE_CMD, this.messages.getString(REPLACE_CMD), this);
        jButton4.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        jPanel.add(jButton4);
        JButton jButton5 = JSpellForm.createButton(REPLACEALL_CMD, this.messages.getString(REPLACEALL_CMD), this);
        jButton5.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        jPanel.add(jButton5);
        JButton jButton6 = JSpellForm.createButton(CANCEL_CMD, this.messages.getString(CANCEL_CMD), this);
        jButton6.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        jPanel.add(jButton6);
        return jPanel;
    }

    protected JPanel makeCentrePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JLabel jLabel = new JLabel(this.messages.getString(INVALIDWORD_RES));
        jPanel.add(jLabel);
        this.checkText = new JTextArea();
        jPanel.add(new JScrollPane(this.checkText));
        JLabel jLabel2 = new JLabel(this.messages.getString(SUGGESTIONS_RES));
        jPanel.add(jLabel2);
        this.suggestList = new JList();
        this.suggestList.setSelectionMode(0);
        jPanel.add(new JScrollPane(this.suggestList));
        this.suggestList.addListSelectionListener(this);
        return jPanel;
    }

    protected void initialiseGUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.makeEastPanel(), "East");
        this.add((Component)this.makeCentrePanel(), "Center");
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = JSpellForm.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = JSpellForm.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, actionListener);
    }

    protected void fireActionEvent(ActionEvent actionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$java$awt$event$ActionListener == null ? JSpellForm.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) continue;
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
        }
    }

    public void setSpellEvent(SpellCheckEvent spellCheckEvent) {
        this.spellEvent = spellCheckEvent;
        DefaultListModel defaultListModel = new DefaultListModel();
        List list = spellCheckEvent.getSuggestions();
        for (int i = 0; i < list.size(); ++i) {
            defaultListModel.addElement(list.get(i));
        }
        this.suggestList.setModel(defaultListModel);
        if (defaultListModel.size() > 0) {
            this.suggestList.setSelectedIndex(0);
        }
        this.checkText.setText(spellCheckEvent.getInvalidWord());
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            Object e = this.suggestList.getSelectedValue();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (IGNORE_CMD.equals(actionEvent.getActionCommand())) {
            this.spellEvent.ignoreWord(false);
        } else if (IGNOREALL_CMD.equals(actionEvent.getActionCommand())) {
            this.spellEvent.ignoreWord(true);
        } else if (REPLACE_CMD.equals(actionEvent.getActionCommand())) {
            String string = this.suggestList.getSelectedValue() != null ? this.suggestList.getSelectedValue().toString() : this.checkText.getText();
            this.spellEvent.replaceWord(string, false);
        } else if (REPLACEALL_CMD.equals(actionEvent.getActionCommand())) {
            String string = this.suggestList.getSelectedValue() != null ? this.suggestList.getSelectedValue().toString() : this.checkText.getText();
            this.spellEvent.replaceWord(string, true);
        } else if (ADD_CMD.equals(actionEvent.getActionCommand())) {
            this.spellEvent.addToDictionary(this.checkText.getText());
        } else if (CANCEL_CMD.equals(actionEvent.getActionCommand())) {
            this.spellEvent.cancel();
        }
        this.fireActionEvent(actionEvent);
    }

    public static void main(String[] stringArray) {
        try {
            JSpellForm jSpellForm = new JSpellForm();
            JFrame jFrame = new JFrame("Spelling");
            jFrame.getContentPane().add(jSpellForm);
            jFrame.setSize(300, 300);
            jFrame.setVisible(true);
            jFrame.setDefaultCloseOperation(3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

