/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.event;

import com.swabunga.spell.engine.Configuration;
import com.swabunga.spell.engine.SpellDictionary;
import com.swabunga.spell.engine.Word;
import com.swabunga.spell.event.BasicSpellCheckEvent;
import com.swabunga.spell.event.SpellCheckEvent;
import com.swabunga.spell.event.SpellCheckListener;
import com.swabunga.spell.event.StringWordTokenizer;
import com.swabunga.spell.event.WordTokenizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SpellChecker {
    public static final int SPELLCHECK_OK = -1;
    public static final int SPELLCHECK_CANCEL = -2;
    private List eventListeners = new ArrayList();
    private SpellDictionary dictionary;
    private Configuration config = Configuration.getConfiguration();
    private Set ignoredWords = new HashSet();
    private Map autoReplaceWords = new HashMap();

    public SpellChecker(SpellDictionary spellDictionary) {
        if (spellDictionary == null) {
            throw new IllegalArgumentException("dictionary must non-null");
        }
        this.dictionary = spellDictionary;
    }

    public SpellChecker(SpellDictionary spellDictionary, int n) {
        this(spellDictionary);
        this.config.setInteger("SPELL_THRESHOLD", n);
    }

    public void addSpellCheckListener(SpellCheckListener spellCheckListener) {
        this.eventListeners.add(spellCheckListener);
    }

    public void removeSpellCheckListener(SpellCheckListener spellCheckListener) {
        this.eventListeners.remove(spellCheckListener);
    }

    protected void fireSpellCheckEvent(SpellCheckEvent spellCheckEvent) {
        for (int i = this.eventListeners.size() - 1; i >= 0; --i) {
            ((SpellCheckListener)this.eventListeners.get(i)).spellingError(spellCheckEvent);
        }
    }

    public void reset() {
        this.ignoredWords.clear();
        this.autoReplaceWords.clear();
    }

    public String checkString(String string) {
        StringWordTokenizer stringWordTokenizer = new StringWordTokenizer(string);
        this.checkSpelling(stringWordTokenizer);
        return stringWordTokenizer.getFinalText();
    }

    private static final boolean isDigitWord(String string) {
        for (int i = string.length() - 1; i >= 0; --i) {
            if (!Character.isDigit(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static final boolean isINETWord(String string) {
        return false;
    }

    private static final boolean isUpperCaseWord(String string) {
        for (int i = string.length() - 1; i >= 0; --i) {
            if (!Character.isLowerCase(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static final boolean isMixedCaseWord(String string, boolean bl) {
        int n = string.length();
        boolean bl2 = Character.isUpperCase(string.charAt(0));
        if (bl && bl2 && n > 1) {
            bl2 = Character.isUpperCase(string.charAt(1));
        }
        if (bl2) {
            for (int i = string.length() - 1; i > 0; --i) {
                if (!Character.isLowerCase(string.charAt(i))) continue;
                return true;
            }
        } else {
            for (int i = string.length() - 1; i > 0; --i) {
                if (!Character.isUpperCase(string.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean fireAndHandleEvent(WordTokenizer wordTokenizer, SpellCheckEvent spellCheckEvent) {
        this.fireSpellCheckEvent(spellCheckEvent);
        String string = spellCheckEvent.getInvalidWord();
        switch (spellCheckEvent.getAction()) {
            case -1: {
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                if (this.ignoredWords.contains(string)) break;
                this.ignoredWords.add(string);
                break;
            }
            case 2: {
                wordTokenizer.replaceWord(spellCheckEvent.getReplaceWord());
                break;
            }
            case 3: {
                String string2 = spellCheckEvent.getReplaceWord();
                if (!this.autoReplaceWords.containsKey(string)) {
                    this.autoReplaceWords.put(string, string2);
                }
                wordTokenizer.replaceWord(string2);
                break;
            }
            case 4: {
                String string3 = spellCheckEvent.getReplaceWord();
                wordTokenizer.replaceWord(string3);
                this.dictionary.addWord(string3);
                break;
            }
            case 5: {
                return true;
            }
            default: {
                throw new IllegalArgumentException("Unhandled case.");
            }
        }
        return false;
    }

    public final int checkSpelling(WordTokenizer wordTokenizer) {
        int n = 0;
        boolean bl = false;
        Object var4_4 = null;
        while (wordTokenizer.hasMoreWords() && !bl) {
            Object object;
            String string = wordTokenizer.nextWord();
            if (!this.dictionary.isCorrect(string)) {
                if (this.config.getBoolean("SPELL_IGNOREMIXEDCASE") && SpellChecker.isMixedCaseWord(string, wordTokenizer.isNewSentance()) || this.config.getBoolean("SPELL_IGNOREUPPERCASE") && SpellChecker.isUpperCaseWord(string) || this.config.getBoolean("SPELL_IGNOREDIGITWORDS") && SpellChecker.isDigitWord(string) || this.config.getBoolean("SPELL_IGNOREINTERNETADDRESS") && SpellChecker.isINETWord(string) || this.ignoredWords.contains(string)) continue;
                ++n;
                if (this.autoReplaceWords.containsKey(string)) {
                    wordTokenizer.replaceWord((String)this.autoReplaceWords.get(string));
                    continue;
                }
                object = new BasicSpellCheckEvent(string, this.dictionary.getSuggestions(string, this.config.getInteger("SPELL_THRESHOLD")), wordTokenizer);
                bl = this.fireAndHandleEvent(wordTokenizer, (SpellCheckEvent)object);
                continue;
            }
            if (this.config.getBoolean("SPELL_IGNORESENTANCECAPTILIZATION") || !wordTokenizer.isNewSentance() || !Character.isLowerCase(string.charAt(0))) continue;
            ++n;
            object = new StringBuffer(string);
            ((StringBuffer)object).setCharAt(0, Character.toUpperCase(string.charAt(0)));
            LinkedList<Word> linkedList = new LinkedList<Word>();
            linkedList.add(new Word(((StringBuffer)object).toString(), 0));
            BasicSpellCheckEvent basicSpellCheckEvent = new BasicSpellCheckEvent(string, linkedList, wordTokenizer);
            bl = this.fireAndHandleEvent(wordTokenizer, basicSpellCheckEvent);
        }
        if (bl) {
            return -2;
        }
        if (n == 0) {
            return -1;
        }
        return n;
    }
}

