/*
 * Decompiled with CFR 0.152.
 */
package com.hexidec.ekit.component;

import com.hexidec.util.Translatrix;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class FontSelectorDialog
extends JDialog
implements ItemListener {
    private Vector vcFontnames = null;
    private final JComboBox jcmbFontlist;
    private String fontName = new String();
    private JOptionPane jOptionPane;
    private final JTextPane jtpFontPreview;
    private String defaultText;

    public FontSelectorDialog(Frame frame, String string, boolean bl, String string2, String string3) {
        super(frame, string, bl);
        this.defaultText = string3 != null && string3.length() > 0 ? (string3.length() > 24 ? string3.substring(0, 24) : string3) : "aAbBcCdDeEfFgGhH,.0123";
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.vcFontnames = new Vector(stringArray.length - 5);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("Dialog") || stringArray[i].equals("DialogInput") || stringArray[i].equals("Monospaced") || stringArray[i].equals("SansSerif") || stringArray[i].equals("Serif")) continue;
            this.vcFontnames.add(stringArray[i]);
        }
        this.jcmbFontlist = new JComboBox(this.vcFontnames);
        this.jcmbFontlist.addItemListener(this);
        this.jtpFontPreview = new JTextPane();
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        HTMLDocument hTMLDocument = (HTMLDocument)hTMLEditorKit.createDefaultDocument();
        this.jtpFontPreview.setEditorKit(hTMLEditorKit);
        this.jtpFontPreview.setDocument(hTMLDocument);
        this.jtpFontPreview.setMargin(new Insets(4, 4, 4, 4));
        this.jtpFontPreview.setBounds(0, 0, 120, 18);
        this.jtpFontPreview.setText(this.getFontSampleString(this.defaultText));
        Object[] objectArray = new Object[]{string2, this.jcmbFontlist, Translatrix.getTranslationString("FontSample"), this.jtpFontPreview};
        final Object[] objectArray2 = new Object[]{Translatrix.getTranslationString("DialogAccept"), Translatrix.getTranslationString("DialogCancel")};
        this.jOptionPane = new JOptionPane(objectArray, 3, 2, null, objectArray2, objectArray2[0]);
        this.setContentPane(this.jOptionPane);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                FontSelectorDialog.this.jOptionPane.setValue(new Integer(-1));
            }
        });
        this.jOptionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (FontSelectorDialog.this.isVisible() && propertyChangeEvent.getSource() == FontSelectorDialog.this.jOptionPane && (string.equals("value") || string.equals("inputValue"))) {
                    Object object = FontSelectorDialog.this.jOptionPane.getValue();
                    if (object == JOptionPane.UNINITIALIZED_VALUE) {
                        return;
                    }
                    FontSelectorDialog.this.jOptionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                    if (object.equals(objectArray2[0])) {
                        FontSelectorDialog.this.fontName = (String)FontSelectorDialog.this.jcmbFontlist.getSelectedItem();
                        FontSelectorDialog.this.setVisible(false);
                    } else {
                        FontSelectorDialog.this.fontName = null;
                        FontSelectorDialog.this.setVisible(false);
                    }
                }
            }
        });
        this.pack();
        this.show();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.jtpFontPreview.setText(this.getFontSampleString(this.defaultText));
        }
    }

    public FontSelectorDialog(Frame frame, String string, boolean bl, String string2) {
        this(frame, string, bl, string2, "");
    }

    public String getFontName() {
        return this.fontName;
    }

    private String getFontSampleString(String string) {
        return "<HTML><BODY><FONT FACE=\"" + this.jcmbFontlist.getSelectedItem() + '\"' + ">" + string + "</FONT></BODY></HTML>";
    }
}

