/*
 * Decompiled with CFR 0.152.
 */
package com.hexidec.ekit.component;

import com.hexidec.ekit.EkitCore;
import com.hexidec.util.Translatrix;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.text.BadLocationException;

public class UnicodeDialog
extends JDialog
implements ActionListener {
    public static final int UNICODE_BASE = 0;
    public static final int UNICODE_SIGS = 47;
    public static final int UNICODE_SPEC = 48;
    public static final int UNICODE_MATH = 49;
    public static final int UNICODE_DRAW = 54;
    public static final int UNICODE_DING = 56;
    private static final int UNICODEBLOCKSIZE = 256;
    private static final String CMDCHANGEBLOCK = "changeblock";
    private static final String[] unicodeBlocks = new String[]{"Basic Latin & Latin-1 Supplement", "Latin Extended-A", "Latin Extended-B", "IPA Extensions", "Spacing Modifier Letters", "Combining Diacritical Marks", "Greek and Coptic", "Cyrillic", "Cyrillic Supplement", "Armenian", "Hebrew", "Arabic", "Syriac", "Thaana", "Devanagari", "Bengali", "Gurmukhi", "Gujarati", "Oriya", "Tamil", "Telugu", "Kannada", "Malayalam", "Sinhala", "Thai", "Lao", "Tibetan", "Myanmar", "Georgian", "Hanjul Jamo", "Ethiopic", "Cherokee", "Unified Canadian Aboriginal Syllabics", "Ogham", "Runic", "Tagalog", "Hanunoo", "Buhid", "Tagbanwa", "Khmer", "Mongolian", "Limbu", "Tai Le", "Khmer Symbols", "Phonetic Extensions", "Latin Extended Additional", "Greek Extended", "Punctuation / Scripts / Currency / Diacriticals", "Letterlike Symbols / Number Forms / Arrows", "Mathematical Operators", "Miscellaneous Technical", "Control Pictures", "Optical Character Recognition", "Enclosed Alphanumerics", "Box Drawing / Block Elements / Geometric Shapes", "Miscellaneous Symbols", "Dingbats / Math-A / Arrows-A", "Braille Patterns", "Arrows-B / Math-B", "Supplemental Mathematical Operators", "Miscellaneous Symbols and Arrows", "CJK Radicals Supplement", "Kangxi Radicals", "Ideographic Description Characters", "CJK Symbols and Punctuation", "Hiragana", "Katakana", "Bopomofo", "Hangul Compatibility Jamo", "Kanbun", "Bopomofo Extended", "Katakana Phonetic Extensions", "Enclosed CJK Letters and Months", "CJK Compatibility", "CJK Unified Ideographs Extension A", "Yijing Hexagram Symbols", "CJK Unified Ideographs", "Yi Syllables", "Yi Radicals", "Hangul Symbols", "RESERVED AREA: High Surrogates", "RESERVED AREA: Low Surrogates", "RESERVED AREA: Private Use", "CJK Compatibility Ideographs", "Alphabetic Presentation Forms", "Arabic Presentation Forms-A", "Variation Selectors", "Combining Half Marks", "CJK Compatibility Forms", "Small Form Variants", "Arabic Presentation Forms-B", "Halfwidth and Fullwidth Forms", "Specials"};
    private final int[] unicodeBlockStart = new int[]{0, 256, 384, 592, 688, 768, 880, 1024, 1280, 1328, 1424, 1536, 1792, 1920, 2304, 2432, 2560, 2688, 2816, 2944, 3072, 3200, 3328, 3456, 3584, 3712, 3840, 4096, 4256, 4352, 4608, 5024, 5120, 5760, 5792, 5888, 5920, 5952, 5984, 6016, 6144, 6400, 6480, 6624, 7424, 7680, 7936, 8192, 8448, 8704, 8960, 9216, 9280, 9312, 9472, 9728, 9984, 10240, 10496, 10752, 11008, 11904, 12032, 12272, 12288, 12352, 12448, 12544, 12592, 12688, 12704, 12784, 12800, 13056, 13312, 19904, 19968, 40960, 42128, 44032, 55296, 56320, 57344, 63744, 64256, 64336, 65024, 65056, 65072, 65104, 65136, 65280, 65520};
    private final int[] unicodeBlockEnd = new int[]{255, 383, 591, 687, 767, 879, 1023, 1279, 1327, 1423, 1535, 1791, 1871, 1983, 2431, 2559, 2687, 2815, 2943, 3071, 3199, 3327, 3455, 3583, 3711, 3839, 4095, 4255, 4351, 4607, 4991, 5119, 5759, 5791, 5887, 5919, 5951, 5983, 6015, 6143, 6319, 6479, 6527, 6655, 7551, 7935, 8191, 8447, 8703, 8959, 9215, 9279, 9311, 9471, 9727, 9983, 10239, 10495, 10751, 11007, 11263, 12031, 12255, 12287, 12351, 12447, 12543, 12591, 12687, 12703, 12735, 12799, 13055, 13311, 19903, 19967, 40879, 42127, 42191, 55215, 56319, 57343, 63743, 64255, 64335, 65023, 65039, 65071, 65103, 65135, 65279, 65519, 65535};
    private EkitCore parentEkit;
    private Font buttonFont;
    private JToggleButton[] buttonArray = new JToggleButton[256];
    private ButtonGroup buttonGroup;
    private JComboBox jcmbBlockSelector;
    private JComboBox jcmbPageSelector;

    public UnicodeDialog(EkitCore ekitCore, String string, boolean bl, int n) {
        super(ekitCore.getFrame(), string, bl);
        this.parentEkit = ekitCore;
        this.init(n);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(CMDCHANGEBLOCK)) {
            this.populateButtons(this.jcmbBlockSelector.getSelectedIndex(), this.jcmbPageSelector.getSelectedIndex());
        } else if (actionEvent.getActionCommand().equals("close")) {
            this.setVisible(false);
            this.dispose();
        } else if (!actionEvent.getActionCommand().equals("")) {
            try {
                this.parentEkit.insertUnicodeChar(actionEvent.getActionCommand());
            }
            catch (IOException iOException) {
                System.out.println("IOException during character insertion : " + iOException.getMessage());
            }
            catch (BadLocationException badLocationException) {
                System.out.println("BadLocationException during character insertion : " + badLocationException.getMessage());
            }
        }
    }

    public void init(int n) {
        Object object;
        Object object2;
        int n2;
        String string = Translatrix.getTranslationString("UnicodeDialogButtonFont");
        this.buttonFont = string != null && string.length() > 0 ? new Font(Translatrix.getTranslationString("UnicodeDialogButtonFont"), 0, 12) : new Font("Monospaced", 0, 12);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(1);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 17, 0, 0));
        this.buttonGroup = new ButtonGroup();
        int n3 = 32;
        int n4 = 32;
        jPanel.add(new JLabel(""));
        for (n2 = 0; n2 < 16; ++n2) {
            JLabel jLabel = new JLabel("x" + (n2 > 9 ? "" + (char)(65 + (n2 - 10)) : "" + n2));
            jLabel.setHorizontalAlignment(0);
            jLabel.setVerticalAlignment(0);
            jLabel.setForeground(new Color(0.5f, 0.5f, 0.75f));
            jPanel.add(jLabel);
        }
        n2 = 0;
        for (int i = 0; i < 256; ++i) {
            if (i % 16 == 0) {
                object2 = new JLabel((n2 > 9 ? "" + (char)(65 + (n2 - 10)) : "" + n2) + "x");
                object2.setHorizontalAlignment(0);
                object2.setVerticalAlignment(0);
                object2.setForeground(new Color(0.5f, 0.5f, 0.75f));
                jPanel.add((Component)object2);
                ++n2;
            }
            this.buttonArray[i] = new JToggleButton(" ");
            this.buttonArray[i].getModel().setActionCommand("");
            this.buttonArray[i].setFont(this.buttonFont);
            this.buttonArray[i].setBorder(BorderFactory.createEtchedBorder(1));
            this.buttonArray[i].addActionListener(this);
            if (i == 0) {
                object2 = ((Graphics2D)this.parentEkit.getGraphics()).getFontRenderContext();
                object = this.buttonFont.getMaxCharBounds((FontRenderContext)object2);
                int n5 = (int)Math.abs(((RectangularShape)object).getX()) + (int)Math.abs(((RectangularShape)object).getWidth());
                int n6 = (int)Math.abs(((RectangularShape)object).getY()) + (int)Math.abs(((RectangularShape)object).getHeight());
                Insets insets = this.buttonArray[i].getBorder().getBorderInsets(this.buttonArray[i]);
                n3 = n5 + insets.left + insets.right;
                n4 = n6 + insets.top + insets.bottom;
            }
            this.buttonArray[i].setPreferredSize(new Dimension(n3, n4));
            jPanel.add(this.buttonArray[i]);
            this.buttonGroup.add(this.buttonArray[i]);
        }
        JPanel jPanel2 = new JPanel();
        this.jcmbBlockSelector = new JComboBox<String>(unicodeBlocks);
        this.jcmbBlockSelector.setSelectedIndex(n);
        this.jcmbBlockSelector.setActionCommand(CMDCHANGEBLOCK);
        this.jcmbBlockSelector.addActionListener(this);
        object2 = new String[]{"1"};
        this.jcmbPageSelector = new JComboBox<String>((E[])object2);
        this.jcmbPageSelector.setSelectedIndex(0);
        this.jcmbPageSelector.setActionCommand(CMDCHANGEBLOCK);
        this.jcmbPageSelector.addActionListener(this);
        jPanel2.add(new JLabel(Translatrix.getTranslationString("SelectorToolUnicodeBlock")));
        jPanel2.add(this.jcmbBlockSelector);
        jPanel2.add(new JLabel(Translatrix.getTranslationString("SelectorToolUnicodePage")));
        jPanel2.add(this.jcmbPageSelector);
        object = new JPanel();
        JButton jButton = new JButton(Translatrix.getTranslationString("DialogClose"));
        jButton.setActionCommand("close");
        jButton.addActionListener(this);
        ((Container)object).add(jButton);
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel2, "North");
        container.add((Component)object, "South");
        this.pack();
        this.populateButtons(n, 0);
        this.setVisible(true);
    }

    private void populateButtons(int n, int n2) {
        int n3;
        int n4 = this.unicodeBlockEnd[n] / 256 - this.unicodeBlockStart[n] / 256 + 1;
        if (n4 != this.jcmbPageSelector.getItemCount()) {
            this.jcmbPageSelector.setActionCommand("");
            this.jcmbPageSelector.setEnabled(false);
            this.jcmbPageSelector.removeAllItems();
            for (n3 = 0; n3 < n4; ++n3) {
                this.jcmbPageSelector.addItem("" + (n3 + 1));
            }
            this.jcmbPageSelector.setEnabled(true);
            this.jcmbPageSelector.update(this.getGraphics());
            this.jcmbPageSelector.setActionCommand(CMDCHANGEBLOCK);
        }
        if (n2 > this.jcmbPageSelector.getItemCount() - 1) {
            n2 = 0;
        }
        int n5 = n3 = this.unicodeBlockStart[n] / 256 * 256 + n2 * 256;
        for (int i = 0; i < 256; ++i) {
            n5 = n3 + i;
            this.buttonArray[i].setSelected(false);
            if (n5 < this.unicodeBlockStart[n] || n5 > this.unicodeBlockEnd[n]) {
                this.buttonArray[i].setText(" ");
                this.buttonArray[i].getModel().setActionCommand(" ");
                this.buttonArray[i].setEnabled(false);
                this.buttonArray[i].setVisible(false);
                continue;
            }
            char c = (char)n5;
            String string = Character.toString(c);
            if (this.buttonFont.canDisplay(c)) {
                this.buttonArray[i].setText(string);
            } else {
                this.buttonArray[i].setText(" ");
            }
            this.buttonArray[i].getModel().setActionCommand(string);
            this.buttonArray[i].setEnabled(true);
            this.buttonArray[i].setVisible(true);
            this.buttonArray[i].update(this.getGraphics());
        }
    }
}

