#include "globals.h"
#include "view.h"

view v,cv;

int GetLogicalCamera(void) {
  if(camera==CAMERA_AUTO)
    switch(state) {
      case STATE_CUE: return CAMERA_FAR;
      case STATE_END: return CAMERA_FLYBY;
      default: return CAMERA_OVERVIEW;
    }
  else
    return camera;
}

void SetView(void) {
  double dist=0.0,height=0.0;
  int lcam=GetLogicalCamera();
  switch(lcam) {
    case CAMERA_OVERVIEW:
         v.ex= 0.0; v.ey= 0.0; v.ez=-2.7;
         v.cx= 0.0; v.cy= 0.0; v.cz= 0.0;
         v.ux= 0.0; v.uy= 1.0; v.uz= 0.0;
         return;
    case CAMERA_FLYBY:
         v.ex= 2.5*sin(0.3*t);
         v.ey= 2.5*cos(0.3*t);
         v.ez=-1.0;
         v.cx= 0.0; v.cy= 0.0; v.cz= 0.0;
         v.ux= 0.0; v.uy= 0.0; v.uz=-1.0;
         return;
    default:
        dist=CamDist[lcam]*cos(CamHeight[lcam]);
      height=CamDist[lcam]*sin(CamHeight[lcam]);
  }
  if(state!=STATE_ROLLING) {
    double a=cue_angle*M_PI/180.0;
    v.ex=balls[0].px+dist*cos(a); v.ey=balls[0].py+dist*sin(a); v.ez=-height;
    v.cx=balls[0].px;             v.cy=balls[0].py;             v.cz= 0.0;
    v.ux=0.0;                     v.uy=0.0;                     v.uz=-1.0;
  } else if(moving&balls[0].bit) {
    double n=sqrt(sqr(balls[0].vx)+sqr(balls[0].vy));
    if(n<0.0001) n=0.0; else n=dist/n;
    if(fabs(n)>100.0) n=0.0;
    v.ex=balls[0].px-balls[0].vx*n; v.ey=balls[0].py-balls[0].vy*n; v.ez=-height;
    v.cx=balls[0].px;               v.cy=balls[0].py;               v.cz= 0.0;
    v.ux=0.0;                       v.uy=0.0;                       v.uz=-1.0;
  } else {
    int i,fastest=0;
    double vmax=0.0;
    double dx,dy,n;
    for(i=1; i<16; ++i)
      if(balls[i].active) {
        double v=sqr(balls[i].vx)+sqr(balls[i].vy);
        if(v>vmax) {
          vmax=v;
          fastest=i;
        }
      }
    dx=balls[fastest].px-balls[0].px;
    dy=balls[fastest].py-balls[0].py;
    n=sqrt(sqr(dx)+sqr(dy));
    if(n<0.0001) n=0.0; else n=dist/n;
    if(fabs(n)>100.0) n=0.0;
    v.ex=balls[0].px-dx*n; v.ey=balls[0].py-dy*n; v.ez=-height;
    v.cx=balls[0].px;      v.cy=balls[0].py;      v.cz= 0.0;
    v.ux=0.0;              v.uy=0.0;              v.uz=-1.0;
  }
}


void UpdateView(void) {
  double fc,fv;
  fv=dt*CameraSpeed;
  if(fv>1.0) fv=1.0;
  fc=1.0-fv;
  cv.ex=fc*cv.ex+fv*v.ex; cv.ey=fc*cv.ey+fv*v.ey; cv.ez=fc*cv.ez+fv*v.ez;
  cv.cx=fc*cv.cx+fv*v.cx; cv.cy=fc*cv.cy+fv*v.cy; cv.cz=fc*cv.cz+fv*v.cz;
  cv.ux=fc*cv.ux+fv*v.ux; cv.uy=fc*cv.uy+fv*v.uy; cv.uz=fc*cv.uz+fv*v.uz;
}

void ApplyView(void) {
  gluLookAt(cv.ex,cv.ey,cv.ez, cv.cx,cv.cy,cv.cz, cv.ux,cv.uy,cv.uz);
}

void InitView(void) {
  cprintf(" View");
  CamDist[0]=DefaultNearCamDist;
  CamHeight[0]=DefaultNearCamHeight;
  CamDist[1]=DefaultFarCamDist;
  CamHeight[1]=DefaultFarCamHeight;
  camera=CAMERA_OVERVIEW;
  SetView(); cv=v;
}
