#include "globals.h"
#include "text.h"
#include "locale.h"

static double msg_t;
static int msg_type;

void OverlayBegin(void) {
  glDisable(GL_LIGHTING);
  glDisable(GL_TEXTURE_2D);
  glDisable(GL_DEPTH_TEST);
  glMatrixMode(GL_PROJECTION);
  glPushMatrix();
  glLoadIdentity();
  glOrtho(0.0,win_width,win_height,0.0,-1.0,1.0);
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glLoadIdentity();
}

void OverlayEnd(void) {
  glDisable(GL_TEXTURE_2D);
  glEnable(GL_LIGHTING);
  glEnable(GL_DEPTH_TEST);
  glDisable(GL_BLEND);
  glMatrixMode(GL_PROJECTION);
  glPopMatrix();
  glMatrixMode(GL_MODELVIEW);
  glPopMatrix();
}

void DrawTextGL(int x, int y, void *font, unsigned char *text) {
  glRasterPos2i(x,y);
  while(*text) {
    if(x<0) {
      x+=glutBitmapWidth(font,*text);
      glRasterPos2i(x,y);
    } else
      glutBitmapCharacter(font,*text);
    ++text;
  }
}

void DrawBoldTextGL(int x, int y, void *font, unsigned char *text) {
  unsigned char bold[256],*pos;
  strcpy(bold,text);
  pos=strchr(bold,'\t');
  if(pos) *pos=0;
  DrawTextGL(x,y,font,text);
  DrawTextGL(x+1,y,font,bold);
}

int TextWidthGL(void *font, unsigned char *text) {
  int res=0;
  while(*text) res+=glutBitmapWidth(font,*text++);
  return res;
}

void DrawRightTextGL(int x, int y, void *font, unsigned char *text) {
  DrawTextGL(x-TextWidthGL(font,text),y,font,text);
}

void DrawCenteredTextGL(int x, int y, void *font, unsigned char *text) {
  DrawTextGL(x-(TextWidthGL(font,text)+1)/2,y,font,text);
}


static void InitBox(box *b, char **lines) {
  char **line;
  b->width=0; b->height=56;
  for(line=lines; *line; ++line) {
    int w=TextWidthGL(GLUT_BITMAP_HELVETICA_12,*line);
    if(w>b->width) b->width=w;
    b->height+=16;
  }
  b->width+=30;
  b->pos=0; b->dest=0;
  b->active=0;
}

void InitText(void) {
  cprintf(" Text");
  InitBox(&BHelp,HelpText);
  InitBox(&BRules,RulesText);
  SetMessage(MSG_WELCOME);
}


void SetMessage(int type) {
  msg_t=t+MessageTimeout;
  msg_type=type;
}

void DrawMessage(void) {
  double trans=msg_t-t;
  if(trans<0.0) return;
  if(trans>1.0) trans=1.0;
  glEnable(GL_BLEND);
  glBlendFunc(GL_ONE,GL_ONE);
  glColor3d(trans,trans,trans);
  if(msg_type&MSG_END_GAME_BIT) {
    char msg[256];
    strcpy(msg,PlayerNames[player]);
    strcat(msg,Messages[msg_type&MSG_MASK]);
    DrawTextGL(10,24,GLUT_BITMAP_HELVETICA_18,msg);
    return;
  }
  switch(msg_type) {
    case MSG_WELCOME:
      DrawTextGL(10,24,GLUT_BITMAP_HELVETICA_18,IntroText0);
      DrawTextGL(10,42,GLUT_BITMAP_HELVETICA_10,IntroText1);
      DrawRightTextGL(win_width-8,20,GLUT_BITMAP_HELVETICA_12,Version);
      break;
    default:
      if(msg_type>=0 && msg_type<MessageCount)
        DrawTextGL(10,24,GLUT_BITMAP_HELVETICA_18,Messages[msg_type]);
  }
}


static int BeginDrawBox(box *b) {
  int base=b->pos-b->width;
  glEnable(GL_BLEND);
  SetColor(0x808080);
  glBlendFunc(GL_ZERO,GL_ONE_MINUS_SRC_COLOR);
  glBegin(GL_QUADS);
    glVertex2i(base+10,10);
    glVertex2i(base+10,b->height);
    glVertex2i(base+b->width,b->height);
    glVertex2i(base+b->width,10);
  glEnd();
  glDisable(GL_BLEND);
  SetColor(0xFFFFFF);
  return base;
}

void DrawHelp(void) {
  int y=58,base=BeginDrawBox(&BHelp);
  char **line;
  DrawTextGL(base+20,36,GLUT_BITMAP_HELVETICA_18,HelpTitle);
  for(line=&HelpText[0]; *line; ++line) {
    DrawBoldTextGL(base+20,y,GLUT_BITMAP_HELVETICA_12,*line);
    y+=16;
  }
}

void DrawRules(void) {
  int y=58,base=BeginDrawBox(&BRules);
  char **line;
  int rules_bit=1;
  DrawTextGL(base+20,36,GLUT_BITMAP_HELVETICA_18,RulesTitle);
  for(line=&RulesText[0]; *line; ++line) {
    DrawTextGL(base+20,y,GLUT_BITMAP_HELVETICA_12,*line);
    if(rules&rules_bit)
      DrawCenteredTextGL(base+50,y,GLUT_BITMAP_HELVETICA_12,RuleOn);
    else
      DrawCenteredTextGL(base+50,y,GLUT_BITMAP_HELVETICA_12,RuleOff);
    y+=16; rules_bit<<=1;
  }
}


void ToggleBox(box *b) {
  b->active^=1;
  b->dest=((b->active)?b->width:0);
}

void UpdateBox(box *b) {
  if(b->pos==b->dest) return;
  if(b->pos<b->dest) {
    b->pos+=3;
    if(b->pos>b->dest)
      b->pos=b->dest;
  } else {
    b->pos-=3;
    if(b->pos<b->dest)
      b->pos=b->dest;
  }
}


static void DrawBallSprite(int x, int y, int i) {
  double x0=0.25*(i&3);
  double y0=0.25*(i>>2);
  glTexCoord2d(x0,     y0);       glVertex2i(x   ,y);
  glTexCoord2d(x0,     y0+0.25);  glVertex2i(x,   y+32);
  glTexCoord2d(x0+0.25,y0+0.25);  glVertex2i(x+32,y+32);
  glTexCoord2d(x0+0.25,y0);       glVertex2i(x+32,y);
}


void DrawStats(void) {
  int i;
  glEnable(GL_BLEND);
  glBlendFunc(GL_ONE,GL_ONE);
  if(player) SetColor(0x0040C0); else SetColor(0xFFFFFF);
  DrawRightTextGL(win_width-34,win_height-32,GLUT_BITMAP_HELVETICA_18,PlayerNames[0]);
  if(player) SetColor(0xFFFFFF); else SetColor(0x0040C0);
  DrawRightTextGL(win_width-34,win_height-10,GLUT_BITMAP_HELVETICA_18,PlayerNames[1]);
  glEnable(GL_TEXTURE_2D);
  glBindTexture(GL_TEXTURE_2D,TEX_BALLS);
  glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
  SetColor(0xC0FFFFFF);
  glBegin(GL_QUADS);
  if(preference>0) {
    DrawBallSprite(win_width-28,win_height-50,preference);
    DrawBallSprite(win_width-28,win_height-28,preference^8);
  }
  for(i=0; i<16; ++i)
    if(balls[i].active)
      DrawBallSprite(8+(i&7)*24,win_height-52+(i>>3)*24,i);
  glEnd();
}
