program texconv;
{$APPTYPE CONSOLE}
uses SysUtils,Graphics;

const TexCount=15;

var UBuff,CBuff:array of byte;
    Width,Height:integer;

procedure LoadTextures;
var BMP:TBitmap;
    X,Y,i:integer; L:PByteArray;
    Pi,Po:^byte;
begin
  SetLength(UBuff,0);
  Width:=0; Height:=0;
  for i:=1 to 15 do begin
    BMP:=TBitmap.Create;
    BMP.LoadFromFile('tex'+char(48+i DIV 10)+char(48+i MOD 10)+'.bmp');

    Width:=BMP.Width;
    inc(Height,BMP.Height);

    X:=length(UBuff);
    SetLength(UBuff,X+BMP.Width*BMP.Height);
    Po:=@UBuff[X];

    for Y:=0 to BMP.Height-1 do begin
      L:=BMP.ScanLine[Y]; Pi:=@L[0];
      for X:=0 to Width-1 do begin
        Po^:=(Pi^ SHR 5) XOR 7;
        inc(Po); inc(Pi);
      end;
    end;

    BMP.Free;
  end;
end;

procedure Compress;
var Ci,Co:integer;
    ntV,ntL:integer;
begin
  SetLength(CBuff,length(UBuff));
  Ci:=0; Co:=0;
  while Ci<length(UBuff) do begin
    if ((UBuff[Ci]  <>0) AND (UBuff[Ci]  <>7)) OR
       ((UBuff[Ci+1]<>0) AND (UBuff[Ci+1]<>7)) then begin
      CBuff[Co]:=128 OR (UBuff[Ci] SHL 4) OR UBuff[Ci+1];
      inc(Co); inc(Ci,2);
    end else begin
      ntV:=UBuff[Ci]; ntL:=1;
      while (ntL<64) AND (Ci+ntL<length(UBuff)) AND (UBuff[Ci+ntL]=ntV) do
        inc(ntL);
      CBuff[Co]:=(((ntL-1) SHL 1) OR (ntV AND 1)) XOR $7F;
      inc(Co); inc(Ci,ntL);
    end;
  end;
  SetLength(CBuff,Co);
end;

procedure SaveCompressed;
const hex:array[0..15]of char='0123456789ABCDEF';
var t:system.text;
    C,V:integer;
    s:string;
    LastHex:boolean;
  procedure WriteLine; begin write(t,^M^J#34,s,#34); s:=''; LastHex:=false; end;
  procedure HexToken; begin s:=s+'\x'+hex[V SHR 4]+hex[V AND 15]; LastHex:=true; end;
begin
  Assign(t,'tex.inc.txt');
  Rewrite(t);
  writeln(t,'#define TC_TexWidth ',Width);
  writeln(t,'#define TC_TexHeight ',Height);
  writeln(t,'#define TC_TexSize ',length(CBuff));
  write(t,'unsigned char* TC_TexData=');
  s:=''; LastHex:=false;
  for C:=0 to length(CBuff)-1 do begin
    if length(s)>=247 then WriteLine;
    V:=CBuff[C];
    case V of
      0..31:HexToken;
      34:begin s:=s+'\"'; LastHex:=false; end;
      92:begin s:=s+'\\'; LastHex:=false; end;
    else
      if V>=127 then HexToken else
      if LastHex AND (V IN [48..57,65..70,97..102]) then HexToken else
      begin s:=s+char(V); LastHex:=false; end;
    end;
  end;
  if length(s)>0 then WriteLine;
  writeln(t,';');
  CloseFile(t);
end;

procedure Uncompress;
var Ci,Co:integer;
    ntV,ntL:integer;
begin
  FillChar(UBuff[0],Width*Height,$FF);
  Ci:=0; Co:=0;
  while Co<length(UBuff) do begin
    ntV:=CBuff[Ci]; inc(Ci);
    if (ntV AND 128=0) then begin
      ntV:=ntV XOR $7F;
      ntL:=(ntV SHR 1)+1;
      if (ntV AND 1<>0) then ntV:=7 else ntV:=0;
      while ntL>0 do begin
        UBuff[Co]:=ntV; inc(Co); dec(ntL);
      end;
    end else begin
      UBuff[Co]  :=(ntV SHR 4) AND 7;
      UBuff[Co+1]:= ntV        AND 7;
      inc(Co,2);
    end;
  end;
end;

procedure SaveUncompressed;
var BMP:TBitmap;
    X,Y,i:integer; L:PByteArray;
    Pi,Po:^byte;
begin
  BMP:=TBitmap.Create;
  BMP.Width:=Width;
  BMP.Height:=Height;
  BMP.PixelFormat:=pf24bit;
  Pi:=@UBuff[0];
  for Y:=0 to Height-1 do begin
    L:=BMP.ScanLine[Y]; Po:=@L[0];
    for X:=0 to Width-1 do begin
      i:=(Pi^ SHL 5) OR (Pi^ SHL 2) OR (Pi^ SHR 1); inc(Pi);
      Po^:=i; inc(Po);
      Po^:=i; inc(Po);
      Po^:=i; inc(Po);
    end;
  end;
  BMP.SaveToFile('tex.out.bmp');
  BMP.Free;
end;

begin
  LoadTextures;
  Compress;
  SaveCompressed;
  Uncompress;
  SaveUncompressed;
end.
