#include "globals.h"
#include "tex.h"

#define TC_TexWidth 42
#define TC_TexHeight 540
#define TC_TexSize 2352
unsigned char* TC_TexData=
"\x0D\x97pA\xC7pC\x97nC\xC7nE\x97lE\xC7lG\x97j9t9t9t9t9t9t9t9t9t9t9t9t9t9t9t9t9t9t9t9t9t9t9t\x01\x01\x01\x1B\x94\xD6x\xE4\xA0I\x95j\xE3M\xB7\x64\xD0S\xC7`\xE0W\xA7\\\xC0Y\xE7Z\x90]\xA7r\xD1}\xC7r\xC0]\xC7t\xD0y\xC7t\xE0]\xE7t\xA0y\x97r[psp[pu\x97r?"
"\xB7t\xD0\x41p\xB0\x43\xD7rA\xB7r\xB0\x45\xA7r\xD0\x45\x97r\xE0\x43\xE7r\x90\x45\xD7r\x90\x45\xC7r\x90\x45\xB7r\xA0\x45\xA7r\xA0\x45\x97r\xB0\x43\xE7t\xB0\x43\xD7`\xD0W\xC7^\xD0Y\xB7\\\xD0[\xA7Z\xD0]\x97X\xD0]\xE7X\xD0_\xD7V\xD0\x01\x01\x01-\xB5\xE7"
"z\xE5\xB0G\xC7j\xC0O\x97\x64\xE0S\x97`\xD0U\xE7^\xA0Y\xA7\\\xD0Y\xD7t\xB0\x82nW\xE7v\xC0{\xA7rWr\xA0yp=r\xD0\x41\xB7t\xA0\x43\xB7t\xC0\x45n\xB0\x43r\xC0?p\xE2\x41l\xD0\x45j\xC0\x43\x95p\x90\x41\xD7t\xC0\x41\x97t\xE0]psp[psp[\xE7t\x90y\x97r[\xC7t\xD0"
"y\xC7t\xD0]\xA7r\xC0\x81\xC7r\xB0[\xE7ZW\xA7\\\xB0W\xB7`\xC0S\xB7\x64\xC0O\x95j\xE1G\x94\xD6x\xD4\x90\x01\x01\x01\x01\x43\xE7rA\xC7pC\xA7nC\xE7nE\xC7lG\xA7jG\xE7x\xB7vI\xC7x\xE0tK\xA7v\xA0tKt\xC0\x7FtM\xC7x\xE0}tO\xA7v\x90}tOt\xC0{tQ\xD7x\xE0ytS\xA7"
"v\x90ytSt\xB0wtU\xD7x\xE0utUP]P]P]P]P]P]PAt9t9t9t9t9t\x01\x01\x01\x01S\xC7\x62O\xD7\x62O^O^Q\x97`Q\xA7`Q\xB7`Q\xD7x\xB0=\xE7x\xA0=t\x90=t;\xA7v\xD6x\xD4\x90O\xB7\x64\xD1Q\xC7`\xA0U\xD7^\x90W\xE7\xE3\x90}\x92\xE7r\xE0W\xC3o\xB7r\xA0\x41\xC7t\xD0\x41"
"\x97t\xE0?pY\xC2ipY\xC7\x90o\xB7rY\xD7\xF2q\xA7r\xD0[\xD7|\xE3\x90}\xA5n\xB0[\xE7ZW\xE7\\\xB0YZ\xC0W\xE7`\xB0S\xB6\x66\xD1K\x93\xD6v\xE4\xB0\x01\x01\x01\x01G\xD7t\xC0\x43\xA7t\xE0\x43\x97r\x90\x43\xE7t\xA0\x43\xC7t\xC0\x43\xA7t\xD0\x41\xE7v\xE0\x41"
"\xC7t\x90\x43\x97t\xB0\x41\xE7t\xE7|\xE5\xA0O\xA7\x64\xE1Q\xE7`\x90W\xB7\\\x90Y\xE7\\\xD0[\x97t\xE2}\xA6p\x90]\xC7tup\xC0]\xD7v\xB0w\xB7t\xE0]r\x90w\x97r[rqp[rqp[r\x90w\x97r[\xE7v\xB0w\xB7t\xD0]\xC7tup\xC0]\x97t\xE2}\xA6p\x90[\xE7\\\xD0Y\x97\\\x90"
"W\xB7`\xA0S\xB7\x64\xA0O\x95j\xC0G\x94\xD6z\xE5\xB0\x01%XWTWX\x01\x7FP]P]R\xC0_R[T\xC0]T\x90]V\xC0\x41\xD7t\x90\x43\xA7t\xD0\x41\xD7t\xA0\x43\xA7t\xE0\x41\xD7t\xA0\x43\xA7t\xE0\x41\xD7t\xB0\x43\xA7r?\xD7t\xB0\x43\xA7r?\xD7t\xC0\x43\xA7r?\xD7t\xC0\x43"
"\xA7r?\xD7t\xC0\x43\xA7r\x90\x43\xD7t\xD0\x43\xA7r\x90\x43\xD7t\xD0\x43\xA7r\xA0\x43\xD7t\xE0\x43\xA7r\xA0\x43\xD7t\xE0\x01\x01\x01\x19\xA4\xE7x\xE4\xA0I\xB7h\xB0O\xE7\x64\xD0S\xD7`\xD0W\xA7\\\xA0Y\xD7t\xB0}\xB7t\xD0Yr\xB0y\xA7tWrsrWrsrW\xD7v\xB0y"
"\xB7v\xD0Y\x97t\xB0}\xB7t\x90W\xA7`\xA0S\x94\x66\xC1K\xB7l\xB0M\xC7\x64\xC0S\xE7`\xE0W\xC7t\xD1\x81\xD7t\xC0[\x97t\xD0y\xD7t\x90]\xC7t\xA0y\xA7t\xC0]\xE7tsr\xE0]psp[psp[p\xA0y\xA7r[\xE7t\xE0y\xD7t\xE0]\xC7r\xD1\x81\xD7r\xC0]\x97X\x90[\xD7\\\xD0W\xE7"
"`\xE0S\xE7\x64\xE0O\xB7h\xB0I\xA4\xE7x\xE4\xA0\x01\x01\x01\x1F\xB5\xE7|\xE5\xB1\x45\xC7l\xD1M\xA7\x64\xA0S\xA7`\xA0W\x97\\\x90Y\xD7\\\xD0[\x97r\xE2}\xA6r\x90]\xB7rur\xC0]\xD7t\xB0w\xB7v\xE0]p\x90w\x97t[pqr[pqr[p\x90w\x97t[\xE7t\xB0w\xB7v\xE0]\xC7r"
"ur\xC0]\x97r\xE2}\xA6r\xA0[\xD7ZW\x97\\\xC0W\x97^Q\x96\x62\xC0O\xA5\xE7|\xE7r?\xA7t\xB0\x41r\xE0\x41\xD7t\x90\x43\xB7t\xC0\x43\x97t\xE0\x41\xE7t\x90\x43\xC7t\xC0\x43\xA7t\xE0\x41p\xA0\x43\xD7t\xC0\x01!XWTWX9\xA4\xE7z\xE5\xA0m\x97po\xA6l\xE2o\xC7pq"
"\xB7\x66\xC0u\x97ns\xB7\x62\xB0w\xC7nu\x97^\xA0{\x97lu\xE7^\xE0{\xC7lw\xA7t\xE1}\x96r\xA0\x81hw\xD7t\x90{\x97t\xD0qtwr\xE0w\xE7toty\xA7t\xB0w\xC7t\xA0sty\xC7t\xA0w\xA7t\xC0sty\xD7t\x90w\x97t\xD0sty\xE7t\x90w\x97t\xE0stypqpqtypqpqtypqpqtypqpqtypqpq"
"ty\xE7t\x90w\x97t\xE0sty\xD7t\x90w\x97t\xE0sty\xC7t\xA0w\xA7t\xC0sty\xA7t\xC0w\xC7t\xB0stwr\xE0w\xE7t\x90stw\xD7t\x90{\x97t\xE0qtw\xA7t\xE1}\x96r\xB0qtu\xE7^\xE0otu\x97^\xA0ots\xB7\x62\xB0mtq\xB7\x66\xC0kto\xA6l\xE2gtk\xA4\xE7z\xE5\xA0\x01\x01\x01"
"\x01m\x97pu\x97pa\xC7pu\xC7pc\x97nw\x97nc\xC7nw\xC7ne\x97ly\x97le\xC7ly\xC7lg\x97j{\x97jYtmtYtmtYtmtYtmtYtmtYtmtYtmtYtmtYtmtYtmtYtmtYtmtYtmtYtmtYtmtYtmtYtmtYtmtYtmtYtmtYtmtYtmtYtmt\x01\x01\x01\x1B\x94\xD6x\xE4\xA0o\x97po\x95j\xE3q\xC7pq\xB7\x64\xD0"
"w\x97ns\xC7`\xE0y\xC7nu\xA7\\\xC0}\x97lu\xE7Z\x90\x84jw\xA7r\xD1}\xC7r\xC0\x97jw\xC7t\xD0y\xC7t\xE0stw\xE7t\xA0y\x97rqtwpspqtwpu\x97rqt[\xB7t\xD0st[p\xB0st]\xD7rot_\xB7r\xB0qta\xA7r\xD0otc\x97r\xE0mtc\xE7r\x90mte\xD7r\x90ktg\xC7r\x90iti\xB7r\xA0gt"
"k\xA7r\xA0\x65tm\x97r\xB0\x63tm\xE7t\xB0\x61to\xD7`\xD0stq\xC7^\xD0sts\xB7\\\xD0stu\xA7Z\xD0stw\x97X\xD0stw\xE7X\xD0sty\xD7V\xD0\x01\x01\x01+\xB5\xE7z\xE5\xB0o\x97pm\xC7j\xC0s\xC7pq\x97\x64\xE0w\x97ns\x97`\xD0y\xC7ns\xE7^\xA0}\x97lu\xA7\\\xD0}\xC7"
"lu\xD7t\xB0\x82n}\x97ju\xE7v\xC0{\xA7rotur\xA0ypot[r\xD0qt]\xB7t\xA0qt_\xB7t\xC0otcn\xB0mtcr\xC0itcp\xE2ktcl\xD0otcj\xC0qt_\x95p\x90st[\xD7t\xC0st[\x97t\xE0stwpspqtwpspqtw\xE7t\x90y\x97rqtw\xC7t\xD0y\xC7t\xD0stw\xA7r\xC0\x81\xC7r\xB0stu\xE7Zotu\xA7"
"\\\xB0qts\xB7`\xC0otq\xB7\x64\xC0mto\x95j\xE1itk\x94\xD6x\xD4\x90\x01\x01\x01\x01w\x97pc\xE7ps\xC7pe\xC7nu\x97ng\xA7lu\xC7ng\xE7lw\x97li\xC7jw\xC7lk\xA7hy\x97jk\xE7x\xB7tktm\xC7x\xE0rkto\xA7v\xA0rktot\xC0\x7Frktq\xC7x\xE0}rkts\xA7v\x90}rktst\xC0{r"
"ktu\xD7x\xE0yrktw\xA7v\x90yrktwt\xB0wrkty\xD7x\xE0urktyPqtyPqtyPqtyPqtyPqtyPqtyPqt]rkt]rkt]rkt]rkt]rkt]r\x01\x01\x01\x01{\x97po\xC7\x62u\xC7po\xD7\x62w\x97no^w\xC7no^y\x97lq\x97`y\xC7lq\xA7`{\x97jq\xB7`mtq\xD7x\xB0Ytq\xE7x\xA0Ytqt\x90YtqtUts\xA7v\xD6"
"x\xD4\x90its\xB7\x64\xD1kts\xC7`\xA0ots\xD7^\x90qts\xE7\xE3\x90}\x92\xE7r\xE0qts\xC3o\xB7r\xA0st[\xC7t\xD0st[\x97t\xE0stYpqtu\xC2ipqtu\xC7\x90o\xB7rqtu\xD7\xF2q\xA7r\xD0stu\xD7|\xE3\x90}\xA5n\xB0stu\xE7Zotu\xE7\\\xB0qtuZ\xC0otu\xE7`\xB0mts\xB6\x66"
"\xD1ito\x93\xD6v\xE4\xB0\x01\x01\x01Q";
inline int TC_scale(int x) { return (x<<5)|(x<<2)|(x>>1); }


void InitTextures(void) {
  int i,j;
  cprintf(" Textures [");
  glGenTextures(TextureCount,tex);

#define TEXSIZE  64
#define TEXSIZE2 (TEXSIZE/2)
#define zmax (TEXSIZE2*TEXSIZE2-TEXSIZE)
{ static unsigned char data[TEXSIZE][TEXSIZE];
  cprintf(" Shadow");
  for(i=0; i<TEXSIZE2; ++i)
    for(j=0; j<TEXSIZE2; ++j) {
      int z=i*i+j*j;
      if(z>=zmax) z=0;
             else z=icube((zmax-z)*255/zmax)>>16;
      data[TEXSIZE2-1-i][TEXSIZE2-1-j]=z;
    }
  for(i=0; i<TEXSIZE2; ++i)
    for(j=0; j<TEXSIZE2; ++j) {
      data[TEXSIZE-1-i][j]=
      data[i][TEXSIZE-1-j]=
      data[TEXSIZE-1-i][TEXSIZE-1-j]=
      data[i][j];
    }
  glBindTexture(GL_TEXTURE_2D,TEX_SHADOW);
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,BilinearFiltering);
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP_TO_EDGE);
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP_TO_EDGE);
  gluBuild2DMipmaps(GL_TEXTURE_2D,1,TEXSIZE,TEXSIZE,GL_LUMINANCE,
                    GL_UNSIGNED_BYTE,data);
}
#undef TEXSIZE
#undef TEXSIZE2

#define TEXSIZE 256
#define p(di,dj) raw[(di+i)&(TEXSIZE-1)][(dj+j)&(TEXSIZE-1)]
{ static int raw[TEXSIZE][TEXSIZE];
  static unsigned char data[TEXSIZE][TEXSIZE];
  cprintf(" Green");
  for(i=0; i<TEXSIZE; ++i)
    for(j=0; j<TEXSIZE; ++j) {
      raw[i][j]=rand()&255;
    }
  for(i=0; i<TEXSIZE; ++i)
    for(j=0; j<TEXSIZE; ++j) {
      data[i][j]=(((p(0,0)<<2)+
                  ((p(-1,0)+p(1,0)+p(0,1)+p(0,-1))<<1)+
                    p(-1,-1)+p(-1,1)+p(1,1)+p(1,-1))>>5)|128;
    }
  glBindTexture(GL_TEXTURE_2D,TEX_GREEN);
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,TrilinearFiltering);
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
  gluBuild2DMipmaps(GL_TEXTURE_2D,1,TEXSIZE,TEXSIZE,GL_LUMINANCE,
                    GL_UNSIGNED_BYTE,data);
}
#undef p
#undef TEXSIZE

#define TEXSIZE 256
#define TS2     (TEXSIZE/2)
#define BStart  (TEXSIZE*3/8)
#define BEnd    (TEXSIZE*5/8)
#define CRadius ((BEnd-BStart)/2-TEXSIZE/72)
#define CRad2o  (CRadius*CRadius)
#define CRad2i  (CRad2o-4*CRadius-1)  //(CRad2o-2*CRadius-1)
#define TC_Sub  36
#define TC_SPX  (TS2+21)
#define TC_SPY  (TS2-16)
{ int i,j,x,y;
  static unsigned char data[TEXSIZE][TEXSIZE][3];
  static unsigned char color[TEXSIZE*3];
  static unsigned char tex_data[TC_TexWidth*TC_TexHeight];
  unsigned char *Pi=&TC_TexData[0],*Po=&tex_data[0];
  cprintf(" Balls [");
  for(i=TC_TexSize; i; --i) {
    int v=*Pi++;
    if(v&0x80) {
      *Po++=TC_scale((v>>4)&7);
      *Po++=TC_scale(v&7);
    } else {
      j=((v>>1)^0x3F)+1;
      if(v&1) v=0; else v=0xFF;
      while(j) { *Po++=v; j--; }
    }
  }
  for(i=1; i<16; ++i) {
    cprintf(" %d",i);
    color[0]=ballcolors[i]>>16;
    color[1]=(ballcolors[i]>>8)&0xFF;
    color[2]=ballcolors[i]&0xFF;
    for(x=3; x<TEXSIZE*3; ++x)
      color[x]=color[x-3];
    if(i>8) {
      memset(data,0xFF,TEXSIZE*TEXSIZE*3);
      for(y=BStart; y<BEnd; ++y)
        memcpy(data[y],color,TEXSIZE*3);
    } else
      for(y=0; y<TEXSIZE; ++y)
        memcpy(data[y],color,TEXSIZE*3);
    for(y=BStart; y<BEnd; ++y)
      for(x=BStart; x<BEnd; ++x) {
        int dist=isqr(x-TS2)+isqr(y-TS2);
        if(dist<CRad2i) {
          data[y][x][0]=0xFF; data[y][x][1]=0xFF; data[y][x][2]=0xFF;
        } else if(dist<=CRad2o) {
          int a=((CRad2o-dist)<<8)/(CRad2o-CRad2i);
          data[y][x][0]=iclamp(color[0]+a);
          data[y][x][1]=iclamp(color[1]+a);
          data[y][x][2]=iclamp(color[2]+a);
        }
      }
    Pi=&tex_data[(i-1)*TC_Sub*TC_TexWidth];
    for(y=0; y<TC_Sub; ++y)
      for(x=0; x<TC_TexWidth; ++x) {
        j=*Pi++;
        data[y+TC_SPY][TC_SPX-x][0]-=j;
        data[y+TC_SPY][TC_SPX-x][1]-=j;
        data[y+TC_SPY][TC_SPX-x][2]-=j;
      }
#ifdef LowDetail
    Pi=Po=&data[0][0][0];
    for(y=0; y<TS2; ++y) {
      for(x=0; x<TS2; ++x) {
        *Po++=(Pi[0]+Pi[3]+Pi[3*TEXSIZE+0]+Pi[3*TEXSIZE+3]+2)>>2;
        *Po++=(Pi[1]+Pi[4]+Pi[3*TEXSIZE+1]+Pi[3*TEXSIZE+4]+2)>>2;
        *Po++=(Pi[2]+Pi[5]+Pi[3*TEXSIZE+2]+Pi[3*TEXSIZE+3]+2)>>2;
        Pi+=6;
      }
      Pi+=TEXSIZE*3;
    }
#endif
    glBindTexture(GL_TEXTURE_2D,tex[i]);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,BilinearFiltering);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
#ifdef LowDetail
    gluBuild2DMipmaps(GL_TEXTURE_2D,3,TS2,TS2,GL_RGB,GL_UNSIGNED_BYTE,data);
#else
    gluBuild2DMipmaps(GL_TEXTURE_2D,3,TEXSIZE,TEXSIZE,GL_RGB,
                      GL_UNSIGNED_BYTE,data);
#endif
  }
  cprintf(" ]");
}
#undef TEXSIZE

#define TEXSIZE  32
#define REALSIZE 20
#define RS2      (REALSIZE/2)
#define STRIPE   REALSIZE/6
#define ROuter   (RS2*RS2+RS2)
#define RInner   (RS2*RS2-2*RS2+1)
{ int i,j,l,x,y;
  static unsigned char data[TEXSIZE*4][TEXSIZE*4][4];
  unsigned char cbuf[3];
  cprintf(" BallOverview");
  memset(data,0xFF,sizeof(data));
  for(l=0; l<16; ++l) {
    i=(l>>2)*TEXSIZE;
    j=(l&3)*TEXSIZE;
    cbuf[0]=(ballcolors[l]>>16);
    cbuf[1]=(ballcolors[l]>>8)&0xFF;
    cbuf[2]=ballcolors[l]&0xFF;
    for(y=((l<=8)?0:RS2-STRIPE); y<((l<=8)?TEXSIZE:RS2+STRIPE+1); ++y)
      for(x=0; x<TEXSIZE; ++x) {
        data[y+i][x+j][0]=cbuf[0];
        data[y+i][x+j][1]=cbuf[1];
        data[y+i][x+j][2]=cbuf[2];
      }
    if(l>8) {
      cbuf[0]=128+(cbuf[0]>>1);
      cbuf[1]=128+(cbuf[1]>>1);
      cbuf[2]=128+(cbuf[2]>>1);
      for(x=0; x<TEXSIZE; ++x) {
        data[i+RS2-STRIPE-1][x+j][0]=data[i+RS2+STRIPE+1][x+j][0]=cbuf[0];
        data[i+RS2-STRIPE-1][x+j][1]=data[i+RS2+STRIPE+1][x+j][1]=cbuf[1];
        data[i+RS2-STRIPE-1][x+j][2]=data[i+RS2+STRIPE+1][x+j][2]=cbuf[2];
      }
    }
  }
  for(y=0; y<TEXSIZE; ++y)
    for(x=0; x<TEXSIZE; ++x) {
      int dist=isqr(x-RS2)+isqr(y-RS2);
      if(dist>ROuter)
        data[y][x][3]=0;
      else if(dist>=RInner)
        data[y][x][3]=(ROuter-dist)*255/(ROuter-RInner);
    }
  for(y=0; y<TEXSIZE; ++y)
    for(x=TEXSIZE; x<TEXSIZE*4; ++x)
      data[y][x][3]=data[y][x-TEXSIZE][3];
  for(y=TEXSIZE; y<TEXSIZE*4; ++y)
    for(x=0; x<TEXSIZE*4; ++x)
      data[y][x][3]=data[y-TEXSIZE][x][3];
  glBindTexture(GL_TEXTURE_2D,TEX_BALLS);
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_NEAREST);
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_NEAREST);
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
  glTexImage2D(GL_TEXTURE_2D,0,4,TEXSIZE*4,TEXSIZE*4,0,GL_RGBA,
               GL_UNSIGNED_BYTE,data);
}
#undef TEXSIZE

  cprintf(" ]");
}
