#include "globals.h"
#include "table.h"

GLuint LTable;

void SubdividedQuad2D(double sx, double sy, int kx, int ky) {
  double dx=sx/kx, dy=sy/ky;
  double x, y0=0.0, y1=dy;
  int cx,cy;
  glNormal3d(0.0,0.0,-1.0);
  for(cy=ky; cy; --cy) {
    x=0.0;
    glBegin(GL_TRIANGLE_STRIP);
    for(cx=0; cx<=kx; ++cx) {
      glVertex3d(x,y0,0.0);
      glVertex3d(x,y1,0.0);
      x+=dx;
    }
    glEnd();
    y0=y1; y1+=dy;
  }
}

#define DTE_Front(x) x*front_factor+front_offset
static void DrawTableEdge(int aleft, int aright) {
  double x;
  double xmin=0.0,xmax,xstep;
  double front_factor=1.0,front_offset=0.0;
  if(aleft&&aright) xmax=TableSizeX-2.0*OuterHoleRadius;
               else xmax=TableSizeX-InnerHoleRadius-OuterHoleRadius;
  if(aleft) xmax+=EdgeExtend;
  if(aright) xmin-=EdgeExtend;
  if(aleft||aright) {
    if(aleft&&aright) front_factor=(xmax-2.0*EdgeExtend)/xmax;
                 else front_factor=(xmax-    EdgeExtend)/xmax;
    if(aright) front_offset=EdgeExtend;
  }
  xstep=(xmax-xmin)/10.0;
  glEnable(GL_TEXTURE_2D);
  glBindTexture(GL_TEXTURE_2D,TEX_GREEN);
  SetMaterial(0.0,128);
  glBegin(GL_TRIANGLE_STRIP);
    glNormal3d(0.0,-1.0,1.0);
    for(x=xmax; x>=xmin-0.0001; x-=xstep) {
      SetColor(0x006020); glVertex3d(DTE_Front(x),0.0,EdgeSize);
      SetColor(0x003010); glVertex3d(          x ,EdgeExtend,BallRadius);
    }
  glEnd();
  glBegin(GL_TRIANGLE_STRIP);
    SetColor(0x006020);
    glNormal3d(0.0,-1.0,0.0);
    for(x=xmax; x>=xmin-0.0001; x-=xstep) {
      glVertex3d(DTE_Front(x),0.0,-EdgeSize);
      glVertex3d(DTE_Front(x),0.0, EdgeSize);
    }
  glEnd();
  glBegin(GL_TRIANGLE_STRIP);
    glNormal3d(0.0,0.0,-1.0);
    for(x=xmax; x>=xmin-0.0001; x-=xstep) {
      SetColor(0x000000); glVertex3d(          x ,EdgeExtend,-EdgeSize);
      SetColor(0x006020); glVertex3d(DTE_Front(x),0.0,-EdgeSize);
    }
  glEnd();
  glBegin(GL_TRIANGLES);
    glNormal3d(1.0,-aleft,0.0);
    SetColor(0x000000); glVertex3d(xmax,EdgeExtend,EdgeSize);
                        glVertex3d(xmax,EdgeExtend,BallRadius);
    SetColor(0x006020); glVertex3d(DTE_Front(xmax),0.0,EdgeSize);
    SetColor(0x000000); glVertex3d(xmin,EdgeExtend,EdgeSize);
    SetColor(0x006020); glVertex3d(DTE_Front(xmin),0.0,EdgeSize);
    SetColor(0x000000); glVertex3d(xmin,EdgeExtend,BallRadius);
  glEnd();
  glBegin(GL_QUADS);
    SetColor(0x000000); glVertex3d(xmax,EdgeExtend,EdgeSize);
    SetColor(0x006020); glVertex3d(DTE_Front(xmax),0.0,EdgeSize);
                        glVertex3d(DTE_Front(xmax),0.0,-EdgeSize);
    SetColor(0x000000); glVertex3d(xmax,EdgeExtend,-EdgeSize);
                        glVertex3d(xmin,EdgeExtend,EdgeSize);
                        glVertex3d(xmin,EdgeExtend,-EdgeSize);
    SetColor(0x006020); glVertex3d(DTE_Front(xmin),0.0,-EdgeSize);
                        glVertex3d(DTE_Front(xmin),0.0,EdgeSize);
    SetColor(0); glVertex3d(xmax,EdgeExtend,-EdgeSize);
                 glVertex3d(xmin,EdgeExtend,-EdgeSize);
                 glVertex3d(xmin,EdgeExtend,BallRadius);
                 glVertex3d(xmax,EdgeExtend,BallRadius);
  glEnd();
}


void InitTable(void) {
  cprintf(" Table");
  LTable=glGenLists(3);
  glNewList(LTable+TABLE_STEP_1,GL_COMPILE);

  glEnable(GL_TEXTURE_2D);
  glEnable(GL_TEXTURE_GEN_S);
  glEnable(GL_TEXTURE_GEN_T);
  glBindTexture(GL_TEXTURE_2D,TEX_GREEN);
  SetColorMaterial(0x006020,0.0,128);
  glPushMatrix();
  glTranslated(-TableSizeX-EdgeExtend,
               -TableSizeY-EdgeExtend,BallRadius);
  SubdividedQuad2D((TableSizeX+EdgeExtend)*2.0,
                   (TableSizeY+EdgeExtend)*2.0,20,10);
  glPopMatrix();
  glDisable(GL_TEXTURE_GEN_S);
  glDisable(GL_TEXTURE_GEN_T);

  glEndList();
  glNewList(LTable+TABLE_STEP_2,GL_COMPILE);

  glEnable(GL_BLEND);
  glBlendFunc(GL_ZERO,GL_ONE_MINUS_SRC_COLOR);
  glDisable(GL_DEPTH_TEST);
  glDisable(GL_LIGHTING);
  glDisable(GL_TEXTURE_2D);
  glPushMatrix();
  glTranslated(0.0,0.0,BallRadius);
  glBegin(GL_QUADS);
    SetColor(0x808080); glVertex3d(-TableSizeX, -TableSizeY-EdgeExtend, 0.0);
    SetColor(0x000000); glVertex3d(-TableSizeX, -TableSizeY-EdgeExtend+EdgeShadow, 0.0);
                        glVertex3d( TableSizeX, -TableSizeY-EdgeExtend+EdgeShadow, 0.0);
    SetColor(0x808080); glVertex3d( TableSizeX, -TableSizeY-EdgeExtend, 0.0);
                        glVertex3d(-TableSizeX,  TableSizeY+EdgeExtend, 0.0);
                        glVertex3d( TableSizeX,  TableSizeY+EdgeExtend, 0.0);
    SetColor(0x000000); glVertex3d( TableSizeX,  TableSizeY+EdgeExtend-EdgeShadow, 0.0);
                        glVertex3d(-TableSizeX,  TableSizeY+EdgeExtend-EdgeShadow, 0.0);
    SetColor(0x808080); glVertex3d(-TableSizeX-EdgeExtend, -TableSizeY, 0.0);
                        glVertex3d(-TableSizeX-EdgeExtend, TableSizeY, 0.0);
    SetColor(0x000000); glVertex3d(-TableSizeX-EdgeExtend+EdgeShadow, TableSizeY, 0.0);
                        glVertex3d(-TableSizeX-EdgeExtend+EdgeShadow, -TableSizeY, 0.0);
    SetColor(0x808080); glVertex3d( TableSizeX+EdgeExtend, -TableSizeY, 0.0);
    SetColor(0x000000); glVertex3d( TableSizeX+EdgeExtend-EdgeShadow, -TableSizeY, 0.0);
                        glVertex3d( TableSizeX+EdgeExtend-EdgeShadow, TableSizeY, 0.0);
    SetColor(0x808080); glVertex3d( TableSizeX+EdgeExtend, TableSizeY, 0.0);
  glEnd();
  glDisable(GL_BLEND);
  SetColor(0);
  glRotated(180.0,0.0,1.0,0.0);
  glPushMatrix(); glTranslated(-TableSizeX-EdgeExtend,-TableSizeY-EdgeExtend,0.0);
                  gluDisk(quad,0.0,OuterHoleRadius,32,1); glPopMatrix();
  glPushMatrix(); glTranslated(                   0.0,-TableSizeY-EdgeExtend,0.0);
                  gluDisk(quad,0.0,InnerHoleRadius,32,1); glPopMatrix();
  glPushMatrix(); glTranslated( TableSizeX+EdgeExtend,-TableSizeY-EdgeExtend,0.0);
                  gluDisk(quad,0.0,OuterHoleRadius,32,1); glPopMatrix();
  glPushMatrix(); glTranslated(-TableSizeX-EdgeExtend, TableSizeY+EdgeExtend,0.0);
                  gluDisk(quad,0.0,OuterHoleRadius,32,1); glPopMatrix();
  glPushMatrix(); glTranslated(                   0.0, TableSizeY+EdgeExtend,0.0);
                  gluDisk(quad,0.0,InnerHoleRadius,32,1); glPopMatrix();
  glPushMatrix(); glTranslated( TableSizeX+EdgeExtend, TableSizeY+EdgeExtend,0.0);
                  gluDisk(quad,0.0,OuterHoleRadius,32,1); glPopMatrix();
  glPopMatrix();
  glEnable(GL_LIGHTING);
  glEnable(GL_DEPTH_TEST);

  glEnable(GL_TEXTURE_GEN_S);
  glEnable(GL_TEXTURE_GEN_T);
  glPushMatrix();
    glTranslated(TableSizeX,TableSizeY-OuterHoleRadius,0.0);
    glRotated(-90.0,0.0,0.0,1.0);
    DrawTableEdge(1,1);
  glPopMatrix();
  glPushMatrix();
    glTranslated(InnerHoleRadius,TableSizeY,0.0);
    DrawTableEdge(1,0);
  glPopMatrix();
  glPushMatrix();
    glTranslated(OuterHoleRadius-TableSizeX,TableSizeY,0.0);
    DrawTableEdge(0,1);
  glPopMatrix();
  glPushMatrix();
    glTranslated(-TableSizeX,OuterHoleRadius-TableSizeY,0.0);
    glRotated(90.0,0.0,0.0,1.0);
    DrawTableEdge(1,1);
  glPopMatrix();
  glPushMatrix();
    glTranslated(-InnerHoleRadius,-TableSizeY,0.0);
    glRotated(180.0,0.0,0.0,1.0);
    DrawTableEdge(1,0);
  glPopMatrix();
  glPushMatrix();
    glTranslated(TableSizeX-OuterHoleRadius,-TableSizeY,0.0);
    glRotated(180.0,0.0,0.0,1.0);
    DrawTableEdge(0,1);
  glPopMatrix();
  glDisable(GL_TEXTURE_GEN_S);
  glDisable(GL_TEXTURE_GEN_T);

  glEndList();
  glNewList(LTable+TABLE_ARROW,GL_COMPILE);

  glDisable(GL_DEPTH_TEST);
  glDisable(GL_TEXTURE_2D);
  glDisable(GL_LIGHTING);
  SetColor(0xA00000);
  glBegin(GL_TRIANGLES);
    glVertex3d( 0.040, 0.000,-0.050);
    glVertex3d( 0.000, 0.000, 0.000);
    glVertex3d(-0.040, 0.000,-0.050);
  glEnd();
  glBegin(GL_QUADS);
    glVertex3d( 0.020, 0.000,-0.110);
    glVertex3d( 0.020, 0.000,-0.040);
    glVertex3d(-0.020, 0.000,-0.040);
    glVertex3d(-0.020, 0.000,-0.110);
  glEnd();
  SetColor(0xC0C000);
  glBegin(GL_TRIANGLES);
    glVertex3d( 0.030, 0.000,-0.045);
    glVertex3d( 0.000, 0.000,-0.008);
    glVertex3d(-0.030, 0.000,-0.045);
  glEnd();
  glBegin(GL_QUADS);
    glVertex3d( 0.015, 0.000,-0.105);
    glVertex3d( 0.015, 0.000,-0.040);
    glVertex3d(-0.015, 0.000,-0.040);
    glVertex3d(-0.015, 0.000,-0.105);
  glEnd();
  glEnable(GL_LIGHTING);
  glEnable(GL_DEPTH_TEST);

  glEndList();
}

void DrawTable(int step) {
  glCallList(LTable+step);
}
