#include "globals.h"
#include "init.h"
#include "ball.h"
#include "view.h"
#include "table.h"
#include "tex.h"
#include "physics.h"
#include "game.h"
#include "frame.h"
#include "text.h"

void Prepare(void) {
  srand(srand_val);
  rules=RULE_ALL;
  cprintf("Init [");
  InitMain();
  InitBall();
  InitBounds();
  InitView();
  InitTextures();
  InitTable();
  InitText();
#ifdef WIN32
  srand(GetTickCount());
#else
  srand(time(NULL));
#endif
  cprintf(" Game/Physics"); InitGame();
  cprintf(" ] Done.\nStarting the game ...\n");
}

////////////////////////////////////////////////////////////////////////////////

#ifndef FullscreenMode
static int win_id;
#endif

void OnIdle(void) {
  glutPostRedisplay();
}

void OnPaint(void) {
  t=glutGet(GLUT_ELAPSED_TIME)*0.001;
  frame_dt=t-t_old; t_old=t;
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  DrawScene();
  glFlush();
  glutSwapBuffers();
}

void OnResize(int sx,int sy) {
  float ratio;
  if(!sy) sy=1;
  ratio=1.0*sx/sy;
  win_width=sx;
  win_height=sy;
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glViewport(0,0,sx,sy);
  gluPerspective(45,ratio,0.05,10.0);
}

static inline void UpdateModifiers(void) {
  int mod=glutGetModifiers();
  if(mod&GLUT_ACTIVE_SHIFT) keymap|=KEY_SHIFT;
                       else keymap&=~KEY_SHIFT;
}

void OnKeyDown(unsigned char key,int px,int py) {
  switch(key) {
    case 27: case 'q': exit(0);
    case 13: if(state==STATE_SETUP && valid_setup) ResetCue(); break;
    case 32: keymap|=KEY_SPACE; break;
    case 'v': show_speeds^=1; break;
    case 'd': show_direction^=1; break;
    case 'h': ToggleBox(&BHelp);
              if(BRules.active) ToggleBox(&BRules);
              break;
    case 'r': ToggleBox(&BRules);
              if(BHelp.active) ToggleBox(&BHelp);
              break;
    case 'n': InitGame(); break;
    case '+': keymap|=KEY_PLUS;  break;
    case '-': keymap|=KEY_MINUS; break;
    default:
      if(BRules.active && key>'0' && key<='9')
        rules^=1<<(key-'1');
  }
  UpdateModifiers();
}

void OnKeyUp(unsigned char key,int px,int py) {
  switch(key) {
    case 32: keymap&=~KEY_SPACE; if(state==STATE_CUE) FireCue(); break;
    case '+': keymap&=~KEY_PLUS;  break;
    case '-': keymap&=~KEY_MINUS; break;
  }
  UpdateModifiers();
}

void OnSpecialKeyDown(int key,int px,int py) {
  switch(key) {
    case GLUT_KEY_F1:        camera=CAMERA_OVERVIEW; break;
    case GLUT_KEY_F2:        camera=CAMERA_NEAR;     break;
    case GLUT_KEY_F3:        camera=CAMERA_FAR;      break;
    case GLUT_KEY_F4:        camera=CAMERA_FLYBY;    break;
    case GLUT_KEY_F5:        camera=CAMERA_AUTO;     break;
    case GLUT_KEY_LEFT:      keymap|=KEY_LEFT;       break;
    case GLUT_KEY_RIGHT:     keymap|=KEY_RIGHT;      break;
    case GLUT_KEY_UP:        keymap|=KEY_UP;         break;
    case GLUT_KEY_DOWN:      keymap|=KEY_DOWN;       break;
    case GLUT_KEY_PAGE_UP:   keymap|=KEY_PGUP;       break;
    case GLUT_KEY_PAGE_DOWN: keymap|=KEY_PGDN;       break;
  }
  UpdateModifiers();
}

void OnSpecialKeyUp(int key,int px,int py) {
  switch(key) {
    case GLUT_KEY_LEFT:      keymap&=~KEY_LEFT;  break;
    case GLUT_KEY_RIGHT:     keymap&=~KEY_RIGHT; break;
    case GLUT_KEY_UP:        keymap&=~KEY_UP;    break;
    case GLUT_KEY_DOWN:      keymap&=~KEY_DOWN;
                             if(state==STATE_CUE) FireCue();
                             break;
    case GLUT_KEY_PAGE_UP:   keymap&=~KEY_PGUP;  break;
    case GLUT_KEY_PAGE_DOWN: keymap&=~KEY_PGDN;  break;
  }
  UpdateModifiers();
}

static void OnExit(void) {
#ifdef FullscreenMode
  glutLeaveGameMode();
#else
  glutDestroyWindow(win_id);
#endif
}

int main(int argc, char *argv[]) {
  srand(srand_val);
  glutInit(&argc,argv);
  glutInitDisplayMode(GLUT_RGBA|GLUT_STENCIL|GLUT_DOUBLE|GLUT_DEPTH);
#ifndef FullscreenMode
#ifndef RELEASE
  glutInitWindowPosition(0,0);
#endif
  glutInitWindowSize(WindowSize);
  win_id=glutCreateWindow(WindowCaption);
#else
  glutGameModeString(FullscreenMode);
  glutEnterGameMode();
  glutSetCursor(GLUT_CURSOR_NONE);
#endif
  atexit(OnExit);
  glutDisplayFunc(OnPaint);
  glutReshapeFunc(OnResize);
  glutKeyboardFunc(OnKeyDown);
  glutKeyboardUpFunc(OnKeyUp);
  glutSpecialFunc(OnSpecialKeyDown);
  glutSpecialUpFunc(OnSpecialKeyUp);
  glutIgnoreKeyRepeat(1);
  glutIdleFunc(OnIdle);
  t=0.0;
  Prepare();
  t_old=glutGet(GLUT_ELAPSED_TIME)*0.001;
  fps_last_update=t_old; fps_frame_count=fps_phys_count=0;
  glutMainLoop();
  return 0;
}
