#include "globals.h"
#include "init.h"

void InitMain(void) {
#ifdef LowDetail
  static const GLfloat AmbientLight[]={0.35,0.35,0.35,1.0};
#else
  static const GLfloat AmbientLight[]={0.22,0.22,0.22,1.0};
  static const GLfloat NoLight[]={0.0,0.0,0.0,0.0};
  static const GLfloat LightF[]={0.0,0.1,0.025,0.0};
#endif
  static const GLfloat Light0[]=
               {LightIntensity,LightIntensity,LightIntensity,LightIntensity};
  static const GLdouble TexGenS[]={8.0,0.0,8.0,0.0};
  static const GLdouble TexGenT[]={0.0,8.0,8.0,0.0};
  cprintf(" Main");

  glEnable(GL_NORMALIZE);
  glEnable(GL_COLOR_MATERIAL);
  glEnable(GL_CULL_FACE); glCullFace(GL_BACK);
  glEnable(GL_LIGHTING);
  glEnable(GL_LIGHT0);
#ifndef LowDetail
  glEnable(GL_LIGHT1);
  glEnable(GL_LIGHT2);
#endif
  glEnable(GL_DEPTH_TEST);
  glHint(GL_LINE_SMOOTH_HINT,GL_NICEST);

  glColorMaterial(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE);
  glLightModelfv(GL_LIGHT_MODEL_AMBIENT, AmbientLight);
  glLightModeli(GL_LIGHT_MODEL_LOCAL_VIEWER, GL_TRUE);
#ifdef LowDetail
  glLightfv(GL_LIGHT0, GL_DIFFUSE,       Light0);
  glLightfv(GL_LIGHT0, GL_SPECULAR,      Light0);
  glLightf (GL_LIGHT0, GL_SPOT_EXPONENT, 1.0);
  glLightf (GL_LIGHT0, GL_SPOT_CUTOFF,   90.0);
#else
  glLightfv(GL_LIGHT0, GL_DIFFUSE,       Light0);
  glLightfv(GL_LIGHT0, GL_SPECULAR,      Light0);
  glLightf (GL_LIGHT0, GL_SPOT_EXPONENT, 1.0);
  glLightf (GL_LIGHT0, GL_SPOT_CUTOFF,   67.0);
  glLightfv(GL_LIGHT1, GL_DIFFUSE,       Light0);
  glLightfv(GL_LIGHT1, GL_SPECULAR,      Light0);
  glLightf (GL_LIGHT1, GL_SPOT_EXPONENT, 1.0);
  glLightf (GL_LIGHT1, GL_SPOT_CUTOFF,   67.0);
  glLightfv(GL_LIGHT2, GL_DIFFUSE,       LightF);
  glLightfv(GL_LIGHT2, GL_SPECULAR,      NoLight);
#endif
  glTexEnvi(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_MODULATE);

  glTexGeni(GL_S,GL_TEXTURE_GEN_MODE,GL_OBJECT_LINEAR);
  glTexGeni(GL_T,GL_TEXTURE_GEN_MODE,GL_OBJECT_LINEAR);
  glTexGendv(GL_S,GL_OBJECT_PLANE,TexGenS);
  glTexGendv(GL_T,GL_OBJECT_PLANE,TexGenT);

  quad=gluNewQuadric();
  gluQuadricNormals(quad,GLU_SMOOTH);

  cue_fired=-9.9;
  show_direction=0;
  show_speeds=0;
}


static void AddBound(bound *cb, int id, double x1, double y1, double x2, double y2) {
  double dx=x2-x1;
  double dy=y2-y1;
  double n=sqrt(dx*dx+dy*dy);
  cb->bit=1<<id;
  cb->px= x1;    cb->py= y1;
  cb->dx= dx/n;  cb->dy= dy/n;
  cb->nx= dy/n;  cb->ny=-dx/n;
  cb->l =    n;
}

#define EnterBoundStrip(id,x1,y1,x2,y2,x3,y3,x4,y4) do { \
    AddBound(cb++,id,x1,y1,x2,y2); \
    AddBound(cb++,id,x2,y2,x3,y3); \
    AddBound(cb++,id,x3,y3,x4,y4); \
  } while(0)

void InitBounds(void) {
  bound *cb=&bounds[0];
  EnterBoundStrip(0, TableSizeX-OuterHoleRadius+EdgeExtend, TableSizeY+EdgeExtend,
                     TableSizeX-OuterHoleRadius, TableSizeY,
                     InnerHoleRadius, TableSizeY,
                     InnerHoleRadius, TableSizeY+EdgeExtend);
  EnterBoundStrip(1,-InnerHoleRadius, TableSizeY+EdgeExtend,
                    -InnerHoleRadius, TableSizeY,
                    -TableSizeX+OuterHoleRadius, TableSizeY,
                    -TableSizeX+OuterHoleRadius-EdgeExtend, TableSizeY+EdgeExtend);
  EnterBoundStrip(2,-TableSizeX-EdgeExtend, TableSizeY-OuterHoleRadius+EdgeExtend,
                    -TableSizeX, TableSizeY-OuterHoleRadius,
                    -TableSizeX,-TableSizeY+OuterHoleRadius,
                    -TableSizeX-EdgeExtend,-TableSizeY+OuterHoleRadius-EdgeExtend);
  EnterBoundStrip(3,-TableSizeX+OuterHoleRadius-EdgeExtend,-TableSizeY-EdgeExtend,
                    -TableSizeX+OuterHoleRadius,-TableSizeY,
                    -InnerHoleRadius,-TableSizeY,
                    -InnerHoleRadius,-TableSizeY-EdgeExtend);
  EnterBoundStrip(4, InnerHoleRadius,-TableSizeY-EdgeExtend,
                     InnerHoleRadius,-TableSizeY,
                     TableSizeX-OuterHoleRadius,-TableSizeY,
                     TableSizeX-OuterHoleRadius+EdgeExtend,-TableSizeY-EdgeExtend);
  EnterBoundStrip(5, TableSizeX+EdgeExtend,-TableSizeY+OuterHoleRadius-EdgeExtend,
                     TableSizeX,-TableSizeY+OuterHoleRadius,
                     TableSizeX, TableSizeY-OuterHoleRadius,
                     TableSizeX+EdgeExtend, TableSizeY-OuterHoleRadius+EdgeExtend);
}
