#ifndef __GLOBALS_H_
#define __GLOBALS_H_

#ifdef WIN32
#include <windows.h>
#ifndef RELEASE
#define GLUT_DISABLE_ATEXIT_HACK
#endif
#else
#include <time.h>
#endif
#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "version.h"

#ifndef GL_CLAMP_TO_EDGE
#define GL_CLAMP_TO_EDGE 0x812F
#endif

#ifdef _THIS_IS_GLOBALS_C_
#define GLOBAL
#else
#define GLOBAL extern
#endif

#ifdef PROFILE_low
#define FullscreenMode        "640x480:16"
#define BallTesselationLevel  2
#define TrilinearFiltering    GL_LINEAR_MIPMAP_NEAREST
#define LowDetail
#endif

#ifdef PROFILE_standard
#define FullscreenMode        "1024x768:32"
#define BallTesselationLevel  3
#endif

#ifdef PROFILE_ultra
#define FullscreenMode        "1600x1200:32"
#define BallTesselationLevel  4
#define BilinearFiltering     GL_LINEAR_MIPMAP_LINEAR
#endif

#ifdef PROFILE_
#ifdef RELEASE
#define WindowSize            800,600
#else
#define WindowSize            960,720
#endif
#define BallTesselationLevel  3
#endif

#ifndef BilinearFiltering
#define BilinearFiltering GL_LINEAR_MIPMAP_NEAREST
#endif
#ifndef TrilinearFiltering
#define TrilinearFiltering GL_LINEAR_MIPMAP_LINEAR
#endif

#define WindowCaption "KeyJ's Billard"
#define FPSUpdateInterval 0.5
#define srand_val   0x13375EED

#define TableSizeX    1.42
#define TableSizeY    0.71
#define BallRadius    0.0305

#define PhysicsSampleRate (1.0/200)

#define ShadowSize    (1.67*BallRadius)
#define EdgeSize      0.005
#define EdgeExtend    (BallRadius-EdgeSize)
#define EdgeShadow    0.04
#define HoleRadiusFactor 2.0
#define OuterHoleRadius (1.41*HoleRadiusFactor*BallRadius)
#define InnerHoleRadius      (HoleRadiusFactor*BallRadius)

#define Friction      0.1
#define CollisionLoss 0.075
#define BoundLoss     0.2
#define FallingSpeed  15.0
#define HoleMagnetism 1.0
#define MaxCuePower   7.5

#define BallCount     15

#define LightIntensity 1.0
#define CameraSpeed    3.0
#define CueMoveSpeed 50.0
#define CuePowerSpeed 0.5
#define CuePowerVisFactor 0.01
#define PrecisionFactor 0.1
#define SetupMoveSpeed  0.5
#define MessageTimeout  5.0

GLOBAL int state;
#define STATE_ROLLING 1
#define STATE_CUE     2
#define STATE_SETUP   3
#define STATE_END     0

GLOBAL int camera;
#define CAMERA_OVERVIEW 2
#define CAMERA_NEAR     0
#define CAMERA_FAR      1
#define CAMERA_FLYBY    3
#define CAMERA_AUTO     4

#define CONFIGURABLE_CAMERAS 2
GLOBAL double CamDist[CONFIGURABLE_CAMERAS];
GLOBAL double CamHeight[CONFIGURABLE_CAMERAS];

#define DefaultNearCamDist   0.45
#define DefaultNearCamHeight 0.45
#define DefaultFarCamDist    1.0
#define DefaultFarCamHeight  0.45
#define MaxCamHeight         1.5
#define MinCamDist           (BallRadius+0.05)
#define MaxCamDist           5.0
#define CamDistSpeed         0.5
#define CamHeightSpeed       0.3

GLOBAL int keymap;
#define KEY_LEFT   1
#define KEY_RIGHT  2
#define KEY_UP     4
#define KEY_DOWN   8
#define KEY_SPACE  16
#define KEY_PGUP   32
#define KEY_PGDN   64
#define KEY_PLUS   128
#define KEY_MINUS  256
#define KEY_SHIFT  0x8000

#define TextureCount 18
GLOBAL GLuint tex[TextureCount];
#define TEX_SHADOW tex[0]
#define TEX_GREEN  tex[16]
#define TEX_BALLS  tex[17]

#define NearCamDist   0.4
#define NearCamHeight 0.2
#define  FarCamDist   1.0
#define  FarCamHeight 0.8

#ifndef _THIS_IS_GLOBALS_C_
extern int ballcolors[16];
#endif

GLOBAL double t,frame_dt,dt,t_old;
GLOBAL GLUquadric *quad;

GLOBAL double fps_last_update;
GLOBAL int fps_frame_count,fps_phys_count;

typedef struct _ball {
  int id,bit,active,falling,in_hole;
  double px,py,pz,vx,vy,vz;
  GLdouble mat[16];
} ball;

GLOBAL ball balls[BallCount+1];
GLOBAL int moving;
GLOBAL int fallen;
GLOBAL int first_collision;
GLOBAL int last_hole;

GLOBAL double cue_cx,cue_cy;
GLOBAL double cue_angle,cue_power;
GLOBAL double cue_fired;

typedef struct _bound {
  int bit;
  double px,py;
  double nx,ny;
  double dx,dy;
  double l;
} bound;

GLOBAL bound bounds[18];

typedef struct _box {
  int active;
  int width,height;
  int dest,pos;
} box;

box BHelp,BRules;
GLOBAL int win_width,win_height;

GLOBAL int show_direction;
GLOBAL int show_speeds;

GLOBAL int valid_setup;

GLOBAL int player;
GLOBAL int preference;
GLOBAL int fouls[2];
GLOBAL int bound_mask,bound_count;
GLOBAL int need_half_table;
GLOBAL int hole8[2];

GLOBAL int rules;
#define RULE_SETUP               1
#define RULE_SETUP_AFTER_FOUL    2
#define RULE_HALF_TABLE          4
#define RULE_NO_PREFERENCE       8
#define RULE_OPPOSITE_HOLE      16
#define RULE_MUST_COLLIDE       32
#define RULE_THREE_FOULS        64
#define RULE_ALL                0xFFFF-RULE_NO_PREFERENCE-RULE_SETUP_AFTER_FOUL


#define drand() (rand()/(double)RAND_MAX)
#define m_sqr(x) ((x)*(x))
inline double sqr(double x);
inline int isqr(int x);
inline int icube(int x);
inline int iclamp(int x);
#define Normalize3d(x,y,z) do{double n=sqrt(x*x+y*y+z*z);x/=n;y/=n;z/=n;}while(0)


void SetMaterial(GLfloat specular, GLint shininess);
inline void SetColor(int color);
#define SetColorMaterial(color,specular,shininess) \
  do { \
    SetColor(color); \
    SetMaterial(specular,shininess); \
  } while(0)


#ifdef CONSOLE
#define cprintf printf
#else
int cprintf(const char *format, ...);
#endif

#endif /*_GLOBALS_H_*/
