#define _THIS_IS_GLOBALS_C_
#include "globals.h"

int ballcolors[16]={
      0xFFFFFF,0xFFFF00,0x0000FF,0xFF0000,0xC000C0,0xFFA800,0x00FF00,0xA80020,
      0x404040,0xFFFF00,0x0000FF,0xFF0000,0xC000C0,0xFFA800,0x00FF00,0xA80020};

inline double sqr(double x) { return x*x; }
inline int isqr(int x) { return x*x; }
inline int icube(int x) { return x*x*x; }
inline int iclamp(int x) { return x>0xFF?0xFF:x; }

#ifndef CONSOLE
int cprintf(const char *format, ...) { return 0; }
#endif


void SetMaterial(GLfloat specular, GLint shininess) {
  GLfloat spec[4]={0.0,0.0,0.0,1.0};
  spec[0]=spec[1]=spec[2]=specular;
  glMaterialfv(GL_FRONT, GL_SPECULAR, spec);
  glMateriali(GL_FRONT, GL_SHININESS, shininess);
}

inline void SetColor(int color) {
  glColor4ub((color>>16)&0xFF,(color>>8)&0xFF,color&0xFF,(color>>24)&0xFF);
}
