#include "globals.h"
#include "game.h"
#include "view.h"
#include "table.h"
#include "ball.h"
#include "text.h"
#include "frame.h"

static double ArrowPos[6][3]={
  { TableSizeX, TableSizeY,  45.0},
  {        0.0, TableSizeY,   0.0},
  {-TableSizeX, TableSizeY, -45.0},
  { TableSizeX,-TableSizeY, 135.0},
  {        0.0,-TableSizeY, 180.0},
  {-TableSizeX,-TableSizeY,-135.0}
};

void DrawScene(void) {
#ifdef LowDetail
  static const GLfloat LightPosL[]={ 0.0,0.0,-2.5,1.0};
#else
  static const GLfloat LightPosF[]={0.0,0.0,1.0,0.0};
  static const GLfloat LightPos1[]={ 0.5*TableSizeX,0.0,-1.0,1.0};
  static const GLfloat LightPos2[]={-0.5*TableSizeX,0.0,-1.0,1.0};
#endif
  static const GLfloat LightDir0[]={0.0,0.0,1.0,1.0};
  int i,j;
  double qtrans;

  j=(frame_dt/PhysicsSampleRate)+1;
  dt=frame_dt/j;
  for(i=j; i; --i) {
    ProcessSubFrame();
    ++fps_phys_count;
  }

  glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
  ApplyView();
#ifdef LowDetail
  glLightfv(GL_LIGHT0, GL_POSITION,       LightPosL);
  glLightfv(GL_LIGHT0, GL_SPOT_DIRECTION, LightDir0);
#else
  glLightfv(GL_LIGHT0, GL_POSITION,       LightPos1);
  glLightfv(GL_LIGHT0, GL_SPOT_DIRECTION, LightDir0);
  glLightfv(GL_LIGHT1, GL_POSITION,       LightPos2);
  glLightfv(GL_LIGHT1, GL_SPOT_DIRECTION, LightDir0);
  glLightfv(GL_LIGHT2, GL_POSITION,       LightPosF);
#endif

  DrawTable(TABLE_STEP_1);

  glDisable(GL_DEPTH_TEST);
#ifdef LowDetail
  glDisable(GL_TEXTURE_2D);
  SetColor(0x003010);
  for(i=0; i<=BallCount; ++i)
    if(balls[i].active) {
      glPushMatrix();
      glTranslated(balls[i].px,balls[i].py,BallRadius);
      glRotated(180.0,1.0,0.0,0.0);
      gluDisk(quad,0.0,BallRadius,16,1);
      glPopMatrix();
    }
#else
  glEnable(GL_BLEND);
  glDisable(GL_LIGHTING);
  glBlendFunc(GL_ZERO,GL_ONE_MINUS_SRC_COLOR);
  glBindTexture(GL_TEXTURE_2D,TEX_SHADOW);
  SetColor(0xFFFFFF);
  glPushMatrix();
  glTranslated(0.0,0.0,BallRadius);
  for(i=0; i<=BallCount; ++i)
    if(balls[i].active) {
      double x=balls[i].px;
      double y=balls[i].py;
      glBegin(GL_QUADS);
        glTexCoord2d(0.0,0.0); glVertex3d(x-ShadowSize,y+ShadowSize,0.0);
        glTexCoord2d(1.0,0.0); glVertex3d(x+ShadowSize,y+ShadowSize,0.0);
        glTexCoord2d(1.0,1.0); glVertex3d(x+ShadowSize,y-ShadowSize,0.0);
        glTexCoord2d(0.0,1.0); glVertex3d(x-ShadowSize,y-ShadowSize,0.0);
      glEnd();
    }
  glPopMatrix();
  glDisable(GL_BLEND);
  glEnable(GL_LIGHTING);
#endif
  glEnable(GL_DEPTH_TEST);

  DrawTable(TABLE_STEP_2);

  if(hole8[player]) {
    i=hole8[player]-1;
    glPushMatrix();
    glTranslated(ArrowPos[i][0],ArrowPos[i][1],-BallRadius);
    glRotated(ArrowPos[i][2],0.0,0.0,-1.0);
    glRotated(30.0,1.0,0.0,0.0);
    DrawTable(TABLE_ARROW);
    glPopMatrix();
  }

  glDisable(GL_TEXTURE_2D);
  glBindTexture(GL_TEXTURE_2D,tex[0]);
  SetMaterial(1.0,128);
  for(i=0; i<=BallCount; ++i) {
    if(balls[i].active) {
      glPushMatrix();
      glBindTexture(GL_TEXTURE_2D,tex[i]);
      glTranslated(balls[i].px,balls[i].py,balls[i].pz*2.0*BallRadius);
      glMultMatrixd(balls[i].mat);
      if(balls[i].falling) {
        double color=sqr(1.0-balls[i].pz);
        glColor3d(color,color,color);
      } else
        glColor4ub(0xFF,0xFF,0xFF,0);
      DrawBall();
      glPopMatrix();
    }
    if(i==0) glEnable(GL_TEXTURE_2D);
  }
  glDisable(GL_TEXTURE_2D);

  if(state==STATE_SETUP) {
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
    SetMaterial(0.0,128);
    if(valid_setup) SetColor(0x80FFFFFF);
               else SetColor(0x80FF0000);
    glPushMatrix();
    glTranslated(balls[0].px,balls[0].py,0.0);
    DrawBall();
    glPopMatrix();
    glDisable(GL_BLEND);
  }

  if(show_speeds && state==STATE_ROLLING) {
    glDisable(GL_LIGHTING);
    for(i=0; i<=BallCount; ++i) if(balls[i].active && !balls[i].falling) {
      double speed=sqrt(sqr(balls[i].vx)+sqr(balls[i].vy));
      if(speed>0.0001) {
        speed=(BallRadius+0.5*speed)/speed;
        SetColor(ballcolors[i]);
        glBegin(GL_LINES);
          glVertex3d(balls[i].px,balls[i].py,0.0);
          glVertex3d(balls[i].px+speed*balls[i].vx,
                     balls[i].py+speed*balls[i].vy,
                     0.0);
        glEnd();
      }
    }
    glEnable(GL_LIGHTING);
  }

  qtrans=1.0-t+cue_fired;
  if(state==STATE_CUE || qtrans>0.0) {
    glPushMatrix();
    glDisable(GL_DEPTH_TEST);
    glDepthMask(GL_FALSE);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
    if(state==STATE_CUE) qtrans=0.3;
    glTranslated(cue_cx,cue_cy,0.0);
    glRotated(cue_angle,0.0,0.0,1.0);
    glTranslated(BallRadius+0.002+sqrt(cue_power*CuePowerVisFactor),0.0,0.0);
    glRotated(90.0,0.0,1.0,0.0);
#define DrawCue() do { \
      SetMaterial(1.0,128); glColor4d(0.75,0.68,0.3,qtrans); \
      gluCylinder(quad,0.0045,0.01,1.4,8,20); \
      SetMaterial(0.2,64); glColor4d(0.15,0.15,0.15,qtrans); \
      gluCylinder(quad,0.005,0.005,0.01,8,1); \
    } while(0)
    DrawCue();
    glDisable(GL_BLEND);
    glEnable(GL_DEPTH_TEST);
    glDepthMask(GL_TRUE);
    if(state==STATE_CUE) DrawCue();
    glPopMatrix();
    if(state==STATE_CUE && show_direction) {
      glPushMatrix();
      glTranslated(cue_cx,cue_cy,0.0);
      glRotated(cue_angle,0.0,0.0,1.0);
      glDisable(GL_LIGHTING);
      glEnable(GL_BLEND);
      glBlendFunc(GL_ONE,GL_ONE);
      glBegin(GL_LINES);
        SetColor(0xFFFFFF); glVertex3d( 0.0,0.0,0.0);
        SetColor(0x000000); glVertex3d(-3.0,0.0,0.0);
        SetColor(0x404040); glVertex3d( 0.0,-BallRadius,0.0);
        SetColor(0x000000); glVertex3d(-3.0,-BallRadius,0.0);
        SetColor(0x404040); glVertex3d( 0.0, BallRadius,0.0);
        SetColor(0x000000); glVertex3d(-3.0, BallRadius,0.0);
      glEnd();
      glDisable(GL_BLEND);
      glEnable(GL_LIGHTING);
      glPopMatrix();
    }
  }

  OverlayBegin();
  DrawMessage();
  if(BHelp.pos)  DrawHelp();
  if(BRules.pos) DrawRules();
  DrawStats();
  OverlayEnd();

  ++fps_frame_count;
  if (t>fps_last_update+FPSUpdateInterval) {
    char caption[256];
    snprintf(caption,256,"%s @ %.1f fps (Physics @ %.1f fps)",WindowCaption,
             fps_frame_count/(t-fps_last_update),
             fps_phys_count/(t-fps_last_update));
    glutSetWindowTitle(caption);
    fps_frame_count=fps_phys_count=0; fps_last_update=t;
  }
}
