#include "globals.h"
#include "ball.h"

GLuint LBall;

// IcoAngle=M_PI/6.5=27
#define IcoXY 0.8854560256532098959003755220151
#define IcoZ  0.4647231720437685456560153351331

static void IcoVertex(double r, double x, double y, double z, int wrap_u, int wrap_v) {
  if(wrap_v)
    glTexCoord2d(0.0,0.0);
  else if(wrap_u)
    glTexCoord2d(0.0,asin(z)/M_PI+0.5);
  else
    glTexCoord2d(atan2(y,x)/M_PI+1.0,asin(z)/M_PI+0.5);
  glNormal3d(x,y,z);
  glVertex3d(x*r,y*r,z*r);
}

static void IcoRec(double r, int level,
                   double x0, double y0, double z0,
                   double x1, double y1, double z1,
                   double x2, double y2, double z2) {
  if(level) {
    double x01=0.5*(x0+x1), y01=0.5*(y0+y1), z01=0.5*(z0+z1);
    double x12=0.5*(x1+x2), y12=0.5*(y1+y2), z12=0.5*(z1+z2);
    double x20=0.5*(x2+x0), y20=0.5*(y2+y0), z20=0.5*(z2+z0);
    Normalize3d(x01,y01,z01);
    Normalize3d(x12,y12,z12);
    Normalize3d(x20,y20,z20);
    IcoRec(r,level-1,  x0,y0,z0,     x01,y01,z01,  x20,y20,z20);
    IcoRec(r,level-1,  x01,y01,z01,  x1,y1,z1,     x12,y12,z12);
    IcoRec(r,level-1,  x20,y20,z20,  x12,y12,z12,  x2,y2,z2);
    IcoRec(r,level-1,  x01,y01,z01,  x12,y12,z12,  x20,y20,z20);
  } else {
    int wu=(y0*y1<0.0 || y1*y2<0.0 || y2*y0<0.0);
    int wv=(fabs(z0)>0.8 || fabs(z1)>0.8 || fabs(z2)>0.8);
    IcoVertex(r,x0,y0,z0,wu,wv);
    IcoVertex(r,x2,y2,z2,wu,wv);
    IcoVertex(r,x1,y1,z1,wu,wv);
  }
}

void Icosahedron(double r, int level) {
  int i;
  double x[13],y[13];
  for(i=0; i<13; ++i) {
    double a=(i-1)*0.2*M_PI;
    x[i]=IcoXY*sin(a);
    y[i]=IcoXY*cos(a);
  }
  glBegin(GL_TRIANGLES);
  //glPolygonMode(GL_FRONT_AND_BACK,GL_LINE);
  for(i=1; i<11; i+=2) {
    IcoRec(r,level,  0.0,     0.0,   1.0,
                     x[i],   y[i],   IcoZ,
                     x[i+2], y[i+2], IcoZ);
    IcoRec(r,level,  x[i],   y[i],   IcoZ,
                     x[i+1], y[i+1],-IcoZ,
                     x[i+2], y[i+2], IcoZ);
    IcoRec(r,level,  x[i],   y[i],   IcoZ,
                     x[i-1], y[i-1],-IcoZ,
                     x[i+1], y[i+1],-IcoZ);
    IcoRec(r,level,  x[i-1], y[i-1],-IcoZ,
                     0.0,     0.0,  -1.0,
                     x[i+1], y[i+1],-IcoZ);
  }
  glEnd();
  //glPolygonMode(GL_FRONT_AND_BACK,GL_FILL);
}

void InitBall(void) {
  cprintf(" Ball");
  LBall=glGenLists(1);
  glNewList(LBall,GL_COMPILE);
  Icosahedron(BallRadius,BallTesselationLevel);
  glEndList();
}

inline void DrawBall(void) {
  glCallList(LBall);
}
