/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public class Ball {
    private int x;
    private int y;
    private int width;
    private int height;
    private Canvas display;
    private int speedX;
    private int speedY;
    private boolean active;
    private boolean stuckToBat;

    public void hitBat(Bat bat, int n) {
        if (n == 3) {
            this.speedY *= -1;
            return;
        }
        if (n == 1) {
            this.speedX = this.speedX > 1 || this.speedX < -1 ? (this.speedX /= 2) : (this.speedX *= 2);
            this.speedY *= -1;
            if (this.speedX > 0) {
                this.speedX *= -1;
            }
            return;
        }
        if (n == 2) {
            this.speedX = this.speedX > 1 || this.speedX < -1 ? (this.speedX /= 2) : (this.speedX *= 2);
            this.speedY *= -1;
            if (this.speedX < 0) {
                this.speedX *= -1;
            }
        }
        this.y = bat.getY() - this.height;
    }

    public void hitBrick(int n) {
        if (n == 2 || n == 6) {
            this.speedY *= -1;
        } else if (n == 8 || n == 4) {
            this.speedX *= -1;
        } else {
            this.speedY *= -1;
            this.speedX *= -1;
        }
    }

    public void paint(Graphics graphics) {
        if (this.active) {
            graphics.setColor(0, 0, 255);
            graphics.fillArc(this.x, this.y, this.width, this.height, 0, 360);
            graphics.setColor(0, 0, 0);
            graphics.drawArc(this.x, this.y, this.width, this.height, 0, 360);
        }
    }

    public boolean getActive() {
        return this.active;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getSpeedX() {
        return this.speedX;
    }

    public int getSpeedY() {
        return this.speedY;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean getStuckToBat() {
        return this.stuckToBat;
    }

    public void moveBall() {
        this.x += this.speedX;
        this.y += this.speedY;
        if (this.speedX > 0) {
            if (this.x + this.width > this.display.getWidth()) {
                this.speedX *= -1;
                this.x = this.display.getWidth() - this.width;
            }
        } else if (this.x < 0) {
            this.speedX *= -1;
            this.x = 0;
        }
        if (this.speedY > 0) {
            if (this.y > this.display.getHeight()) {
                this.active = false;
            }
        } else if (this.y < 0) {
            this.speedY *= -1;
        }
    }

    public void moveWithBat(Bat bat) {
        this.x = bat.getX() + bat.getWidth() / 2 - this.width / 2;
        this.y = bat.getY() - this.height;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public void setLocation(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public void setStuckToBat(boolean bl) {
        this.stuckToBat = bl;
    }

    public void setDisplay(Canvas canvas) {
        this.display = canvas;
    }

    public void setSpeedX(int n) {
        this.speedX = n;
    }

    public void setSpeedY(int n) {
        this.speedY = n;
    }
}

